% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/17_ms2_plot4mass_dataset.R
\name{plot_ms2_matching}
\alias{plot_ms2_matching}
\title{Plot MS2 Matching Between Experimental and Library Spectra}
\usage{
plot_ms2_matching(
  object,
  variable_id,
  variable_index,
  database,
  polarity,
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  remove_fragment_intensity_cutoff = 0,
  interactive_plot = FALSE
)
}
\arguments{
\item{object}{A `mass_dataset` object that contains MS2 data and annotations.}

\item{variable_id}{Optional. A vector of variable IDs to be plotted.}

\item{variable_index}{Optional. A vector of variable indices to be plotted. Either `variable_id` or `variable_index` must be provided.}

\item{database}{A `databaseClass` object containing reference MS2 spectra for matching.}

\item{polarity}{Character. The ionization mode, either \code{"positive"} or \code{"negative"}. Default is \code{"positive"}.}

\item{ms1.match.ppm}{Numeric. The mass-to-charge (m/z) tolerance in parts per million (ppm) for MS1 matching. Default is 25.}

\item{ms2.match.ppm}{Numeric. The mass-to-charge (m/z) tolerance in parts per million (ppm) for MS2 matching. Default is 30.}

\item{mz.ppm.thr}{Numeric. The m/z threshold for fragment matching. Default is 400.}

\item{remove_fragment_intensity_cutoff}{Numeric. The intensity cutoff for removing low-intensity fragments. Default is 0.}

\item{interactive_plot}{Logical. If \code{TRUE}, an interactive plot using plotly is returned. Default is \code{FALSE}.}
}
\value{
A list of plots (either static or interactive) comparing experimental and reference MS2 spectra.
}
\description{
This function generates plots comparing MS2 spectra from experimental data with spectra from a reference database. It matches based on a set of user-specified parameters and provides visualizations with either static or interactive plots.
}
\details{
The function compares MS2 spectra from the experimental data (provided by the `mass_dataset` object) to those in the reference `database`. It generates matching plots for each of the specified variables and annotations. Users can specify either the `variable_id` or `variable_index` for plotting. The function supports both static and interactive visualizations.
}
\examples{
\dontrun{
# Example usage:
all_plots <- plot_ms2_matching(
  object = my_mass_dataset,
  variable_id = c("pRPLC_1112", "pRPLC_1860"),
  database = my_database
)
}

}
