% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18_mzIdentify_mass_dataset.R
\name{mzIdentify_mass_dataset}
\alias{mzIdentify_mass_dataset}
\title{Metabolite Identification in a mass_dataset Object Using MS1 Data}
\usage{
mzIdentify_mass_dataset(
  object,
  ms1.match.ppm = 25,
  rt.match.tol = 30,
  polarity = c("positive", "negative"),
  column = c("hilic", "rp"),
  candidate.num = 3,
  database,
  threads = 3
)
}
\arguments{
\item{object}{A `mass_dataset` object that contains MS1 data.}

\item{ms1.match.ppm}{A numeric value specifying the mass accuracy threshold for MS1 matching in parts per million (ppm). Defaults to `25`.}

\item{rt.match.tol}{A numeric value specifying the retention time matching tolerance in seconds. Defaults to `30`. If set to a large value (e.g., greater than `10000`), RT matching will not be performed.}

\item{polarity}{A character string specifying the ionization mode. It can be either `"positive"` or `"negative"`. Defaults to `"positive"`.}

\item{column}{A character string specifying the chromatographic column type, either `"hilic"` (hydrophilic interaction) or `"rp"` (reverse phase). Defaults to `"hilic"`.}

\item{candidate.num}{A numeric value specifying the number of top candidates to retain per feature. Defaults to `3`.}

\item{database}{A `databaseClass` object containing the reference spectral database for annotation.}

\item{threads}{An integer specifying the number of threads to use for parallel processing. Defaults to `3`.}
}
\value{
A data frame containing the metabolite identification results, including m/z error, RT error, matching scores, and information about the identified compounds.
}
\description{
This function identifies potential metabolites in a `mass_dataset` object by matching MS1 data (m/z) with a reference spectral database. Optionally, retention time (RT) can also be used for more accurate matching.
}
\details{
This function performs MS1-based matching between the experimental data in the `mass_dataset` object and a reference spectral database. The matching process is based on mass-to-charge ratio (m/z) and optionally retention time (RT). The function supports both positive and negative ionization modes and can work with either HILIC or reverse-phase columns.
}
\examples{
\dontrun{
# Perform MS1-based metabolite identification in a mass_dataset object
identification_result <- mzIdentify_mass_dataset(
  object = mass_object,
  ms1.match.ppm = 20,
  rt.match.tol = 30,
  polarity = "positive",
  database = reference_database,
  threads = 4
)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
