% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/103_deprecated_metIdentifyClass-methods.R
\name{ms2plot}
\alias{ms2plot}
\title{Get MS2 match plots from a metIdentifyClass object}
\usage{
ms2plot(
  object,
  database,
  which.peak = "all",
  ppm.tol = 30,
  mz.ppm.thr = 400,
  path = ".",
  width = 20,
  height = 8,
  interaction.plot = FALSE,
  range.mz,
  range.int = c(-1, 1),
  xlab = "Mass to charge ratio (m/z)",
  ylab = "Relative intensity",
  col.lib = "red",
  col.exp = "black",
  title.size = 15,
  lab.size = 12,
  axis.text.size = 12,
  legend.title.size = 12,
  legend.text.size = 10,
  figure.type = c("png", "pdf"),
  threads = 3,
  one.folder = TRUE,
  show.plot = TRUE
)
}
\arguments{
\item{object}{A metIdentifyClass object.}

\item{database}{Used database (databaseClass).}

\item{which.peak}{Peak name(s) or "all". You can use which_has_identification functions to get what peaks have identifications.}

\item{ppm.tol}{MS2 fragment match ppm.}

\item{mz.ppm.thr}{The threshold for m/z error calculation.}

\item{path}{Work directory.}

\item{width}{The width of MS2 spectra match figure (inch).}

\item{height}{The height of MS2 spectra match figure (inch).}

\item{interaction.plot}{Output interactive plot or not.}

\item{range.mz}{m/z range for MS2 spectra match plot.}

\item{range.int}{Relative intensity range.}

\item{xlab}{Title of x axis.}

\item{ylab}{Title of y axis.}

\item{col.lib}{Colour of database MS2 spectrum.}

\item{col.exp}{Colour of experimental MS2 spectrum.}

\item{title.size}{Font size of title.}

\item{lab.size}{Font size of title of axis.}

\item{axis.text.size}{Font size of axis text.}

\item{legend.title.size}{Legend title size.}

\item{legend.text.size}{Legend text size.}

\item{figure.type}{"pdf" or "png".}

\item{threads}{The number of threads}

\item{one.folder}{Output all figure in one folder or not.}

\item{show.plot}{Show plot or just save them.}
}
\value{
A or all ms2 match plot(s).
}
\description{
Get MS2 match plots from a metIdentifyClass object.
}
\seealso{
The example and demo data of this function can be found
\url{https://tidymass.github.io/metid/articles/metid.html}
}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
