% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/17_ms2_plot4mass_dataset.R
\name{ms2_plot_mass_dataset}
\alias{ms2_plot_mass_dataset}
\title{Plot MS2 Spectra for a Single Peak in a mass_dataset Object}
\usage{
ms2_plot_mass_dataset(
  object,
  variable_id,
  variable_index,
  polarity = c("positive", "negative"),
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  database,
  interactive_plot = FALSE
)
}
\arguments{
\item{object}{A `mass_dataset` object containing the peak data.}

\item{variable_id}{The ID of the peak to plot. Either `variable_id` or `variable_index` must be provided.}

\item{variable_index}{The index of the peak to plot. Either `variable_id` or `variable_index` must be provided.}

\item{polarity}{Character, ionization mode, either `"positive"` or `"negative"`. Defaults to `"positive"`.}

\item{ms1.match.ppm}{Numeric, mass accuracy threshold for MS1 matching in parts per million (ppm). Defaults to `25`.}

\item{ms2.match.ppm}{Numeric, mass accuracy threshold for MS2 matching in ppm. Defaults to `30`.}

\item{mz.ppm.thr}{Numeric, m/z threshold in ppm for matching MS1 and MS2. Defaults to `400`.}

\item{database}{A `databaseClass` object containing the reference spectral database for MS2 data.}

\item{interactive_plot}{Logical, if `TRUE`, generates an interactive plot using `plotly`. Defaults to `FALSE`.}
}
\value{
A list of MS2 spectra comparison plots for the specified peak, with one plot per matched annotation. If `interactive_plot = TRUE`, the plots are returned as interactive `plotly` plots.
}
\description{
This function generates MS2 spectra comparison plots for a single peak in a `mass_dataset` object by comparing experimental MS2 data with reference MS2 data from a spectral database.
}
\details{
This function retrieves the MS2 spectra for a specified peak and compares them to the reference MS2 spectra from a provided database. It generates a plot for each matched annotation, showing the experimental spectrum and the reference spectrum side by side.
}
\examples{
\dontrun{
# Plot MS2 spectra for a peak
ms2_plots <- ms2_plot_mass_dataset(
  object = mass_object,
  variable_id = "P001",
  database = reference_database
)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
