% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/53_ms2_spectra_matching_scores.R
\name{match_ms2_fragments}
\alias{match_ms2_fragments}
\title{Match MS2 Fragments}
\usage{
match_ms2_fragments(
  experimental.spectrum,
  library.spectrum,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  direction = c("reverse", "forward"),
  remove.noise = TRUE
)
}
\arguments{
\item{experimental.spectrum}{A data frame with `mz` and `intensity` columns representing the experimental MS2 spectrum.}

\item{library.spectrum}{A data frame with `mz` and `intensity` columns representing the reference MS2 spectrum.}

\item{ms2.match.ppm}{Numeric, mass tolerance in parts per million (ppm) for fragment matching. Default is 30 ppm.}

\item{mz.ppm.thr}{Numeric, minimum m/z threshold for ppm-based error calculation. Default is 400.}

\item{direction}{Character, either `"reverse"` (library to experimental matching) or `"forward"` (experimental to library matching). Default is `"reverse"`.}

\item{remove.noise}{Logical, whether to remove low-intensity fragment ions before matching. Default is `TRUE`.}
}
\value{
A data frame containing the matched fragment ions with the following columns:
\item{Lib.index}{Index of the fragment in the library spectrum.}
\item{Exp.index}{Index of the fragment in the experimental spectrum.}
\item{Lib.mz}{m/z value of the library fragment ion.}
\item{Lib.intensity}{Intensity of the library fragment ion.}
\item{Exp.mz}{m/z value of the experimental fragment ion.}
\item{Exp.intensity}{Intensity of the experimental fragment ion.}

Unmatched peaks in either spectrum are included with missing values (`NA`) in the corresponding columns.
}
\description{
Matches MS2 fragment ions between an experimental spectrum and a library spectrum.
}
\details{
This function aligns the fragment ions from an experimental MS2 spectrum with those from a library spectrum based on m/z similarity within a given ppm tolerance.

- If `direction = "reverse"`, the function looks for matches of each **library fragment ion** in the **experimental spectrum**.
- If `direction = "forward"`, the function looks for matches of each **experimental fragment ion** in the **library spectrum**.

If multiple matches are found for a given fragment, the most intense one is selected.
}
\examples{
# Example data for experimental and library MS2 spectra
experimental.spectrum <- data.frame(mz = c(100.1, 150.2, 200.3), intensity = c(300, 500, 200))
library.spectrum <- data.frame(mz = c(100.09, 150.25, 210.4), intensity = c(250, 600, 150))

# Perform MS2 fragment matching
matched_fragments <- match_ms2_fragments(
  experimental.spectrum = experimental.spectrum,
  library.spectrum = library.spectrum,
  ms2.match.ppm = 30,
  direction = "reverse"
)

print(matched_fragments)

}
\author{
Xiaotao Shen \email{xiaotao.shen@outlook.com}
}
