% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_tools4metaboliteIdentification.R
\name{identify_peak}
\alias{identify_peak}
\title{Identify a Peak in a Mass Spectrometry Dataset}
\usage{
identify_peak(
  idx,
  ms1.info,
  ms2.info,
  spectra.info,
  spectra.data,
  ppm.ms1match = 25,
  ppm.ms2match = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  rt.match.tol = 30,
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  total.score.tol = 0.5,
  adduct.table,
  candidate.num = 3,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  remove_fragment_intensity_cutoff = 0,
  ...
)
}
\arguments{
\item{idx}{The index of the peak to identify.}

\item{ms1.info}{A data frame containing MS1 information such as m/z and retention time (RT).}

\item{ms2.info}{A list containing MS2 spectra data for each peak.}

\item{spectra.info}{A data frame containing metadata about the reference spectra in the database.}

\item{spectra.data}{A list containing the MS2 spectra data from the reference database.}

\item{ppm.ms1match}{Numeric, mass accuracy threshold for MS1 matching in parts per million (ppm). Defaults to `25`.}

\item{ppm.ms2match}{Numeric, mass accuracy threshold for MS2 matching in ppm. Defaults to `30`.}

\item{mz.ppm.thr}{Numeric, m/z threshold in ppm for matching MS1 and MS2. Defaults to `400`.}

\item{ms2.match.tol}{Numeric, tolerance for MS2 fragment ion matching. Defaults to `0.5`.}

\item{rt.match.tol}{Numeric, retention time matching tolerance in seconds. Defaults to `30`.}

\item{ms1.match.weight}{Numeric, weight of MS1 matching in total score calculation. Defaults to `0.25`.}

\item{rt.match.weight}{Numeric, weight of RT matching in total score calculation. Defaults to `0.25`.}

\item{ms2.match.weight}{Numeric, weight of MS2 matching in total score calculation. Defaults to `0.5`.}

\item{total.score.tol}{Numeric, threshold for the total score. Defaults to `0.5`.}

\item{adduct.table}{A data frame containing the list of adducts to be considered for matching.}

\item{candidate.num}{Numeric, the number of top candidates to retain for each peak. Defaults to `3`.}

\item{fraction.weight}{Numeric, weight for the MS2 fragmentation score. Defaults to `0.3`.}

\item{dp.forward.weight}{Numeric, weight for the forward dot product in MS2 matching. Defaults to `0.6`.}

\item{dp.reverse.weight}{Numeric, weight for the reverse dot product in MS2 matching. Defaults to `0.1`.}

\item{remove_fragment_intensity_cutoff}{Numeric, intensity cutoff for removing low-intensity MS2 fragments. Defaults to `0`.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A data frame containing the identified peak and its matching results, including total score, m/z error, RT error, and matching scores.
}
\description{
This function identifies a potential metabolite peak in a mass spectrometry dataset by matching MS1 and MS2 data to a reference spectral database.
}
\details{
This function matches experimental MS1 and MS2 data with reference spectra in a spectral database. It calculates matching scores based on m/z, RT, and MS2 fragmentation pattern similarities. The function supports matching multiple adducts and considers weights for MS1, MS2, and RT matching in the total score calculation.
}
\examples{
\dontrun{
identified_peak <- identify_peak(
  idx = 1,
  ms1.info = ms1_data,
  ms2.info = ms2_spectra,
  spectra.info = reference_spectra_info,
  spectra.data = reference_spectra_data
)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
