% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/16_identify_ms2_only.R
\name{identify_ms2_only}
\alias{identify_ms2_only}
\title{Identify metabolites based on MS/MS database}
\usage{
identify_ms2_only(
  ms2.data,
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  rt.match.tol = 30,
  polarity = c("positive", "negative"),
  ce = "all",
  column = c("hilic", "rp"),
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  path = ".",
  total.score.tol = 0.5,
  candidate.num = 3,
  database,
  threads = 3
)
}
\arguments{
\item{ms2.data}{MS2 data, must be mgf, msp or mzXML format. For example, ms2.data = c("test.mgf", "test2.msp").}

\item{ms1.match.ppm}{Precursor match ppm tolerance.}

\item{ms2.match.ppm}{Fragment ion match ppm tolerance.}

\item{mz.ppm.thr}{Accurate mass tolerance for m/z error calculation.}

\item{ms2.match.tol}{MS2 match (MS2 similarity) tolerance.}

\item{fraction.weight}{The weight for matched fragments.}

\item{dp.forward.weight}{Forward dot product weight.}

\item{dp.reverse.weight}{Reverse dot product weight.}

\item{rt.match.tol}{RT match tolerance.}

\item{polarity}{The polarity of data, "positive"or "negative".}

\item{ce}{Collision energy. Please confirm the CE values in your database. Default is "all".}

\item{column}{"hilic" (HILIC column) or "rp" (reverse phase).}

\item{ms1.match.weight}{The weight of MS1 match for total score calculation.}

\item{rt.match.weight}{The weight of RT match for total score calculation.}

\item{ms2.match.weight}{The weight of MS2 match for total score calculation.}

\item{path}{Work directory.}

\item{total.score.tol}{Total score tolerance. The total score are refering to MS-DIAL.}

\item{candidate.num}{The number of candidate.}

\item{database}{MS2 database name or MS database.}

\item{threads}{Number of threads}
}
\value{
A metIdentifyClass object.
}
\description{
Identify metabolites based on MS2 data.
}
\seealso{
The example and demo data of this function can be found
\url{https://tidymass.github.io/metid/articles/metid.html}
}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
