% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{extract_ms2_database}
\alias{extract_ms2_database}
\title{Extract MS2 Spectra from a Database}
\usage{
extract_ms2_database(
  database,
  polarity = c("positive", "negative"),
  ce = "all"
)
}
\arguments{
\item{database}{A `databaseClass` object containing MS2 spectra data.}

\item{polarity}{Character. The ionization mode, either `"positive"` or `"negative"`. Default is `"positive"`.}

\item{ce}{Character or vector. The collision energy (CE) values to extract MS2 spectra for. Set to `"all"` to use all CE values in the database. Default is `"all"`.}
}
\value{
A list containing the extracted MS2 spectra for the specified polarity and CE values. If no matching spectra are found, the function returns `NULL`.
}
\description{
This function extracts MS2 spectra from a `databaseClass` object based on the specified polarity and collision energy (CE) values. It supports both positive and negative ionization modes, and allows users to filter by specific CE values or use all available CE values in the database.
}
\details{
The function checks the polarity and collision energy values against the available data in the provided `databaseClass` object. It extracts MS2 spectra corresponding to the specified polarity and filters them based on the given CE values. If the `ce` argument is set to `"all"`, all CE values in the database are used. If none of the requested CE values are available, the function returns `NULL`.
}
\examples{
\dontrun{
# Load a database
my_database <- load_database("path/to/database")

# Extract all MS2 spectra in positive ion mode
ms2_spectra <- extract_ms2_database(database = my_database,
polarity = "positive", ce = "all")

# Extract MS2 spectra for specific CE values in negative ion mode
ms2_spectra <- extract_ms2_database(database = my_database,
polarity = "negative", ce = c("10", "20"))
}


}
