% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{extract_database_name}
\alias{extract_database_name}
\title{Extract the Name of the Database}
\usage{
extract_database_name(database)
}
\arguments{
\item{database}{A `databaseClass` object containing database information.}
}
\value{
A character string representing the name of the database, formatted as `Source_Version`. Returns `NULL` if the input is not a `databaseClass` object.
}
\description{
This function extracts and formats the name of a database from a `databaseClass` object by combining the source and version information.
}
\details{
The function extracts the `Source` and `Version` fields from the `database.info` slot of the `databaseClass` object and combines them using an underscore (`_`). This formatted string represents the name of the database.
}
\examples{
\dontrun{
# Load a sample database
my_database <- load_database("path/to/database")

# Extract the name of the database
db_name <- extract_database_name(my_database)
print(db_name)  # Output might be "HMDB_4.0"
}


}
