% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_databaseClass-methods.R
\docType{class}
\name{databaseClass-class}
\alias{databaseClass-class}
\title{Class for Managing Spectral Database Information}
\description{
The `databaseClass` S4 class is designed to store and manage information
related to spectral databases. It contains slots for database metadata,
spectra information, and the actual spectral data.
}
\details{
This class is used to manage and organize spectral data within a larger analytical pipeline.
The `database.info` slot stores high-level metadata, while `spectra.info` and `spectra.data`
contain details and the actual spectral information, respectively.
}
\section{Slots}{

\describe{
\item{\code{database.info}}{A list containing metadata or general information about the database.}

\item{\code{spectra.info}}{A data frame that holds information about each spectrum,
such as identifiers or attributes. The data frame is initialized empty.}

\item{\code{spectra.data}}{A list where each element corresponds to a spectrum's data.}
}}

\examples{
# Creating an instance of the databaseClass
db_instance <- new("databaseClass")

# Accessing slots
db_instance@database.info
db_instance@spectra.info
db_instance@spectra.data

}
