% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_rtCorrection.R
\name{correct_database_rt}
\alias{correct_database_rt}
\title{Correct Retention Time (RT) in a Spectral Database}
\usage{
correct_database_rt(
  experiment.is.table,
  database.is.table,
  database,
  method = c("polyline", "loess"),
  poly = c(1, 2, 3, 4, 5),
  degree = c(1, 2),
  path = "."
)
}
\arguments{
\item{experiment.is.table}{A data frame containing the internal standards (IS) information from the experiment. It should include columns for retention time (RT) and other relevant information.}

\item{database.is.table}{A data frame containing the internal standards (IS) information from the database. It should include retention time (RT) values corresponding to the database spectra.}

\item{database}{A `databaseClass` object that contains the database to be corrected.}

\item{method}{A character string specifying the method for RT correction. Options are `"polyline"` for polynomial fitting or `"loess"` for loess smoothing. Defaults to `"polyline"`.}

\item{poly}{A numeric vector specifying the polynomial degrees to use for the correction when `method = "polyline"`. Defaults to `c(1, 2, 3, 4, 5)`.}

\item{degree}{A numeric vector specifying the degree for loess smoothing when `method = "loess"`. Defaults to `c(1, 2)`.}

\item{path}{A character string specifying the directory to save intermediate files. Defaults to the current directory (`"."`).}
}
\value{
A `databaseClass` object with corrected RT values.
}
\description{
This function corrects the retention time (RT) information in a spectral database using a reference table of internal standards from an experiment and a corresponding table from the database. The correction can be performed using different methods such as polynomial fitting or loess smoothing.
}
\details{
The function first writes a table of features from the database to a CSV file, which is used in the `correct_rt` function to perform the retention time correction based on the provided internal standards tables. The corrected RT values are then updated in the `databaseClass` object.

The `method` parameter allows the user to choose between polynomial fitting (`"polyline"`) and loess smoothing (`"loess"`) for the RT correction. The `poly` and `degree` parameters specify the details of the polynomial or loess fitting, respectively.

Intermediate files generated during the process are saved in the directory specified by `path`, but are removed after use.
}
\examples{
\dontrun{
# Correct RT in a database using polynomial fitting
corrected_db <- correct_database_rt(
  experiment.is.table = experiment_table,
  database.is.table = database_table,
  database = db_object,
  method = "polyline",
  poly = 1:3,
  degree = 2,
  path = "output_directory"
)
}


}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
