% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_construct_database.R
\name{construct_massbank_database}
\alias{construct_massbank_database}
\title{Construct a Spectral Database from MassBank Data}
\usage{
construct_massbank_database(
  file,
  only.remain.ms2 = TRUE,
  path = ".",
  version = "0.0.1",
  source = "MassBank",
  link = "https://massbank.eu/MassBank/",
  creater = "Xiaotao Shen",
  email = "xiaotao.shen@outlook.com",
  rt = FALSE,
  threads = 5
)
}
\arguments{
\item{file}{A character string specifying the path to the MassBank data file (MSP format).}

\item{only.remain.ms2}{A logical value indicating whether to retain only the metabolites with MS2 spectra. Defaults to `TRUE`.}

\item{path}{A character string specifying the path where the database will be saved. Defaults to the current working directory (`"."`).}

\item{version}{A character string specifying the version of the database. Defaults to `"0.0.1"`.}

\item{source}{A character string specifying the source of the database. Defaults to `"MassBank"`.}

\item{link}{A character string specifying the URL of the source database. Defaults to `"https://massbank.eu/MassBank/"`.}

\item{creater}{A character string specifying the creator of the database. Defaults to `"Xiaotao Shen"`.}

\item{email}{A character string specifying the email of the creator. Defaults to `"xiaotao.shen@outlook.com"`.}

\item{rt}{A logical value indicating whether retention time (RT) information is available. Defaults to `FALSE`.}

\item{threads}{An integer specifying the number of threads to use for parallel processing. Defaults to `5`.}
}
\value{
A `databaseClass` object containing the MassBank database, with metabolite information and MS2 spectral data.
}
\description{
This function constructs a spectral database from MassBank data, specifically formatted as a `databaseClass` object. The database contains metabolite information and MS2 spectral data for both positive and negative ionization modes.
}
\details{
The function reads MassBank data in MSP format and constructs a `databaseClass` object. It processes both positive and negative ionization modes, and optionally filters out metabolites that do not have MS2 spectra if `only.remain.ms2` is set to `TRUE`.

The MassBank data is organized into metabolite information and corresponding MS2 spectra. The spectra are stored in the `Spectra.positive` and `Spectra.negative` slots based on their ionization modes.
}
\examples{
\dontrun{
# Construct a database from a MassBank file
massbank_db <- construct_massbank_database(file = "MassBank.msp", only.remain.ms2 = TRUE)
}

}
