% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_construct_database.R
\name{construct_database}
\alias{construct_database}
\title{Construct a Mass Spectra Database}
\usage{
construct_database(
  path = ".",
  version = "0.0.1",
  metabolite.info.name = "metabolite.info.csv",
  source = "Shen Lab",
  link = "http://snyderlab.stanford.edu/",
  creater = "Xiaotao Shen",
  email = "xiaotao.shen@outlook.com",
  rt = TRUE,
  mz.tol = 15,
  rt.tol = 30,
  threads = 3
)
}
\arguments{
\item{path}{A character string specifying the path to the folder containing the metabolite information and MS2 data files. Defaults to the current working directory (`"."`).}

\item{version}{A character string specifying the version of the database. Defaults to `"0.0.1"`.}

\item{metabolite.info.name}{A character string specifying the file name of the metabolite information (CSV format). Defaults to `"metabolite.info.csv"`.}

\item{source}{A character string specifying the source of the database. Defaults to `"Shen Lab"`.}

\item{link}{A character string specifying the link to the source of the database. Defaults to `"http://snyderlab.stanford.edu/"`.}

\item{creater}{A character string specifying the creator of the database. Defaults to `"Xiaotao Shen"`.}

\item{email}{A character string specifying the email of the creator. Defaults to `"xiaotao.shen@outlook.com"`.}

\item{rt}{A logical value indicating whether the retention time (RT) information is available. Defaults to `TRUE`.}

\item{mz.tol}{A numeric value specifying the tolerance for matching the mass-to-charge ratio (m/z). Defaults to `15`.}

\item{rt.tol}{A numeric value specifying the tolerance for matching the retention time (RT). Defaults to `30`.}

\item{threads}{A numeric value specifying the number of threads to use for parallel processing. Defaults to `3`.}
}
\value{
A `databaseClass` object containing the constructed database, including metadata, spectra information, and MS2 spectral data for both positive and negative modes.
}
\description{
This function constructs a spectral database from provided metabolite information and MS2 spectra in both positive and negative modes. The database is created as a `databaseClass` object, including metadata, spectra information, and spectral data for metabolites.
}
\details{
The function reads the metabolite information and MS2 spectra from the specified path. It checks for the required files (`metabolite.info.csv`, `POS`, and `NEG` folders) and loads the MS2 data from mzXML or MGF files. The spectra are matched to the metabolites based on mass-to-charge ratio (m/z) and retention time (RT) tolerances.

- **Positive Mode**: The function reads and processes spectra files in the `POS` folder.
- **Negative Mode**: The function reads and processes spectra files in the `NEG` folder.

The function uses matching algorithms to associate the metabolites with their corresponding MS2 spectra, based on the provided tolerances.
}
\examples{
\dontrun{
# Construct a database from the current working directory
db <- construct_database(path = ".", version = "1.0.0", 
metabolite.info.name = "metabolite_info.csv")
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
