% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{calculate_rt_match_score}
\alias{calculate_rt_match_score}
\title{Calculate Retention Time (RT) Match Score}
\usage{
calculate_rt_match_score(RT.error, rt.match.tol = 30)
}
\arguments{
\item{RT.error}{Numeric vector. The RT error values between experimental and reference RT values.}

\item{rt.match.tol}{Numeric. The RT match tolerance in seconds. Default is 30.}
}
\value{
A numeric vector representing the RT match score for each RT error. The score is calculated using the formula: \eqn{exp(-0.5 * (RT.error / rt.match.tol)^2)}.
}
\description{
This function calculates the retention time (RT) match score based on the RT error and the RT match tolerance. The score is calculated using a Gaussian-like function.
}
\details{
The RT match score is computed using a Gaussian-like function where the RT error is normalized by the RT match tolerance (`rt.match.tol`). Lower RT errors result in higher match scores.
}
\examples{
\dontrun{
# Example RT errors
rt_errors <- c(5, 10, 2, 25)

# Calculate RT match scores with a default tolerance of 30 seconds
scores <- calculate_rt_match_score(RT.error = rt_errors, rt.match.tol = 30)
print(scores)
}


}
