% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{calculate_mz_match_score}
\alias{calculate_mz_match_score}
\title{Calculate m/z Match Score}
\usage{
calculate_mz_match_score(mz.error, ms1.match.ppm = 25)
}
\arguments{
\item{mz.error}{Numeric vector. The m/z error values between experimental and reference m/z values.}

\item{ms1.match.ppm}{Numeric. The MS1 match tolerance in parts per million (ppm). Default is 25.}
}
\value{
A numeric vector representing the m/z match score for each m/z error. The score is calculated using the formula: \eqn{exp(-0.5 * (mz.error / ms1.match.ppm)^2)}.
}
\description{
This function calculates the m/z match score based on the m/z error and the MS1 match tolerance in parts per million (ppm). The score is calculated using a Gaussian-like function.
}
\details{
The m/z match score is computed using a Gaussian-like function where the error is normalized by the MS1 match tolerance (`ms1.match.ppm`). Lower m/z errors result in higher match scores.
}
\examples{
\dontrun{
# Example m/z errors
mz_errors <- c(10, 15, 5, 20)

# Calculate m/z match scores with a default tolerance of 25 ppm
scores <- calculate_mz_match_score(mz.error = mz_errors, ms1.match.ppm = 25)
print(scores)
}


}
