% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/53_ms2_spectra_matching_scores.R
\name{calculate_ms2_matching_score}
\alias{calculate_ms2_matching_score}
\title{Calculate MS2 Spectra Matching Score}
\usage{
calculate_ms2_matching_score(
  experimental.spectrum,
  library.spectrum,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  method = c("dotproduct"),
  fraction.weight = 0.2,
  dp.forward.weight = 0.7,
  dp.reverse.weight = 0.1,
  remove_fragment_intensity_cutoff = 0
)
}
\arguments{
\item{experimental.spectrum}{A data frame representing the experimental spectrum, with columns `mz` for mass-to-charge ratios and `intensity` for corresponding intensities.}

\item{library.spectrum}{A data frame representing the library spectrum, with columns `mz` for mass-to-charge ratios and `intensity` for corresponding intensities.}

\item{ms2.match.ppm}{Numeric. The mass tolerance in parts per million (ppm) for matching MS2 fragments. Default is 30.}

\item{mz.ppm.thr}{Numeric. Threshold for m/z to use in ppm calculation. Default is 400.}

\item{method}{Character. The method to calculate the matching score. Currently, only "dotproduct" is supported. Default is "dotproduct".}

\item{fraction.weight}{Numeric. The weight of the fraction of matched fragments in the overall score. Default is 0.2.}

\item{dp.forward.weight}{Numeric. The weight for the forward dot product score in the overall score. Default is 0.7.}

\item{dp.reverse.weight}{Numeric. The weight for the reverse dot product score in the overall score. Default is 0.1.}

\item{remove_fragment_intensity_cutoff}{Numeric. A cutoff value to remove low-intensity fragments from both experimental and library spectra. Default is 0.}
}
\value{
A numeric value representing the MS2 matching score, which is a weighted combination of the forward dot product score, reverse dot product score, and the fraction of matched fragments.
}
\description{
This function computes the matching score between experimental and library MS2 spectra using the dot product method. The function allows for fragment matching based on mass-to-charge ratio (m/z) tolerance and intensity comparison, and calculates the score based on forward and reverse dot product and the fraction of matched fragments.
}
\details{
The function normalizes the intensities of both the experimental and library spectra and filters out fragments below the specified intensity cutoff. It then calculates the matching score based on the dot product method. The forward dot product score is calculated using all matched fragments, while the reverse dot product score is computed using only the fragments that have non-zero intensity in the library spectrum.
}
\examples{
experimental.spectrum <- data.frame(mz = 1:10, intensity = 1:10)
library.spectrum <- data.frame(mz = 1:10, intensity = 1:10)
get_spectra_match_score(experimental.spectrum, library.spectrum)

}
\author{
Xiaotao Shen \email{xiaotao.shen@outlook.com}
}
