% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/53_ms2_spectra_matching_scores.R
\name{calculate_dotproduct}
\alias{calculate_dotproduct}
\title{Calculate Dot Product Score for MS2 Spectra}
\usage{
calculate_dotproduct(exp.int, lib.int)
}
\arguments{
\item{exp.int}{A numeric vector of intensities from the experimental spectrum.}

\item{lib.int}{A numeric vector of intensities from the library spectrum.}
}
\value{
A numeric value representing the dot product similarity score between the experimental and library spectra.
}
\description{
This function calculates the dot product score between experimental and library MS2 spectra intensities. It weights the intensities and computes the similarity score using a modified dot product formula.
}
\details{
The function applies a custom weighting scheme to the experimental and library intensities, where the weight for each intensity value is computed based on its proportion relative to the total sum of intensities in its respective spectrum. The weighted intensities are then used to calculate the dot product score, which is normalized to give a similarity score between the two spectra.
}
\examples{
calculate_dotproduct(exp.int = 1:10, lib.int = 1:10)

}
\author{
Xiaotao Shen \email{xiaotao.shen@outlook.com}
}
