% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15_annotate_single_peak_mass_dataset.R
\name{annotate_single_peak_mass_dataset}
\alias{annotate_single_peak_mass_dataset}
\title{Annotate a Single Peak in a mass_dataset Object}
\usage{
annotate_single_peak_mass_dataset(
  object,
  variable_id,
  variable_index,
  based_on_rt = TRUE,
  based_on_ms2 = TRUE,
  add_to_annotation_table = FALSE,
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  rt.match.tol = 30,
  polarity = c("positive", "negative"),
  ce = "all",
  column = c("rp", "hilic"),
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  total.score.tol = 0.5,
  candidate.num = 3,
  database,
  threads = 3
)
}
\arguments{
\item{object}{A `mass_dataset` object containing the peak data to annotate.}

\item{variable_id}{The ID of the peak to annotate. Either `variable_id` or `variable_index` must be provided.}

\item{variable_index}{The index of the peak to annotate. Either `variable_id` or `variable_index` must be provided.}

\item{based_on_rt}{Logical, if `TRUE` (default), retention time will be used for matching.}

\item{based_on_ms2}{Logical, if `TRUE` (default), MS2 spectra will be used for matching if available.}

\item{add_to_annotation_table}{Logical, if `TRUE`, the annotation results will be added to the annotation table in the object. Defaults to `FALSE`.}

\item{ms1.match.ppm}{Numeric, mass accuracy threshold for MS1 matching in parts per million (ppm). Defaults to `25`.}

\item{ms2.match.ppm}{Numeric, mass accuracy threshold for MS2 matching in ppm. Defaults to `30`.}

\item{mz.ppm.thr}{Numeric, m/z threshold in ppm for matching MS1 and MS2. Defaults to `400`.}

\item{ms2.match.tol}{Numeric, tolerance for MS2 fragment ion matching. Defaults to `0.5`.}

\item{fraction.weight}{Numeric, weight for the MS2 fragmentation score. Defaults to `0.3`.}

\item{dp.forward.weight}{Numeric, weight for the forward dot product in MS2 matching. Defaults to `0.6`.}

\item{dp.reverse.weight}{Numeric, weight for the reverse dot product in MS2 matching. Defaults to `0.1`.}

\item{rt.match.tol}{Numeric, retention time matching tolerance in seconds. Defaults to `30`.}

\item{polarity}{Character, ionization mode, either `"positive"` or `"negative"`. Defaults to `"positive"`.}

\item{ce}{Character, collision energy for MS2 matching. Defaults to `"all"`.}

\item{column}{Character, chromatographic column type, either `"rp"` (reverse phase) or `"hilic"`. Defaults to `"rp"`.}

\item{ms1.match.weight}{Numeric, weight of MS1 matching in total score calculation. Defaults to `0.25`.}

\item{rt.match.weight}{Numeric, weight of RT matching in total score calculation. Defaults to `0.25`.}

\item{ms2.match.weight}{Numeric, weight of MS2 matching in total score calculation. Defaults to `0.5`.}

\item{total.score.tol}{Numeric, threshold for the total score. Defaults to `0.5`.}

\item{candidate.num}{Numeric, the number of top candidates to retain for each peak. Defaults to `3`.}

\item{database}{A `databaseClass` object containing the reference spectral database for annotation.}

\item{threads}{Numeric, the number of threads to use for parallel processing. Defaults to `3`.}
}
\value{
Either the `mass_dataset` object with updated annotation table or a data frame containing the annotation results for the specified peak.
}
\description{
This function annotates a single peak in a `mass_dataset` object using MS1 and optionally MS2 data. It allows for matching with a reference database based on m/z, retention time (RT), and MS2 fragmentation patterns.
}
\details{
This function performs peak annotation using MS1 data and optionally MS2 data for a single peak in a `mass_dataset` object. The matching process is based on m/z, retention time, and MS2 spectra comparison with a reference database. The results can either be returned as a data frame or added to the annotation table in the `mass_dataset` object.
}
\examples{
\dontrun{
# Annotate a single peak using MS1 and MS2 data
annotation <- annotate_single_peak_mass_dataset(
  object = mass_object,
  variable_id = "P001",
  database = reference_database,
  based_on_rt = TRUE,
  based_on_ms2 = TRUE
)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
