import 'dart:math';

import 'package:app/app.dart';
import 'package:components/components.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:toly_ui/toly_ui.dart';
import 'package:utils/utils.dart';
import 'package:widget_module/blocs/action/widget_action.dart';
import 'package:widget_module/blocs/blocs.dart';
import 'package:widget_repository/widget_repository.dart';
import 'package:widget_ui/widget_ui.dart';

class SliverWidgetDetailBar extends StatelessWidget {
  final WidgetModel model;

  const SliverWidgetDetailBar({Key? key, required this.model})
      : super(key: key);

  final Color backgroundColor = const Color(0xffFAFAFA);
  static const Color textColor = Color(0xff262626);

  @override
  Widget build(BuildContext context) {
    bool isDark = Theme.of(context).brightness == Brightness.dark;
    Color? appBarColor = Theme.of(context).appBarTheme.backgroundColor;
    Color? appBarTextColor = Theme.of(context).appBarTheme.titleTextStyle?.color;


    return SliverAppBar(
      pinned: true,
      backgroundColor: isDark? appBarColor:backgroundColor,
      titleTextStyle:  TextStyle(color:isDark?appBarTextColor: textColor),
      iconTheme:  isDark? null:const IconThemeData(color: textColor),
      centerTitle: false,
      expandedHeight: 120.0,
      scrolledUnderElevation: 0.5,
      flexibleSpace: DiyFlexibleSpaceBar(
        centerTitle: false,
        expandedTitleScale: 2,
        titleIconBuilder: (t) => WindmillWidget(
          rotate: t * 2 * pi * 2,
          radius: 15,
        ),
        fixedSubtitle: Text(
          model.name,
          style:  TextStyle(color: isDark?appBarTextColor:Color(0xff696969), fontSize: 12),
        ),
        title: Padding(
          padding: const EdgeInsets.only(bottom: 3),
          child: Text(
            model.nameCN,
            style:  TextStyle( fontSize: 16,color:isDark?appBarTextColor: textColor),
          ),
        ),
        //伸展处布局
        titlePadding: const EdgeInsets.only(left: 20, bottom: 10),
        //标题边距
        collapseMode: CollapseMode.parallax,
      ),
      elevation: 0,
      actions: [
        _buildToHome(context),
        FeedbackWidget(
          onPressed: () => context.toggleLike(model.id),
          child: BlocConsumer<LikeWidgetBloc, List<WidgetModel>>(
            listener: _listenLikeStateChange,
            builder: _buildByLikeState,
          ),
        )
      ],
    );
  }


  // 监听 LikeWidgetBloc 伺机弹出 toast
  void _listenLikeStateChange(BuildContext context, List<WidgetModel> state) {
    bool collected = state.contains(model);
    String msg =
        collected ? "收藏【${model.name}】组件成功!" : "已取消【${model.name}】组件收藏!";
    Toast.toast(
      context,
      msg,
      duration: Duration(milliseconds: collected ? 1500 : 600),
      action: collected
          ? SnackBarAction(
              textColor: Colors.white,
              label: '收藏夹管理',
              onPressed: () => Scaffold.of(context).openEndDrawer())
          : null,
    );
  }

  // 根据 [LikeWidgetState ] 构建图标
  Widget _buildByLikeState(BuildContext context,  List<WidgetModel> state) {
    bool liked = state.contains(model);
    return Padding(
      padding: const EdgeInsets.only(right: 20.0),
      child: Icon(
        liked ? TolyIcon.icon_star_ok : TolyIcon.icon_star_add,
        size: 25,
      ),
    );
  }

  Widget _buildToHome(BuildContext context) => GestureDetector(
      onLongPress: () => Scaffold.of(context).openEndDrawer(),
      child: const Padding(
        padding: EdgeInsets.all(15.0),
        child: Icon(Icons.home),
      ),
      onTap: () => Navigator.of(context).pop());
}
