/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.draw;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mat;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Quat;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.Tmp;
import arclibrary.graphics.Draw3d;
import arclibrary.graphics.EDraw;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class Draw3dSpin
extends DrawBlock {
    protected static final Mat3D transformation = new Mat3D();
    protected static final FloatSeq transformationQueue = new FloatSeq();
    protected static final Vec2 tmpPixelOffset = new Vec2();
    protected static final Vec2 tmpRotatedBaseOffset = new Vec2();
    private static final Quat tmpQuat1 = new Quat();
    private static final Quat tmpQuat2 = new Quat();
    private static final Mat3D tmpMat1 = new Mat3D();
    private static final FrameBuffer shadowBuffer = new FrameBuffer();
    public static final Seq<Runnable> runs = new Seq();
    public static Cons<Runnable> proc = run -> {
        if (run != null) {
            runs.add(run);
        }
    };
    public final Vec2 baseOffset = new Vec2();
    public final Vec3 scale = new Vec3(1.0f, 1.0f, 1.0f);
    public float rotateSpeed = 4.0f;
    public float startRotationOffset = 225.0f;
    public float pixelSize = 0.125f;
    public Floatf<Building> rotationProvider;
    public Vec3 axis = Vec3.Y;
    public float rotationAroundAxis = -45.0f;
    public int regionWidth = 6;
    public int shadowElevation = 8;
    public TextureRegion baseRegion;
    public TextureRegion rotorRegion;
    public String baseSuffix;
    public String rotorSuffix;

    public static void draw(Runnable run) {
        if (proc != null) {
            proc.get((Object)run);
        }
    }

    public Draw3dSpin(String baseSuffix, String rotorSuffix) {
        this.baseSuffix = baseSuffix;
        this.rotorSuffix = rotorSuffix;
    }

    private static void setScale(float[] val, float x, float y, float z) {
        val[0] = x;
        val[5] = y;
        val[10] = z;
        val[15] = 1.0f;
        for (int i = 0; i < 4; ++i) {
            val[i + 1] = 0.0f;
            val[i + 6] = 0.0f;
            val[i + 11] = 0.0f;
        }
    }

    public float baseRotation(Building building) {
        return this.rotationProvider == null ? 0.0f : (360.0f - this.rotationProvider.get((Object)building) % 360.0f) % 360.0f;
    }

    public <T extends Building> Draw3dSpin rotationProvider(Floatf<T> rotationProvider) {
        this.rotationProvider = rotationProvider;
        return this;
    }

    public void load(Block block) {
        this.baseRegion = Core.atlas.find(block.name + this.baseSuffix);
        this.rotorRegion = Core.atlas.find(block.name + this.rotorSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Building build) {
        float startZ = Draw.z();
        try {
            float realWidth = (float)this.rotorRegion.width * this.rotorRegion.scl() * Draw.xscl;
            float realHeight = (float)this.rotorRegion.height * this.rotorRegion.scl() * Draw.yscl;
            float baseRotation = this.baseRotation(build);
            float time = build.totalProgress() * this.rotateSpeed;
            float mainRotation = time % 90.0f + this.startRotationOffset;
            float subRotation = time % 90.0f - 90.0f + this.startRotationOffset;
            transformation.idt();
            float baseCos = Mathf.cosDeg((float)baseRotation);
            float baseSin = Mathf.sinDeg((float)baseRotation);
            Mat baseRotationMatrix = Tmp.m1.setToRotation(Vec3.Z, baseCos, baseSin);
            Vec3 tmp = Tmp.v31;
            tmp.set(this.axis).mul(baseRotationMatrix);
            tmpQuat2.setFromAxis(tmp, this.rotationAroundAxis);
            tmpQuat1.setFromAxis(tmpQuat2.transform(tmp.set(0.0f, 0.0f, 1.0f)), baseRotation);
            transformation.rotate(tmpQuat2);
            tmp.set(1.0f, 1.0f, 1.0f).sub(this.scale).mul(baseRotationMatrix);
            Mat3D mat3D = tmpMat1;
            Draw3dSpin.setScale(mat3D.val, 1.0f - tmp.x * tmp.x, 1.0f - tmp.y * tmp.y, 1.0f - tmp.z * tmp.z);
            transformation.mul(mat3D);
            mat3D.idt();
            mat3D.rotate(Vec3.Z, baseRotation);
            transformation.mul(mat3D);
            baseRotationMatrix.scale(1.0f, -1.0f);
            float alpha = Mathf.mod((float)time, (float)90.0f) / 90.0f;
            float finalBaseRotation = baseRotation = Mathf.mod((float)baseRotation, (float)180.0f);
            Vec2 pixelOffset = tmpPixelOffset.set(-this.pixelSize, 0.0f).mul(baseRotationMatrix);
            Vec2 baseOffset = tmpRotatedBaseOffset.set(this.baseOffset).mul(baseRotationMatrix);
            int halfRegionWidth = this.regionWidth / 2;
            float drawX = build.x + baseOffset.x + pixelOffset.x * (float)halfRegionWidth - realWidth / 2.0f;
            float drawY = build.y + baseOffset.y + pixelOffset.y * (float)halfRegionWidth - realHeight / 2.0f;
            int myIndex = Draw3dSpin.transformationQueue.size;
            transformationQueue.addAll(Draw3dSpin.transformation.val);
            Draw3dSpin.draw(() -> {
                Draw.color();
                System.arraycopy(Draw3dSpin.transformationQueue.items, myIndex, Draw3dSpin.transformation.val, 0, Draw3dSpin.transformation.val.length);
                float localDrawX = drawX;
                float localDrawY = drawY;
                for (int i = halfRegionWidth; i >= -halfRegionWidth; --i) {
                    Draw3d.rect(transformation, this.rotorRegion, localDrawX - (float)this.shadowElevation, localDrawY - (float)this.shadowElevation, realWidth, realHeight, mainRotation);
                    Draw3d.rect(transformation, this.rotorRegion, localDrawX - (float)this.shadowElevation, localDrawY - (float)this.shadowElevation, realWidth, realHeight, subRotation);
                    localDrawX -= pixelOffset.x;
                    localDrawY -= pixelOffset.y;
                }
                Lines.stroke((float)2.0f);
                Draw.rect((TextureRegion)this.baseRegion, (float)(build.x - (float)this.shadowElevation), (float)(build.y - (float)this.shadowElevation), (float)(-finalBaseRotation));
                Lines.line((float)build.x, (float)build.y, (float)(build.x - (float)this.shadowElevation), (float)(build.y - (float)this.shadowElevation));
                Draw.color();
            });
            Draw.z((float)70.1f);
            float a = Draw.getColor().a;
            Draw.rect((TextureRegion)this.baseRegion, (float)build.x, (float)build.y, (float)(-finalBaseRotation));
            Draw.alpha((float)(finalBaseRotation / 180.0f * a));
            Draw.rect((TextureRegion)this.baseRegion, (float)build.x, (float)build.y, (float)(-finalBaseRotation - 180.0f));
            float localDrawX = drawX;
            float localDrawY = drawY;
            for (int i = halfRegionWidth; i >= -halfRegionWidth; --i) {
                Draw.alpha((float)1.0f);
                Draw3d.rect(transformation, this.rotorRegion, localDrawX, localDrawY, realWidth, realHeight, mainRotation);
                Draw.alpha((float)alpha);
                Draw3d.rect(transformation, this.rotorRegion, localDrawX, localDrawY, realWidth, realHeight, subRotation);
                localDrawX -= pixelOffset.x;
                localDrawY -= pixelOffset.y;
            }
        }
        finally {
            Draw.z((float)startZ);
        }
    }

    static {
        Events.run((Object)EventType.Trigger.draw, () -> {
            shadowBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            if (runs.isEmpty()) {
                return;
            }
            Seq buffer = runs.copy();
            runs.clear();
            Draw.draw((float)33.0f, () -> {
                Draw.flush();
                shadowBuffer.begin(Color.clear);
                buffer.each(Runnable::run);
                shadowBuffer.end();
                Draw.color((Color)Pal.shadow, (float)Pal.shadow.a);
                EDraw.drawBuffer(shadowBuffer);
                Draw.flush();
                Draw.color();
            });
        });
        Events.run((Object)EventType.Trigger.postDraw, () -> {
            Draw3dSpin.transformationQueue.size = 0;
        });
    }
}

