/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.consumers;

import arc.Core;
import arc.math.Mathf;
import arc.util.Strings;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stats;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;

public class PressureEfficiencyRange
extends Consume {
    public float startRange;
    public float endRange;
    public float efficiencyMultiplier;
    public boolean reverse;

    public PressureEfficiencyRange(float startRange, float endRange, float efficiencyMultiplier, boolean reverse) {
        this.startRange = startRange;
        this.endRange = endRange;
        this.efficiencyMultiplier = efficiencyMultiplier;
        this.reverse = reverse;
    }

    public void apply(Block block) {
        block.hasLiquids = true;
    }

    public HasPressure cast(Building build) {
        try {
            return (HasPressure)build;
        }
        catch (Exception e) {
            throw new RuntimeException("This consumer should be used on a building that implements HasPressure", e);
        }
    }

    public void display(Stats stats) {
        stats.add(OlStats.pressureRange, Core.bundle.get("stat.omaloon-pressurerange.format"), new Object[]{Strings.autoFixed((float)this.startRange, (int)2), Strings.autoFixed((float)this.endRange, (int)2)});
    }

    public float efficiency(Building build) {
        return this.shouldConsume(this.cast(build)) ? 1.0f : 0.0f;
    }

    public float efficiencyMultiplier(Building build) {
        if (!this.shouldConsume(this.cast(build))) {
            return 0.0f;
        }
        if (this.reverse) {
            return Mathf.maxZero((float)Mathf.map((float)this.cast(build).getPressure(), (float)this.endRange, (float)this.startRange, (float)1.0f, (float)this.efficiencyMultiplier));
        }
        return Mathf.maxZero((float)Mathf.map((float)this.cast(build).getPressure(), (float)this.startRange, (float)this.endRange, (float)1.0f, (float)this.efficiencyMultiplier));
    }

    public boolean shouldConsume(HasPressure build) {
        int pressure = Math.round(build.getPressure());
        return this.startRange <= (float)pressure && (float)pressure <= this.endRange;
    }
}

