/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.consumers;

import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stats;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;

public class ConsumePressure
extends Consume {
    public float amount;
    public boolean continuous;

    public ConsumePressure(float amount, boolean continuous) {
        this.amount = amount;
        this.continuous = continuous;
    }

    public HasPressure cast(Building build) {
        try {
            return (HasPressure)build;
        }
        catch (Exception e) {
            throw new RuntimeException("This consumer should be used on a building that implements HasPressure", e);
        }
    }

    public void apply(Block block) {
        block.hasLiquids = true;
    }

    public void display(Stats stats) {
        if (this.continuous) {
            stats.add(OlStats.consumePressure, (float)Mathf.round((float)(this.amount * 60.0f), (int)2), OlStats.pressureSecond);
        } else {
            stats.add(OlStats.consumePressure, (float)Mathf.round((float)this.amount, (int)2), OlStats.pressureUnits);
        }
    }

    public void trigger(Building build) {
        if (!this.continuous) {
            this.cast(build).removePressure(this.amount);
        }
    }

    public void update(Building build) {
        if (this.continuous) {
            this.cast(build).removePressure(this.amount * Time.delta);
        }
    }
}

