/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.storage;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Player;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class GlassmoreCoreBlock
extends CoreBlock {
    public float spawnCooldown = 120.0f;

    public GlassmoreCoreBlock(String name) {
        super(name);
    }

    public class DelayedSpawnCoreBuild
    extends CoreBlock.CoreBuild {
        public float timer;
        public boolean requested;
        public float heat;
        public float progress;
        public float time;
        public Player spawnPlayer;
        public boolean animating;
        public boolean justSpawned;

        public DelayedSpawnCoreBuild() {
            super((CoreBlock)GlassmoreCoreBlock.this);
            this.timer = 0.0f;
            this.requested = false;
            this.animating = false;
            this.justSpawned = false;
        }

        public void draw() {
            super.draw();
            if ((this.heat > 0.001f || this.animating) && !this.justSpawned) {
                this.drawRespawn();
            }
        }

        public void updateTile() {
            super.updateTile();
            if (this.timer > 0.0f) {
                this.timer -= Time.delta;
            }
            if (this.spawnPlayer != null || this.animating) {
                this.heat = Mathf.lerpDelta((float)this.heat, (float)1.0f, (float)0.1f);
                this.time += Time.delta;
                this.progress += 1.0f / GlassmoreCoreBlock.this.spawnCooldown * Time.delta;
                if (this.progress >= 1.0f) {
                    if (this.spawnPlayer != null && this.spawnPlayer.dead()) {
                        CoreBlock.playerSpawn((Tile)this.tile, (Player)this.spawnPlayer);
                        this.justSpawned = true;
                    }
                    this.animating = false;
                    this.spawnPlayer = null;
                    this.requested = false;
                }
            } else {
                this.heat = Mathf.lerpDelta((float)this.heat, (float)0.0f, (float)0.1f);
                if (this.justSpawned && this.heat <= 0.001f) {
                    this.justSpawned = false;
                }
            }
        }

        public void requestSpawn(Player player) {
            if (Vars.state.isEditor()) {
                this.spawnPlayer = player;
                CoreBlock.playerSpawn((Tile)this.tile, (Player)this.spawnPlayer);
            } else if (!this.requested && player.dead() && !this.justSpawned) {
                this.timer = GlassmoreCoreBlock.this.spawnCooldown;
                this.requested = true;
                this.spawnPlayer = player;
                this.progress = 0.0f;
                this.time = 0.0f;
                this.heat = 0.0f;
                this.animating = true;
            }
        }

        void drawRespawn() {
            Draw.color((Color)Pal.darkMetal);
            Lines.stroke((float)(2.0f * this.heat));
            Fill.poly((float)this.x, (float)this.y, (int)4, (float)(10.0f * this.heat));
            Draw.reset();
            if (this.spawnPlayer != null) {
                TextureRegion region = this.spawnPlayer.icon();
                Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.4f * this.progress));
                Draw.rect((String)"circle-shadow", (float)this.x, (float)this.y, (float)((float)region.width / 3.0f), (float)((float)region.height / 3.0f));
                Draw.color();
                Draw.draw((float)Draw.z(), () -> Drawf.construct((Building)this, (TextureRegion)region, (float)0.0f, (float)this.progress, (float)this.progress, (float)this.timer));
                Draw.color((Color)Pal.accentBack);
                float pos = Mathf.sin((float)this.time, (float)6.0f, (float)8.0f);
                Lines.lineAngleCenter((float)(this.x + pos), (float)this.y, (float)90.0f, (float)(16.0f - Math.abs(pos) * 2.0f));
                Draw.reset();
            }
            Lines.stroke((float)(2.0f * this.heat));
            Draw.color((Color)Pal.accentBack);
            Lines.poly((float)this.x, (float)this.y, (int)4, (float)(8.0f * this.heat));
            float oy = -7.0f;
            float len = 6.0f * this.heat;
            Lines.stroke((float)5.0f);
            Draw.color((Color)Pal.darkMetal);
            Lines.line((float)(this.x - len), (float)(this.y + oy), (float)(this.x + len), (float)(this.y + oy));
            for (int i : Mathf.signs) {
                Fill.tri((float)(this.x + len * (float)i), (float)(this.y + oy - Lines.getStroke() / 2.0f), (float)(this.x + len * (float)i), (float)(this.y + oy + Lines.getStroke() / 2.0f), (float)(this.x + (len + Lines.getStroke() * this.heat) * (float)i), (float)(this.y + oy));
            }
            Lines.stroke((float)3.0f);
            Draw.color((Color)Pal.accent);
            Lines.line((float)(this.x - len), (float)(this.y + oy), (float)(this.x - len + len * 2.0f * this.progress), (float)(this.y + oy));
            Draw.reset();
        }
    }
}

