/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.production;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.production.Drill;
import mindustry.world.consumers.Consume;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureDrill
extends Drill {
    public PressureConfig pressureConfig = new PressureConfig();
    public boolean useConsumerMultiplier = true;

    public PressureDrill(String name) {
        super(name);
        this.pressureConfig.isWhitelist = true;
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
    }

    public class PressureDrillBuild
    extends Drill.DrillBuild
    implements HasPressure {
        PressureModule pressure;

        public PressureDrillBuild() {
            super((Drill)PressureDrill.this);
            this.pressure = new PressureModule();
        }

        public float efficiencyMultiplier() {
            float val = 1.0f;
            if (!PressureDrill.this.useConsumerMultiplier) {
                return val;
            }
            for (Consume consumer : PressureDrill.this.consumers) {
                val *= consumer.efficiencyMultiplier((Building)this);
            }
            return val;
        }

        public float efficiencyScale() {
            return super.efficiencyScale() * this.efficiencyMultiplier();
        }

        public float getProgressIncrease(float baseTime) {
            return super.getProgressIncrease(baseTime) * this.efficiencyMultiplier();
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureDrill.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        public void updateTile() {
            super.updateTile();
            this.updatePressure();
            this.dumpPressure();
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

