/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.production;

import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.consumers.Consume;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureCrafter
extends GenericCrafter {
    public PressureConfig pressureConfig = new PressureConfig();
    public boolean useConsumerMultiplier = true;
    public float outputPressure = 0.0f;

    public PressureCrafter(String name) {
        super(name);
        this.pressureConfig.isWhitelist = true;
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
        if (this.outputPressure != 0.0f) {
            this.stats.add(OlStats.outputPressure, Strings.autoFixed((float)this.outputPressure, (int)2), new Object[]{OlStats.pressureUnits});
        }
    }

    public class PressureCrafterBuild
    extends GenericCrafter.GenericCrafterBuild
    implements HasPressure {
        PressureModule pressure;

        public PressureCrafterBuild() {
            super((GenericCrafter)PressureCrafter.this);
            this.pressure = new PressureModule();
        }

        public float efficiencyMultiplier() {
            float val = 1.0f;
            if (!PressureCrafter.this.useConsumerMultiplier) {
                return val;
            }
            for (Consume consumer : PressureCrafter.this.consumers) {
                val *= consumer.efficiencyMultiplier((Building)this);
            }
            return val;
        }

        public float efficiencyScale() {
            return super.efficiencyScale() * this.efficiencyMultiplier();
        }

        public float getProgressIncrease(float baseTime) {
            return super.getProgressIncrease(baseTime) * this.efficiencyMultiplier();
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureCrafter.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        public void updateTile() {
            super.updateTile();
            this.updatePressure();
            this.dumpPressure();
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

