/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.production;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Eachable;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import omaloon.content.OlSounds;
import omaloon.world.blocks.production.PressureDrill;

public class HammerDrill
extends PressureDrill {
    public float shake = 0.3f;
    public float invertedTime = 200.0f;
    public Sound drillSound = OlSounds.hammer;
    public float drillSoundVolume = 0.2f;
    public float drillSoundPitchRand = 0.3f;
    public TextureRegion hammerRegion;

    public HammerDrill(String name) {
        super(name);
        this.hardnessDrillMultiplier = 0.0f;
        this.liquidBoostIntensity = 1.0f;
        this.ambientSound = Sounds.none;
    }

    public void load() {
        super.load();
        this.hammerRegion = Core.atlas.find(this.name + "-hammer");
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.rect((TextureRegion)this.hammerRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.hammerRegion};
    }

    public float getDrillTime(Item item) {
        return this.drillTime / this.drillMultipliers.get((Object)item, 1.0f);
    }

    public class HammerDrillBuild
    extends PressureDrill.PressureDrillBuild {
        public float smoothProgress;
        public float invertTime;

        public HammerDrillBuild() {
            super(HammerDrill.this);
            this.smoothProgress = 0.0f;
            this.invertTime = 0.0f;
        }

        public void draw() {
            Draw.rect((TextureRegion)HammerDrill.this.region, (float)this.x, (float)this.y);
            this.drawDefaultCracks();
            float fract = Mathf.clamp((float)this.smoothProgress, (float)0.25f, (float)0.3f);
            Draw.color((Color)Pal.shadow, (float)Pal.shadow.a);
            Draw.rect((TextureRegion)HammerDrill.this.hammerRegion, (float)(this.x - (fract - 0.25f) * 40.0f), (float)(this.y - (fract - 0.25f) * 40.0f), (float)((float)HammerDrill.this.hammerRegion.width * fract), (float)((float)HammerDrill.this.hammerRegion.width * fract));
            Draw.color();
            Draw.z((float)31.0f);
            Draw.rect((TextureRegion)HammerDrill.this.hammerRegion, (float)this.x, (float)this.y, (float)((float)HammerDrill.this.hammerRegion.width * fract), (float)((float)HammerDrill.this.hammerRegion.height * fract));
            if (this.dominantItem != null && HammerDrill.this.drawMineItem) {
                Draw.color((Color)this.dominantItem.color);
                Draw.rect((TextureRegion)HammerDrill.this.itemRegion, (float)this.x, (float)this.y, (float)((float)HammerDrill.this.itemRegion.width * fract), (float)((float)HammerDrill.this.itemRegion.height * fract));
                Draw.color();
            }
        }

        public boolean shouldConsume() {
            return this.items.total() <= HammerDrill.this.itemCapacity - this.dominantItems && this.enabled;
        }

        @Override
        public void updateTile() {
            this.updatePressure();
            this.dumpPressure();
            if (this.timer(HammerDrill.this.timerDump, 5.0f)) {
                this.dump(this.dominantItem != null && this.items.has(this.dominantItem) ? this.dominantItem : null);
            }
            if (this.dominantItem == null) {
                return;
            }
            if (this.invertTime > 0.0f) {
                this.invertTime -= this.delta() / HammerDrill.this.invertedTime;
            }
            this.timeDrilled += this.warmup * this.delta();
            float delay = HammerDrill.this.getDrillTime(this.dominantItem);
            this.smoothProgress = Mathf.lerpDelta((float)this.smoothProgress, (float)(this.progress / (HammerDrill.this.drillTime + 900.0f)), (float)0.1f);
            if (this.items.total() < HammerDrill.this.itemCapacity && this.dominantItems > 0 && this.efficiency > 0.0f) {
                float speed = Mathf.lerp((float)1.0f, (float)HammerDrill.this.liquidBoostIntensity, (float)this.optionalEfficiency) * this.efficiency;
                this.lastDrillSpeed = speed * (float)this.dominantItems * this.warmup / delay;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)speed, (float)HammerDrill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)HammerDrill.this.warmupSpeed);
                return;
            }
            if (this.dominantItems > 0 && this.progress >= delay && this.items.total() < HammerDrill.this.itemCapacity) {
                this.offload(this.dominantItem);
                this.consume();
                this.invertTime = 1.0f;
                this.progress %= delay;
                if (this.wasVisible) {
                    Effect.shake((float)HammerDrill.this.shake, (float)HammerDrill.this.shake, (Position)this);
                    HammerDrill.this.drillSound.at(this.x, this.y, 1.0f + Mathf.range((float)HammerDrill.this.drillSoundPitchRand), HammerDrill.this.drillSoundVolume);
                    HammerDrill.this.drillEffect.at(this.x + Mathf.range((float)HammerDrill.this.drillEffectRnd), this.y + Mathf.range((float)HammerDrill.this.drillEffectRnd), this.dominantItem.color);
                }
            }
        }
    }
}

