/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.power;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.Renderer;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerNode;

public class ImpulseNode
extends PowerNode {
    public int effectTimer;
    public float effectTime;

    public ImpulseNode(String name) {
        super(name);
        this.effectTimer = this.timers++;
        this.effectTime = 20.0f;
    }

    public class ImpulseNodeBuild
    extends PowerNode.PowerNodeBuild {
        public ImpulseNodeBuild() {
            super((PowerNode)ImpulseNode.this);
        }

        public void draw() {
            Draw.rect((TextureRegion)ImpulseNode.this.region, (float)this.x, (float)this.y, (float)this.drawrot());
            if (Mathf.zero((float)Renderer.laserOpacity) || this.isPayload()) {
                return;
            }
            Draw.z((float)70.0f);
            ImpulseNode.this.setupColor(this.power.graph.getSatisfaction());
            for (int i = 0; i < this.power.links.size; ++i) {
                Building link = Vars.world.build(this.power.links.get(i));
                if (!ImpulseNode.this.linkValid((Building)this, link) || link.block instanceof PowerNode && link.id >= this.id) continue;
                Draw.alpha((float)(Renderer.laserOpacity / 2.0f));
                ImpulseNode.this.drawLaser(this.x, this.y, link.x, link.y, ImpulseNode.this.size, link.block.size);
                if (!this.timer.get(ImpulseNode.this.effectTimer, ImpulseNode.this.effectTime) || !(this.power.graph.getSatisfaction() > 0.0f)) continue;
                for (int l = 0; l < this.power.links.size; ++l) {
                    Building other;
                    Tile otherTile = Vars.world.tile(this.power.links.get(l));
                    if (otherTile == null || (other = otherTile.build) == null) continue;
                    float angle1 = Angles.angle((float)this.x, (float)this.y, (float)other.x, (float)other.y);
                    float vx = Mathf.cosDeg((float)angle1);
                    float vy = Mathf.sinDeg((float)angle1);
                    float len1 = (float)(ImpulseNode.this.size * 8) / 2.0f - 1.5f;
                    float len2 = (float)(other.block.size * 8) / 2.0f - 1.5f;
                    this.lightning(this.x + vx * len1, this.y + vy * len1, other.x - vx * len2, other.y - vy * len2, 2, Mathf.random((float)-8.0f, (float)8.0f), ImpulseNode.this.laserColor2.cpy().lerp(ImpulseNode.this.laserColor1, this.power.graph.getSatisfaction()).a(Renderer.laserOpacity), Fx.lightning.layer(70.0f));
                }
            }
            Draw.reset();
        }

        public void lightning(float x1, float y1, float x2, float y2, int iterations, float rndScale, Color c, Effect e) {
            int i;
            boolean swap;
            Seq lines = new Seq();
            boolean bl = swap = Math.abs(y1 - y2) < Math.abs(x1 - x2);
            if (swap) {
                lines.add((Object)new Vec2(y1, x1));
                lines.add((Object)new Vec2(y2, x2));
            } else {
                lines.add((Object)new Vec2(x1, y1));
                lines.add((Object)new Vec2(x2, y2));
            }
            for (i = 0; i < iterations; ++i) {
                for (int j = 0; j < lines.size - 1; j += 2) {
                    Vec2 v1 = (Vec2)lines.get(j);
                    Vec2 v2 = (Vec2)lines.get(j + 1);
                    Vec2 v = new Vec2((v1.x + v2.x) / 2.0f, (v1.y + v2.y) / 2.0f);
                    float ang = (v2.angle(v1) + 90.0f) * ((float)Math.PI / 180);
                    float sin = Mathf.sin((float)ang);
                    float cos = Mathf.cos((float)ang);
                    float rnd = Mathf.random((float)rndScale);
                    v.x += rnd * sin;
                    v.y += rnd * cos;
                    lines.insert(j + 1, (Object)v);
                }
            }
            if (swap) {
                for (i = 0; i < lines.size; ++i) {
                    Vec2 v = (Vec2)lines.get(i);
                    float px = v.x;
                    v.x = v.y;
                    v.y = px;
                }
            }
            e.at(x1, y1, 0.0f, c, (Object)lines);
        }
    }
}

