/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.liquid;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.blocks.sandbox.LiquidVoid;
import omaloon.content.OlFx;
import omaloon.content.OlSounds;
import omaloon.utils.OlUtils;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidValve
extends LiquidBlock {
    public PressureConfig pressureConfig = new PressureConfig();
    public TextureRegion[] tiles;
    public TextureRegion[][] liquidRegions;
    public TextureRegion valveRegion;
    public TextureRegion topRegion;
    public Sound jamSound = OlSounds.jam;
    public Effect pumpingEffect = OlFx.pumpBack;
    public Effect jamEffect = Fx.explosion;
    public float pumpingEffectInterval = 15.0f;
    public float pressureLoss = 0.05f;
    public float openMin = -15.0f;
    public float jamPoint = -20.0f;
    public float liquidPadding = 3.0f;

    public PressureLiquidValve(String name) {
        super(name);
        this.rotate = true;
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Object tiling = new Object(){
            int tiling = 0;
        };
        Point2 front = new Point2(1, 0).rotate(plan.rotation).add(plan.x, plan.y);
        Point2 back = new Point2(-1, 0).rotate(plan.rotation).add(plan.x, plan.y);
        boolean inverted = plan.rotation == 1 || plan.rotation == 2;
        list.each(arg_0 -> PressureLiquidValve.lambda$drawPlanRegion$0(front, tiling, inverted, back, arg_0));
        Draw.rect((TextureRegion)this.bottomRegion, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        Draw.rect((TextureRegion)this.tiles[tiling.tiling], (float)plan.drawx(), (float)plan.drawy(), (float)((float)(plan.rotation + 1) * 90.0f % 180.0f - 90.0f));
        Draw.rect((TextureRegion)this.valveRegion, (float)plan.drawx(), (float)plan.drawy(), (float)((float)(plan.rotation + 1) * 90.0f % 180.0f - 90.0f));
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region};
    }

    public void load() {
        super.load();
        this.tiles = OlUtils.split(this.name + "-tiles", 32, 0);
        this.valveRegion = Core.atlas.find(this.name + "-valve");
        this.topRegion = Core.atlas.find(this.name + "-top");
        if (!this.bottomRegion.found()) {
            this.bottomRegion = Core.atlas.find("omaloon-liquid-bottom");
        }
        this.liquidRegions = new TextureRegion[2][50];
        if (Vars.renderer != null) {
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int fluid = 0; fluid < 2; ++fluid) {
                for (int frame = 0; frame < 50; ++frame) {
                    TextureRegion base = frames[fluid][frame];
                    TextureRegion result = new TextureRegion();
                    result.set(base);
                    result.setHeight((float)result.height - this.liquidPadding);
                    result.setWidth((float)result.width - this.liquidPadding);
                    result.setX((float)result.getX() + this.liquidPadding);
                    result.setY((float)result.getY() + this.liquidPadding);
                    this.liquidRegions[fluid][frame] = result;
                }
            }
        }
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
        this.stats.add(OlStats.pressureFlow, (float)Mathf.round((float)(this.pressureLoss * 60.0f), (int)2), OlStats.pressureSecond);
    }

    private static /* synthetic */ void lambda$drawPlanRegion$0(Point2 front, 1 tiling, boolean inverted, Point2 back, BuildPlan next) {
        if (new Point2(next.x, next.y).equals((Object)front) && next.block.outputsLiquid) {
            tiling.tiling = tiling.tiling | (inverted ? 2 : 1);
        }
        if (new Point2(next.x, next.y).equals((Object)back) && next.block.outputsLiquid) {
            tiling.tiling = tiling.tiling | (inverted ? 1 : 2);
        }
    }

    public class PressureLiquidValveBuild
    extends LiquidBlock.LiquidBuild
    implements HasPressure {
        PressureModule pressure;
        public float draining;
        public float effectInterval;
        public int tiling;
        public boolean jammed;

        public PressureLiquidValveBuild() {
            super((LiquidBlock)PressureLiquidValve.this);
            this.pressure = new PressureModule();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return PressureLiquidValve.this.hasLiquids;
        }

        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return super.canDumpLiquid(to, liquid) || to instanceof LiquidVoid.LiquidVoidBuild;
        }

        @Override
        public boolean connects(HasPressure to) {
            return HasPressure.super.connects(to) && to instanceof PressureLiquidValveBuild ? !(this.front() != to && this.back() != to || to.front() != this && to.back() != this) : this.front() == to || this.back() == to;
        }

        public void draw() {
            float rot = PressureLiquidValve.this.rotate ? (90.0f + this.rotdeg()) % 180.0f - 90.0f : 0.0f;
            Draw.rect((TextureRegion)PressureLiquidValve.this.bottomRegion, (float)this.x, (float)this.y, (float)this.rotation);
            if (this.liquids().currentAmount() > 0.01f) {
                int frame = this.liquids.current().getAnimationFrame();
                int gas = this.liquids.current().gas ? 1 : 0;
                float xscl = Draw.xscl;
                float yscl = Draw.yscl;
                Draw.scl((float)1.0f, (float)1.0f);
                Drawf.liquid((TextureRegion)PressureLiquidValve.this.liquidRegions[gas][frame], (float)this.x, (float)this.y, (float)(this.liquids.currentAmount() / PressureLiquidValve.this.liquidCapacity), (Color)this.liquids.current().color.write(Tmp.c1).a(1.0f));
                Draw.scl((float)xscl, (float)yscl);
            }
            Draw.rect((TextureRegion)PressureLiquidValve.this.tiles[this.tiling], (float)this.x, (float)this.y, (float)rot);
            Draw.rect((TextureRegion)PressureLiquidValve.this.topRegion, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)PressureLiquidValve.this.valveRegion, (float)this.x, (float)this.y, (float)(this.draining * (float)(this.rotation % 2 == 0 ? -90 : 90) + rot));
        }

        public void onProximityUpdate() {
            HasPressure back;
            HasPressure front;
            super.onProximityUpdate();
            this.tiling = 0;
            boolean inverted = this.rotation == 1 || this.rotation == 2;
            Building building = this.front();
            if (building instanceof HasPressure && this.connected(front = (HasPressure)building)) {
                this.tiling |= inverted ? 2 : 1;
            }
            if ((building = this.back()) instanceof HasPressure && this.connected(back = (HasPressure)building)) {
                this.tiling |= inverted ? 1 : 2;
            }
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidValve.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
            this.jammed = read.bool();
            this.draining = read.f();
        }

        @Override
        public void updatePressure() {
            HasPressure.super.updatePressure();
            if (this.getPressure() >= PressureLiquidValve.this.jamPoint) {
                this.jammed = false;
            }
            if (this.jammed) {
                return;
            }
            if (this.getPressure() <= PressureLiquidValve.this.openMin) {
                this.effectInterval += this.delta();
                this.handlePressure(PressureLiquidValve.this.pressureLoss * Time.delta);
                this.draining = Mathf.approachDelta((float)this.draining, (float)1.0f, (float)0.014f);
                if (this.effectInterval > PressureLiquidValve.this.pumpingEffectInterval) {
                    this.effectInterval = 0.0f;
                    PressureLiquidValve.this.pumpingEffect.at(this.x, this.y, -this.draining * (float)(this.rotation % 2 == 0 ? 90 : -90) - (PressureLiquidValve.this.rotate ? (90.0f - this.rotdeg()) % 180.0f - 90.0f : 0.0f), (Object)this.liquids.current());
                    PressureLiquidValve.this.pumpingEffect.at(this.x, this.y, this.draining * (float)(this.rotation % 2 == 0 ? -90 : 90) + (PressureLiquidValve.this.rotate ? (90.0f + this.rotdeg()) % 180.0f - 90.0f : 0.0f), (Object)this.liquids.current());
                }
            } else {
                this.draining = Mathf.approachDelta((float)this.draining, (float)0.0f, (float)0.014f);
            }
            if (this.getPressure() < PressureLiquidValve.this.jamPoint) {
                this.jammed = true;
                this.draining = 0.0f;
                PressureLiquidValve.this.jamEffect.at(this.x, this.y, this.draining * (float)(this.rotation % 2 == 0 ? -90 : 90) + (PressureLiquidValve.this.rotate ? (90.0f + this.rotdeg()) % 180.0f - 90.0f : 0.0f), (Object)PressureLiquidValve.this.valveRegion);
                PressureLiquidValve.this.jamSound.at(this.x, this.y);
            }
        }

        public void updateTile() {
            this.updatePressure();
            this.nextBuilds(true).each(b -> this.moveLiquidPressure((HasPressure)b, this.liquids.current()));
            this.dumpPressure();
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
            write.bool(this.jammed);
            write.f(this.draining);
        }
    }
}

