/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.entities.Puddles;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Tile;
import mindustry.world.blocks.liquid.LiquidBlock;
import omaloon.content.OlFx;
import omaloon.utils.OlUtils;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidPump
extends LiquidBlock {
    public PressureConfig pressureConfig = new PressureConfig();
    public float pressureTransfer = 0.1f;
    public float pressureDifference = 10.0f;
    public Effect pumpEffectForward = OlFx.pumpFront;
    public Effect pumpEffectBackward = OlFx.pumpBack;
    public float pumpEffectInterval = 15.0f;
    public float liquidPadding = 3.0f;
    public TextureRegion[][] liquidRegions;
    public TextureRegion[] tiles;
    public TextureRegion arrowRegion;

    public PressureLiquidPump(String name) {
        super(name);
        this.rotate = true;
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Object tiling = new Object(){
            int tiling = 0;
        };
        Point2 front = new Point2(1, 0).rotate(plan.rotation).add(plan.x, plan.y);
        Point2 back = new Point2(-1, 0).rotate(plan.rotation).add(plan.x, plan.y);
        boolean inverted = plan.rotation == 1 || plan.rotation == 2;
        list.each(arg_0 -> PressureLiquidPump.lambda$drawPlanRegion$0(front, tiling, inverted, back, arg_0));
        Draw.rect((TextureRegion)this.bottomRegion, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        if (tiling.tiling != 0) {
            Draw.rect((TextureRegion)this.arrowRegion, (float)plan.drawx(), (float)plan.drawy(), (float)((float)plan.rotation * 90.0f));
        }
        Draw.rect((TextureRegion)this.tiles[tiling.tiling], (float)plan.drawx(), (float)plan.drawy(), (float)((float)(plan.rotation + 1) * 90.0f % 180.0f - 90.0f));
        if (tiling.tiling == 0) {
            Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)((float)plan.rotation * 90.0f));
        }
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    public void load() {
        super.load();
        this.tiles = OlUtils.split(this.name + "-tiles", 32, 0);
        this.arrowRegion = Core.atlas.find(this.name + "-arrow");
        if (!this.bottomRegion.found()) {
            this.bottomRegion = Core.atlas.find("omaloon-liquid-bottom");
        }
        this.liquidRegions = new TextureRegion[2][50];
        if (Vars.renderer != null) {
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int fluid = 0; fluid < 2; ++fluid) {
                for (int frame = 0; frame < 50; ++frame) {
                    TextureRegion base = frames[fluid][frame];
                    TextureRegion result = new TextureRegion();
                    result.set(base);
                    result.setHeight((float)result.height - this.liquidPadding);
                    result.setWidth((float)result.width - this.liquidPadding);
                    result.setX((float)result.getX() + this.liquidPadding);
                    result.setY((float)result.getY() + this.liquidPadding);
                    this.liquidRegions[fluid][frame] = result;
                }
            }
        }
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
        this.stats.add(OlStats.pressureFlow, (float)Mathf.round((float)(this.pressureTransfer * 60.0f), (int)2), OlStats.pressureSecond);
    }

    private static /* synthetic */ void lambda$drawPlanRegion$0(Point2 front, 1 tiling, boolean inverted, Point2 back, BuildPlan next) {
        if (!(next.block instanceof PressureLiquidPump)) {
            if (new Point2(next.x, next.y).equals((Object)front) && next.block.outputsLiquid) {
                tiling.tiling = tiling.tiling | (inverted ? 2 : 1);
            }
            if (new Point2(next.x, next.y).equals((Object)back) && next.block.outputsLiquid) {
                tiling.tiling = tiling.tiling | (inverted ? 1 : 2);
            }
        }
    }

    public class PressureLiquidPumpBuild
    extends LiquidBlock.LiquidBuild
    implements HasPressure {
        PressureModule pressure;
        public int tiling;
        public float effectInterval;

        public PressureLiquidPumpBuild() {
            super((LiquidBlock)PressureLiquidPump.this);
            this.pressure = new PressureModule();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return false;
        }

        @Override
        public boolean acceptsPressure(HasPressure from, float pressure) {
            return false;
        }

        @Override
        public boolean connects(HasPressure to) {
            return HasPressure.super.connects(to) && !(to instanceof PressureLiquidPumpBuild) && (this.front() == to || this.back() == to);
        }

        public void draw() {
            float rot;
            float f = rot = PressureLiquidPump.this.rotate ? (90.0f + this.rotdeg()) % 180.0f - 90.0f : 0.0f;
            if (this.tiling != 0) {
                Draw.rect((TextureRegion)PressureLiquidPump.this.bottomRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
                if (this.liquids().currentAmount() > 0.01f) {
                    HasPressure b;
                    HasPressure b2;
                    Building building = this.front();
                    HasPressure front = building instanceof HasPressure && this.connected(b2 = (HasPressure)building) ? b2 : null;
                    Building building2 = this.back();
                    HasPressure back = building2 instanceof HasPressure && this.connected(b = (HasPressure)building2) ? b : null;
                    float alpha = (front == null ? 0.0f : front.liquids().currentAmount() / front.block().liquidCapacity) + (back == null ? 0.0f : back.liquids().currentAmount() / back.block().liquidCapacity);
                    alpha /= (front == null ? 0.0f : 1.0f) + (back == null ? 0.0f : 1.0f);
                    int frame = this.liquids.current().getAnimationFrame();
                    int gas = this.liquids.current().gas ? 1 : 0;
                    float xscl = Draw.xscl;
                    float yscl = Draw.yscl;
                    Draw.scl((float)1.0f, (float)1.0f);
                    Drawf.liquid((TextureRegion)PressureLiquidPump.this.liquidRegions[gas][frame], (float)this.x, (float)this.y, (float)alpha, (Color)(front == null ? (back == null ? Liquids.water.color : back.liquids().current().color) : front.liquids().current().color));
                    Draw.scl((float)xscl, (float)yscl);
                }
                Draw.rect((TextureRegion)PressureLiquidPump.this.arrowRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
            Draw.rect((TextureRegion)PressureLiquidPump.this.tiles[this.tiling], (float)this.x, (float)this.y, (float)rot);
            if (this.tiling == 0) {
                Draw.rect((TextureRegion)PressureLiquidPump.this.topRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
        }

        @Override
        public Seq<HasPressure> nextBuilds(boolean flow) {
            return Seq.with((Object[])new HasPressure[0]);
        }

        public void onProximityUpdate() {
            HasPressure back;
            HasPressure front;
            super.onProximityUpdate();
            this.tiling = 0;
            boolean inverted = this.rotation == 1 || this.rotation == 2;
            Building building = this.front();
            if (building instanceof HasPressure && this.connected(front = (HasPressure)building)) {
                this.tiling |= inverted ? 2 : 1;
            }
            if ((building = this.back()) instanceof HasPressure && this.connected(back = (HasPressure)building)) {
                this.tiling |= inverted ? 1 : 2;
            }
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidPump.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        public void updateTile() {
            super.updateTile();
            if (this.efficiency > 0.0f) {
                float difference;
                HasPressure b;
                HasPressure b2;
                Building building = this.front();
                HasPressure front = building instanceof HasPressure && this.connected(b2 = (HasPressure)building) ? b2 : null;
                Building building2 = this.back();
                HasPressure back = building2 instanceof HasPressure && this.connected(b = (HasPressure)building2) ? b : null;
                boolean pumped = false;
                float solid = 1.0f;
                if (front == null && this.front() != null || back == null && this.back() != null) {
                    solid += 1.0f;
                }
                if ((difference = (front == null ? 0.0f : front.getPressure()) - (back == null ? 0.0f : back.getPressure())) < PressureLiquidPump.this.pressureDifference / solid) {
                    if (front != null) {
                        front.handlePressure(PressureLiquidPump.this.pressureTransfer * this.edelta());
                    }
                    if (back != null) {
                        back.removePressure(PressureLiquidPump.this.pressureTransfer * this.edelta());
                    }
                    pumped = true;
                } else if (back != null && front == null && this.front() == null) {
                    back.removePressure(PressureLiquidPump.this.pressureTransfer * this.edelta());
                    pumped = true;
                }
                if (pumped) {
                    this.effectInterval += this.delta();
                }
                if (this.effectInterval > PressureLiquidPump.this.pumpEffectInterval) {
                    if (this.front() == null) {
                        PressureLiquidPump.this.pumpEffectForward.at(this.x, this.y, this.rotdeg());
                    }
                    if (this.back() == null) {
                        PressureLiquidPump.this.pumpEffectBackward.at(this.x, this.y, this.rotdeg() + 180.0f);
                    }
                    this.effectInterval = 0.0f;
                }
                if (back != null) {
                    if (front != null) {
                        back.moveLiquidPressure(front, back.liquids().current());
                    } else if (this.front() == null) {
                        float leakAmount = back.liquids().get(back.liquids().current()) / 1.5f;
                        Puddles.deposit((Tile)this.tile.nearby(this.rotation), (Tile)this.tile, (Liquid)back.liquids().current(), (float)leakAmount, (boolean)true, (boolean)true);
                        back.liquids().remove(back.liquids().current(), leakAmount);
                    }
                }
            }
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

