/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.liquid;

import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.blocks.liquid.LiquidJunction;
import omaloon.world.blocks.liquid.PressureLiquidPump;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidJunction
extends LiquidJunction {
    public PressureConfig pressureConfig = new PressureConfig();

    public PressureLiquidJunction(String name) {
        super(name);
    }

    public class PressureLiquidJunctionBuild
    extends LiquidJunction.LiquidJunctionBuild
    implements HasPressure {
        PressureModule pressure;

        public PressureLiquidJunctionBuild() {
            super((LiquidJunction)PressureLiquidJunction.this);
            this.pressure = new PressureModule();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return false;
        }

        @Override
        public boolean acceptsPressure(HasPressure from, float pressure) {
            return false;
        }

        @Override
        public boolean connects(HasPressure to) {
            return HasPressure.super.connects(to) && !(to instanceof PressureLiquidPump);
        }

        @Override
        public HasPressure getPressureDestination(HasPressure source, float pressure) {
            HasPressure next;
            if (!this.enabled) {
                return this;
            }
            int dir = (source.relativeTo(this.tile.x, this.tile.y) + 4) % 4;
            HasPressure hasPressure = next = this.nearby(dir) instanceof HasPressure ? (HasPressure)this.nearby(dir) : null;
            if (next == null || !next.acceptsPressure(source, pressure) && !(next.block() instanceof PressureLiquidJunction)) {
                return this;
            }
            return next.getPressureDestination(this, pressure);
        }

        @Override
        public Seq<HasPressure> nextBuilds(boolean flow) {
            return Seq.with((Object[])new HasPressure[0]);
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidJunction.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

