/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.liquid;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.input.Placement;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.sandbox.LiquidVoid;
import omaloon.content.blocks.OlDistributionBlocks;
import omaloon.utils.OlUtils;
import omaloon.world.blocks.liquid.PressureLiquidJunction;
import omaloon.world.blocks.liquid.PressureLiquidPump;
import omaloon.world.blocks.liquid.PressureLiquidValve;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidConduit
extends LiquidRouter {
    public PressureConfig pressureConfig = new PressureConfig();
    public TextureRegion[] topRegions;
    public TextureRegion[][] liquidRegions;
    public float liquidPadding = 3.0f;
    @Nullable
    public Block junctionReplacement;
    @Nullable
    public Block bridgeReplacement;

    public PressureLiquidConduit(String name) {
        super(name);
        this.rotate = true;
    }

    public void init() {
        super.init();
        if (this.junctionReplacement == null) {
            this.junctionReplacement = OlDistributionBlocks.liquidJunction;
        }
        if (this.bridgeReplacement == null || !(this.bridgeReplacement instanceof ItemBridge)) {
            this.bridgeReplacement = OlDistributionBlocks.liquidBridge;
        }
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int tiling = 0;
        BuildPlan[] proximity = new BuildPlan[4];
        list.each(next -> {
            for (int i = 0; i < 4; ++i) {
                Point2 side = new Point2(plan.x, plan.y).add(Geometry.d4[i]);
                if (!new Point2(next.x, next.y).equals((Object)side) || !(next.block instanceof PressureLiquidConduit || next.block instanceof PressureLiquidPump || next.block instanceof PressureLiquidValve ? plan.rotation % 2 == i % 2 || next.rotation % 2 == i % 2 : next.block.outputsLiquid)) continue;
                proximity[i] = next;
                break;
            }
        });
        for (int i = 0; i < 4; ++i) {
            if (proximity[i] == null) continue;
            tiling |= 1 << i;
        }
        Draw.rect((TextureRegion)this.bottomRegion, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        if (tiling == 0) {
            Draw.rect((TextureRegion)this.topRegions[tiling], (float)plan.drawx(), (float)plan.drawy(), (float)((float)(plan.rotation + 1) * 90.0f % 180.0f - 90.0f));
        } else {
            Draw.rect((TextureRegion)this.topRegions[tiling], (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        }
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public void load() {
        super.load();
        this.topRegions = OlUtils.split(this.name + "-tiles", 32, 0);
        if (!this.bottomRegion.found()) {
            this.bottomRegion = Core.atlas.find("omaloon-liquid-bottom");
        }
        this.liquidRegions = new TextureRegion[2][50];
        if (Vars.renderer != null) {
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int fluid = 0; fluid < 2; ++fluid) {
                for (int frame = 0; frame < 50; ++frame) {
                    TextureRegion base = frames[fluid][frame];
                    TextureRegion result = new TextureRegion();
                    result.set(base);
                    result.setHeight((float)result.height - this.liquidPadding);
                    result.setWidth((float)result.width - this.liquidPadding);
                    result.setX((float)result.getX() + this.liquidPadding);
                    result.setY((float)result.getY() + this.liquidPadding);
                    this.liquidRegions[fluid][frame] = result;
                }
            }
        }
    }

    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        if (this.junctionReplacement == null) {
            return this;
        }
        Boolf cont = p -> plans.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof PressureLiquidConduit || req.block instanceof PressureLiquidJunction));
        return cont.get((Object)Geometry.d4((int)req.rotation)) && cont.get((Object)Geometry.d4((int)(req.rotation - 2))) && req.tile() != null && req.tile().block() instanceof PressureLiquidConduit && Mathf.mod((int)(req.build().rotation - req.rotation), (int)2) == 1 ? this.junctionReplacement : this;
    }

    public void handlePlacementLine(Seq<BuildPlan> plans) {
        if (this.bridgeReplacement == null) {
            return;
        }
        Placement.calculateBridges(plans, (ItemBridge)((ItemBridge)this.bridgeReplacement));
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
    }

    public class PressureLiquidConduitBuild
    extends LiquidRouter.LiquidRouterBuild
    implements HasPressure {
        public int tiling;
        PressureModule pressure;

        public PressureLiquidConduitBuild() {
            super((LiquidRouter)PressureLiquidConduit.this);
            this.tiling = 0;
            this.pressure = new PressureModule();
        }

        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return super.canDumpLiquid(to, liquid) || to instanceof LiquidVoid.LiquidVoidBuild;
        }

        @Override
        public boolean connects(HasPressure to) {
            return to instanceof PressureLiquidConduitBuild || to instanceof PressureLiquidValve.PressureLiquidValveBuild ? this.front() == to || this.back() == to || to.front() == this || to.back() == this : to != null && HasPressure.super.connects(to);
        }

        public void draw() {
            Draw.rect((TextureRegion)PressureLiquidConduit.this.bottomRegion, (float)this.x, (float)this.y);
            if (this.liquids().currentAmount() > 0.01f) {
                int frame = this.liquids.current().getAnimationFrame();
                int gas = this.liquids.current().gas ? 1 : 0;
                float xscl = Draw.xscl;
                float yscl = Draw.yscl;
                Draw.scl((float)1.0f, (float)1.0f);
                Drawf.liquid((TextureRegion)PressureLiquidConduit.this.liquidRegions[gas][frame], (float)this.x, (float)this.y, (float)(this.liquids.currentAmount() / PressureLiquidConduit.this.liquidCapacity), (Color)this.liquids.current().color.write(Tmp.c1).a(1.0f));
                Draw.scl((float)xscl, (float)yscl);
            }
            Draw.rect((TextureRegion)PressureLiquidConduit.this.topRegions[this.tiling], (float)this.x, (float)this.y, (float)(this.tiling != 0 ? 0.0f : (this.rotdeg() + 90.0f) % 180.0f - 90.0f));
        }

        public float moveLiquid(Building next, Liquid liquid) {
            if (next instanceof HasPressure) {
                HasPressure p = (HasPressure)next;
                return this.moveLiquidPressure(p, liquid);
            }
            return 0.0f;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.tiling = 0;
            for (int i = 0; i < 4; ++i) {
                HasPressure build;
                HasPressure hasPressure = build = this.nearby(i) instanceof HasPressure ? (HasPressure)this.nearby(i) : null;
                if (build == null || !this.connected(build)) continue;
                this.tiling |= 1 << i;
            }
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidConduit.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        public void updateTile() {
            this.updatePressure();
            this.nextBuilds(true).each(b -> this.moveLiquidPressure((HasPressure)b, this.liquids.current()));
            this.dumpPressure();
        }

        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }
    }
}

