/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.blocks.sandbox.LiquidVoid;
import mindustry.world.meta.BlockGroup;
import omaloon.world.blocks.distribution.TubeItemBridge;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureLiquidBridge
extends TubeItemBridge {
    public PressureConfig pressureConfig = new PressureConfig();
    public float liquidPadding = 1.0f;
    public TextureRegion bottomRegion;
    public TextureRegion endRegion1;
    public TextureRegion endBottomRegion;
    public TextureRegion endLiquidRegion;
    public TextureRegion bridgeBottomRegion;
    public TextureRegion bridgeLiquidRegion;

    public PressureLiquidBridge(String name) {
        super(name);
        this.hasLiquids = true;
        this.hasItems = false;
        this.outputsLiquid = true;
        this.canOverdrive = false;
        this.group = BlockGroup.liquids;
    }

    @Override
    public void drawBridge(BuildPlan req, float ox, float oy, float flip) {
        this.drawBridge(this.bridgeBottomRegion, this.endBottomRegion, new Vec2(req.drawx(), req.drawy()), new Vec2(ox, oy));
        this.drawBridge(new Vec2(req.drawx(), req.drawy()), new Vec2(ox, oy));
    }

    public void drawBridge(Vec2 pos1, Vec2 pos2) {
        boolean reverse;
        boolean line = pos1.x == pos2.x || pos1.y == pos2.y;
        int segments = this.length(pos1.x, pos1.y, pos2.x, pos2.y) + 1;
        float sl = 0.0f;
        if (!line) {
            sl = Mathf.dst((float)pos1.x, (float)pos1.y, (float)pos2.x, (float)pos2.y) / (float)segments;
        }
        float sa = pos1.angleTo((Position)pos2);
        float oa = pos2.angleTo((Position)pos1);
        if (line) {
            Vec2 b;
            Vec2 a;
            if (pos1.y == pos2.y) {
                a = pos1.x < pos2.x ? pos2 : pos1;
                b = pos1.x < pos2.x ? pos1 : pos2;
                segments = (int)(a.getX() / 8.0f - b.getX() / 8.0f);
            }
            if (pos1.x == pos2.x) {
                a = pos1.y < pos2.y ? pos2 : pos1;
                b = pos1.y < pos2.y ? pos1 : pos2;
                segments = (int)(a.getY() / 8.0f - b.getY() / 8.0f);
            }
        }
        boolean bl = reverse = pos1.x > pos2.x;
        if (line) {
            reverse |= pos1.y < pos2.y;
        }
        float r = sa + (float)(reverse ? 180 : 0);
        TextureRegion end = reverse ? this.endRegion1 : this.endRegion;
        TextureRegion str = reverse ? this.endRegion : this.endRegion1;
        Draw.rect((TextureRegion)end, (float)pos1.x, (float)pos1.y, (float)sa);
        Draw.rect((TextureRegion)str, (float)pos2.x, (float)pos2.y, (float)oa);
        for (int i = 1; i < segments; ++i) {
            float s_x = Mathf.lerp((float)pos1.x, (float)pos2.x, (float)((float)i / (float)segments));
            float s_y = Mathf.lerp((float)pos1.y, (float)pos2.y, (float)((float)i / (float)segments));
            if (line) {
                Draw.rect((TextureRegion)this.bridgeRegion, (float)s_x, (float)s_y, (float)r);
                continue;
            }
            Draw.rect((TextureRegion)this.bridgeRegion, (float)s_x, (float)s_y, (float)sl, (float)((float)this.bridgeRegion.height * Draw.scl * Draw.xscl), (float)r);
        }
    }

    public int length(float x1, float y1, float x2, float y2) {
        return (int)(Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2) / 8.0f);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.bottomRegion, (float)plan.drawx(), (float)plan.drawy());
        super.drawPlanRegion(plan, list);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-icon")};
    }

    public void load() {
        super.load();
        this.bottomRegion = Core.atlas.find("omaloon-liquid-bottom");
        this.endRegion1 = Core.atlas.find(this.name + "-end1");
        this.endBottomRegion = Core.atlas.find(this.name + "-end-bottom");
        this.endLiquidRegion = Core.atlas.find(this.name + "-end-liquid");
        this.bridgeBottomRegion = Core.atlas.find(this.name + "-bridge-bottom");
        this.bridgeLiquidRegion = Core.atlas.find(this.name + "-bridge-liquid");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this.stats);
    }

    public class PressureLiquidBridgeBuild
    extends TubeItemBridge.TubeItemBridgeBuild
    implements HasPressure {
        PressureModule pressure = new PressureModule();

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return source.block.hasLiquids;
        }

        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return super.canDumpLiquid(to, liquid) || to instanceof LiquidVoid.LiquidVoidBuild;
        }

        @Override
        public void draw() {
            Draw.rect((TextureRegion)PressureLiquidBridge.this.bottomRegion, (float)this.x, (float)this.y);
            if (this.liquids.currentAmount() > 0.001f) {
                LiquidBlock.drawTiledFrames((int)PressureLiquidBridge.this.size, (float)this.x, (float)this.y, (float)PressureLiquidBridge.this.liquidPadding, (Liquid)this.liquids.current(), (float)(this.liquids.currentAmount() / PressureLiquidBridge.this.liquidCapacity));
            }
            this.drawBase();
            Draw.z((float)70.0f);
            Tile other = Vars.world.tile(this.link);
            Building build = Vars.world.build(this.link);
            if (build == this) {
                build = null;
            }
            if (build != null) {
                other = build.tile;
            }
            if (!PressureLiquidBridge.this.linkValid(this.tile, other) || build == null || Mathf.zero((float)Renderer.bridgeOpacity)) {
                return;
            }
            Vec2 pos1 = new Vec2(this.x, this.y);
            Vec2 pos2 = new Vec2(other.drawx(), other.drawy());
            if (PressureLiquidBridge.this.pulse) {
                Draw.color((Color)Color.white, (Color)Color.black, (float)Mathf.absin((float)Time.time, (float)6.0f, (float)0.07f));
            }
            Draw.alpha((float)Renderer.bridgeOpacity);
            PressureLiquidBridge.this.drawBridge(PressureLiquidBridge.this.bridgeBottomRegion, PressureLiquidBridge.this.endBottomRegion, pos1, pos2);
            Draw.color((Color)this.liquids.current().color, (float)(this.liquids.currentAmount() / PressureLiquidBridge.this.liquidCapacity * this.liquids.current().color.a * Renderer.bridgeOpacity));
            PressureLiquidBridge.this.drawBridge(PressureLiquidBridge.this.bridgeLiquidRegion, PressureLiquidBridge.this.endLiquidRegion, pos1, pos2);
            Draw.color();
            Draw.alpha((float)Renderer.bridgeOpacity);
            PressureLiquidBridge.this.drawBridge(pos1, pos2);
            Draw.reset();
        }

        @Override
        public Seq<HasPressure> nextBuilds(boolean flow) {
            Seq<HasPressure> o = HasPressure.super.nextBuilds(flow);
            Building building = Vars.world.build(this.link);
            if (building instanceof PressureLiquidBridgeBuild) {
                PressureLiquidBridgeBuild b = (PressureLiquidBridgeBuild)building;
                o.add((Object)b);
            }
            for (int pos : this.incoming.items) {
                Building building2 = Vars.world.build(pos);
                if (!(building2 instanceof PressureLiquidBridgeBuild)) continue;
                PressureLiquidBridgeBuild b = (PressureLiquidBridgeBuild)building2;
                o.add((Object)b);
            }
            return o;
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureLiquidBridge.this.pressureConfig;
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.pressure.read(read);
        }

        @Override
        public void updateTile() {
            this.incoming.size = Math.min(this.incoming.size, PressureLiquidBridge.this.maxConnections - (this.link == -1 ? (byte)0 : 1));
            this.incoming.shrink();
            this.checkIncoming();
            this.nextBuilds(true).each(b -> this.moveLiquidPressure((HasPressure)b, this.liquids.current()));
            this.updatePressure();
            this.dumpPressure();
            Tile other = Vars.world.tile(this.link);
            if (PressureLiquidBridge.this.linkValid(this.tile, other)) {
                if (other.build instanceof TubeItemBridge.TubeItemBridgeBuild && PressureLiquidBridge.this.cast(other.build).acceptIncoming(this.tile.pos())) {
                    this.configureAny(-1);
                    return;
                }
                IntSeq inc = ((ItemBridge.ItemBridgeBuild)other.build).incoming;
                int pos = this.tile.pos();
                if (!inc.contains(pos)) {
                    inc.add(pos);
                }
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.efficiency(), (float)0.033333335f);
            }
        }

        @Override
        protected void drawInput(Tile other) {
            if (PressureLiquidBridge.this.linkValid(this.tile, other, false)) {
                float angle = this.tile.angleTo((Position)other);
                Tmp.v2.trns(angle, 2.0f);
                float tx = this.tile.drawx();
                float ty = this.tile.drawy();
                float ox = other.drawx();
                float oy = other.drawy();
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)2.5f);
                Lines.square((float)ox, (float)oy, (float)2.0f, (float)45.0f);
                Lines.square((float)tx, (float)ty, (float)2.0f, (float)45.0f);
                Lines.stroke((float)2.5f);
                Lines.line((float)(tx + Tmp.v2.x), (float)(ty + Tmp.v2.y), (float)(ox - Tmp.v2.x), (float)(oy - Tmp.v2.y));
                Draw.color((Color)Pal.place);
                Lines.stroke((float)1.0f);
                Lines.line((float)(tx + Tmp.v2.x), (float)(ty + Tmp.v2.y), (float)(ox - Tmp.v2.x), (float)(oy - Tmp.v2.y));
                Lines.square((float)ox, (float)oy, (float)2.0f, (float)45.0f);
                Lines.square((float)tx, (float)ty, (float)2.0f, (float)45.0f);
                Draw.mixcol((Color)Draw.getColor(), (float)1.0f);
                Draw.color();
                Draw.mixcol();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.pressure.write(write);
        }

        public void read(Reads read) {
            super.read(read);
            this.pressure.read(read);
        }
    }
}

