/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.meta.BlockGroup;
import omaloon.ui.MultiItemConfig;
import omaloon.ui.MultiItemData;
import omaloon.ui.MultiItemSelection;
import omaloon.utils.OlUtils;

public class TubeSorter
extends Block {
    public TubeSorter(String name) {
        super(name);
        this.update = false;
        this.destructible = true;
        this.underBullets = true;
        this.instantTransfer = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.unloadable = false;
        this.saveConfig = true;
        this.clearOnDoubleTap = true;
        MultiItemConfig.configure(this, build -> build.data);
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, this.name + "-center", false);
    }

    public boolean outputsItems() {
        return true;
    }

    public class TubeSorterBuild
    extends Building {
        public final MultiItemData data = new MultiItemData();

        public void configured(Unit player, Object value) {
            super.configured(player, value);
            if (!Vars.headless) {
                Vars.renderer.minimap.update(this.tile);
            }
        }

        public void draw() {
            int itemIndex;
            Item item;
            super.draw();
            if (this.data.length() > 0 && (item = OlUtils.getByIndexAsItem(this.data, (itemIndex = (int)Time.time / 40 + this.id) % this.data.length())) != null) {
                Draw.color((Color)item.color);
                Draw.rect((TextureRegion)Core.atlas.find(TubeSorter.this.name + "-center"), (float)this.x, (float)this.y);
                Draw.color();
            }
        }

        public boolean acceptItem(Building source, Item item) {
            Building to = this.getTileTarget(item, source, false);
            return to != null && to.acceptItem((Building)this, item) && to.team == this.team;
        }

        public void handleItem(Building source, Item item) {
            this.getTileTarget(item, source, true).handleItem((Building)this, item);
        }

        public boolean isSame(Building other) {
            return other != null && other.block.instantTransfer;
        }

        public Building getTileTarget(Item item, Building source, boolean flip) {
            Building to;
            byte dir = source.relativeTo((int)this.tile.x, (int)this.tile.y);
            if (dir == -1) {
                return null;
            }
            if (item != null && this.data.isToggled(item) && this.enabled) {
                if (this.isSame(source) && this.isSame(this.nearby(dir))) {
                    return null;
                }
                to = this.nearby(dir);
            } else {
                boolean bc;
                Building a = this.nearby(Mathf.mod((int)(dir - 1), (int)4));
                Building b = this.nearby(Mathf.mod((int)(dir + 1), (int)4));
                boolean ac = a != null && (!a.block.instantTransfer || !source.block.instantTransfer) && a.acceptItem((Building)this, item);
                boolean bl = bc = b != null && (!b.block.instantTransfer || !source.block.instantTransfer) && b.acceptItem((Building)this, item);
                if (ac && !bc) {
                    to = a;
                } else if (bc && !ac) {
                    to = b;
                } else {
                    if (!bc) {
                        return null;
                    }
                    Building building = to = (this.rotation & 1 << dir) == 0 ? a : b;
                    if (flip) {
                        this.rotation ^= 1 << dir;
                    }
                }
            }
            return to;
        }

        public void buildConfiguration(Table table) {
            MultiItemSelection.buildTable(table, this.data);
        }

        public int[] config() {
            return this.data.config();
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            this.data.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.data.read(read);
            if (revision == 1) {
                new DirectionalItemBuffer(20).read(read);
            }
        }
    }
}

