/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.func.Boolf;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.ItemBuffer;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class TubeItemBridge
extends ItemBridge {
    public Prov<Seq<Block>> connectBlocksGetter = Seq::new;
    Seq<Block> connectibleBlocks = new Seq();
    public Boolf<Building> connectFilter = building -> this.connectibleBlocks.contains((Object)building.block());
    public byte maxConnections = (byte)3;
    public final int timerAccept;
    public float speed;
    public int bufferCapacity;

    public TubeItemBridge(String name) {
        super(name);
        this.hasItems = true;
        this.timerAccept = this.timers++;
        this.speed = 40.0f;
        this.bufferCapacity = 50;
        this.hasPower = false;
        this.canOverdrive = true;
        this.swapDiagonalPlacement = true;
        this.configClear(b -> {
            b.link = -1;
        });
    }

    public TubeItemBridgeBuild cast(Building b) {
        return (TubeItemBridgeBuild)b;
    }

    public void init() {
        super.init();
        Seq connectibleBlocks = (Seq)this.connectBlocksGetter.get();
        if (connectibleBlocks == null) {
            connectibleBlocks = new Seq();
        }
        connectibleBlocks.add((Object)this);
        this.connectibleBlocks = connectibleBlocks;
        this.maxConnections = (byte)(this.maxConnections + 1);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
        this.stats.add(Stat.powerConnections, (float)(this.maxConnections - 1), StatUnit.none);
    }

    public void setBars() {
        super.setBars();
        this.addBar("connections", entity -> new Bar(() -> Core.bundle.format("bar.powerlines", new Object[]{this.cast((Building)entity).realConnections(), this.maxConnections - 1}), () -> Pal.items, () -> (float)this.cast((Building)entity).realConnections() / (float)(this.maxConnections - 1)));
    }

    public void drawBridge(BuildPlan req, float ox, float oy, float flip) {
        this.drawBridge(this.bridgeRegion, this.endRegion, new Vec2(req.drawx(), req.drawy()), new Vec2(ox, oy));
        Draw.rect((TextureRegion)this.arrowRegion, (float)((req.drawx() + ox) / 2.0f), (float)((req.drawy() + oy) / 2.0f), (float)Angles.angle((float)req.drawx(), (float)req.drawy(), (float)ox, (float)oy));
    }

    public void drawBridge(TextureRegion bridgeRegion, TextureRegion endRegion, Vec2 pos1, Vec2 pos2) {
        float angle = pos1.angleTo((Position)pos2) - 90.0f;
        if (angle >= 0.0f && angle < 180.0f) {
            Draw.yscl = -1.0f;
        }
        Tmp.v1.set(pos2.x, pos2.y).sub(pos1.x, pos1.y).setLength(4.0f);
        Lines.stroke((float)(8.0f * Draw.yscl));
        Lines.line((TextureRegion)bridgeRegion, (float)(pos1.x + Tmp.v1.x), (float)(pos1.y + Tmp.v1.y), (float)(pos2.x - Tmp.v1.x), (float)(pos2.y - Tmp.v1.y), (boolean)false);
        Draw.rect((TextureRegion)endRegion, (float)pos1.x, (float)pos1.y, (float)(angle + 90.0f));
        Draw.xscl = -1.0f;
        Draw.rect((TextureRegion)endRegion, (float)pos2.x, (float)pos2.y, (float)(angle + 90.0f));
        Draw.yscl = 1.0f;
        Draw.xscl = 1.0f;
    }

    public Tile findLink(int x, int y) {
        return this.findLinkTile(x, y, true);
    }

    public Tile findLinkTile(int x, int y, boolean checkBlock) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && this.lastBuild != null && this.lastBuild.tile != tile) {
            boolean validLink;
            boolean bl = checkBlock ? this.linkValid(tile, this.lastBuild.tile) && this.lastBuild.link == -1 : (validLink = this.linkValid(tile, this.lastBuild.tile, false, true));
            if (validLink) {
                return this.lastBuild.tile;
            }
        }
        return null;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile link = this.findLinkTile(x, y, false);
        Lines.stroke((float)1.0f);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.range * 8), (Color)Pal.placing);
        Draw.reset();
        Draw.color((Color)Pal.placing);
        if (link != null && Vars.world.build((int)link.x, (int)link.y) instanceof TubeItemBridgeBuild && Math.abs(link.x - x) + Math.abs(link.y - y) > 1) {
            Vec2 end = new Vec2((float)x, (float)y);
            Vec2 start = new Vec2((float)link.x, (float)link.y);
            float angle = Tmp.v1.set(start).sub(end).angle() + 90.0f;
            float layer = Draw.z();
            Draw.z((float)29.2f);
            Lines.poly((Vec2[])new Vec2[]{start.cpy().add(Tmp.v1.trns(angle, -0.4f)), end.cpy().add(Tmp.v1.trns(angle, -0.4f)), end.cpy().add(Tmp.v1.trns(angle, 0.4f)), start.cpy().add(Tmp.v1.trns(angle, 0.4f))}, (float)0.0f, (float)0.0f, (float)8.0f);
            Tmp.v1.set(start).sub(end).setLength(4.0f);
            Vec2 arrowOffset = Tmp.v1.cpy().setLength(1.0f);
            Draw.rect((String)"bridge-arrow", (float)(start.x * 8.0f - arrowOffset.x * 8.0f), (float)(start.y * 8.0f - arrowOffset.y * 8.0f), (float)(angle + 90.0f));
            Draw.z((float)layer);
        }
        Draw.reset();
    }

    public TextureRegion[] getGeneratedIcons() {
        return super.getGeneratedIcons();
    }

    public boolean linkValid(Tile tile, Tile other) {
        return this.linkValid(tile, other, true);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        return this.linkValid(tile, other, checkDouble, false);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble, boolean old) {
        if (old) {
            if (other != null && tile != null && this.positionsValid(tile.x, tile.y, other.x, other.y)) {
                return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof ItemBridge) && other.block() == this) && (other.team() == tile.team() || tile.block() != this) && (!checkDouble || ((ItemBridge.ItemBridgeBuild)other.build).link != tile.pos());
            }
            return false;
        }
        if (other != null && tile != null && other.build != null && tile.build != null) {
            boolean b2;
            other = other.build.tile;
            tile = tile.build.tile;
            int offset = other.block().isMultiblock() ? Mathf.floor((float)((float)other.block().size / 2.0f)) : 0;
            boolean bl = b2 = tile.pos() != other.pos();
            if (tile.block() == this) {
                Vec2 offVec = Tmp.v1.trns(tile.angleTo((Position)other) + 90.0f, (float)offset, (float)offset);
                if (this.positionsValid(tile.x, tile.y, Mathf.ceil((float)((float)other.x + offVec.x)), Mathf.ceil((float)((float)other.y + offVec.y)))) {
                    TubeItemBridge block = (TubeItemBridge)tile.block();
                    boolean connected = false;
                    if (other.build instanceof ItemBridge.ItemBridgeBuild) {
                        connected = ((ItemBridge.ItemBridgeBuild)other.build.as()).link == tile.pos();
                    }
                    return !(!block.connectFilter.get((Object)other.build) && (tile.block() instanceof ItemBridge || other.block() != this) || !b2 || other.team() != tile.team() && other.block() == this || checkDouble && connected);
                }
            } else if (this.positionsValid(tile.x, tile.y, other.x, other.y)) {
                boolean b3;
                boolean bl2 = b3 = other.team() == tile.team() || tile.block() != this;
                if (other.block() == this) {
                    other.block();
                    boolean b4 = !checkDouble || !(other.build instanceof ItemBridge.ItemBridgeBuild) || ((ItemBridge.ItemBridgeBuild)other.build).link != tile.pos();
                    return b2 && b3 && b4;
                }
                return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof ItemBridge) && other.block() == this) && b3 && (!checkDouble || ((ItemBridge.ItemBridgeBuild)other.build).link != tile.pos());
            }
        }
        return false;
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        return Mathf.within((float)x1, (float)y1, (float)x2, (float)y2, (float)((float)this.range + 0.5f));
    }

    public boolean positionsValid(Point2 pos, Point2 other) {
        return this.positionsValid(pos.x, pos.y, other.x, other.y);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, this::positionsValid);
    }

    public class TubeItemBridgeBuild
    extends ItemBridge.ItemBridgeBuild {
        ItemBuffer buffer;
        private boolean cachedLinkValid;
        private int cachedLink;

        public TubeItemBridgeBuild() {
            super((ItemBridge)TubeItemBridge.this);
            this.buffer = new ItemBuffer(TubeItemBridge.this.bufferCapacity);
            this.cachedLinkValid = false;
            this.cachedLink = -1;
        }

        public void drawBase() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y, (float)(this.block.rotate ? this.rotdeg() : 0.0f));
            this.drawTeamTop();
        }

        public boolean acceptIncoming(int pos) {
            if (this.incoming.size + 1 < TubeItemBridge.this.maxConnections && !this.incoming.contains(pos)) {
                this.incoming.add(pos);
            }
            return !this.incoming.contains(pos);
        }

        public void checkIncoming() {
            for (int i : this.incoming.toArray()) {
                boolean valid;
                Tile other = Vars.world.tile(i);
                boolean bl = valid = TubeItemBridge.this.linkValid(this.tile, other, false) && other.build instanceof ItemBridge.ItemBridgeBuild && ((ItemBridge.ItemBridgeBuild)other.build).link == this.tile.pos();
                if (valid) continue;
                this.incoming.removeValue(i);
            }
        }

        public int realConnections() {
            return this.incoming.size + (Vars.world.build(this.link) instanceof TubeItemBridgeBuild ? 1 : 0);
        }

        public boolean canLinked() {
            return this.realConnections() < TubeItemBridge.this.maxConnections;
        }

        public boolean canReLink() {
            return this.realConnections() <= TubeItemBridge.this.maxConnections && this.link != -1;
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (other instanceof ItemBridge.ItemBridgeBuild && ((ItemBridge.ItemBridgeBuild)other).link == this.pos()) {
                this.incoming.removeValue(other.pos());
                ((ItemBridge.ItemBridgeBuild)other.as()).incoming.add(this.pos());
                this.configure(other.pos());
                other.configure((Object)-1);
            } else if (TubeItemBridge.this.linkValid(this.tile, other.tile) && other instanceof TubeItemBridgeBuild) {
                TubeItemBridgeBuild bridge = (TubeItemBridgeBuild)other;
                if (this.link == other.pos()) {
                    ((ItemBridge.ItemBridgeBuild)other.as()).incoming.removeValue(this.pos());
                    this.incoming.add(other.pos());
                    this.configure(-1);
                } else if (TubeItemBridge.this.cast(other).canLinked() && (this.canLinked() || this.canReLink()) && this.realConnections() < TubeItemBridge.this.maxConnections - 1 && bridge.realConnections() < TubeItemBridge.this.maxConnections - 1) {
                    ((ItemBridge.ItemBridgeBuild)other.as()).incoming.add(this.pos());
                    this.incoming.removeValue(other.pos());
                    this.configure(other.pos());
                }
                return false;
            }
            return true;
        }

        public void updateTile() {
            this.incoming.size = Math.min(this.incoming.size, TubeItemBridge.this.maxConnections - (this.link == -1 ? (byte)0 : 1));
            this.incoming.shrink();
            if (this.timer(TubeItemBridge.this.timerCheckMoved, 30.0f)) {
                this.wasMoved = this.moved;
                this.moved = false;
            }
            this.time += this.wasMoved ? this.delta() : 0.0f;
            this.checkIncoming();
            Tile other = Vars.world.tile(this.link);
            if (!TubeItemBridge.this.linkValid(this.tile, other)) {
                this.doDump();
                this.warmup = 0.0f;
            } else {
                if (other.build instanceof ItemBridge.ItemBridgeBuild && other.build instanceof TubeItemBridgeBuild && TubeItemBridge.this.cast(other.build).acceptIncoming(this.tile.pos())) {
                    this.configureAny(-1);
                    return;
                }
                IntSeq inc = ((ItemBridge.ItemBridgeBuild)other.build).incoming;
                int pos = this.tile.pos();
                if (!inc.contains(pos)) {
                    inc.add(pos);
                }
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.efficiency(), (float)0.033333335f);
                this.updateTransport(other.build);
            }
        }

        public void updateTransport(Building other) {
            if (this.cachedLink != this.link || other == null || this.link == -1) {
                this.cachedLinkValid = TubeItemBridge.this.linkValid(this.tile, other.tile());
                this.cachedLink = this.link;
            }
            if (!this.cachedLinkValid) {
                this.doDump();
                this.warmup = 0.0f;
            } else {
                if (this.buffer.accepts() && this.items.total() > 0) {
                    this.buffer.accept(this.items.take());
                }
                Item item = this.buffer.poll(TubeItemBridge.this.speed / this.timeScale);
                if (this.timer(TubeItemBridge.this.timerAccept, 4.0f / this.timeScale) && item != null && other.acceptItem((Building)this, item)) {
                    this.moved = true;
                    other.handleItem((Building)this, item);
                    this.buffer.remove();
                }
            }
        }

        public void doDump() {
            this.dump();
        }

        public void draw() {
            this.drawBase();
            Draw.z((float)70.0f);
            Tile other = Vars.world.tile(this.link);
            Building build = Vars.world.build(this.link);
            if (build == this) {
                build = null;
            }
            if (build != null) {
                other = build.tile;
            }
            if (!TubeItemBridge.this.linkValid(this.tile, other) || build == null || Mathf.zero((float)Renderer.bridgeOpacity)) {
                return;
            }
            Vec2 pos1 = new Vec2(this.x, this.y);
            Vec2 pos2 = new Vec2(other.drawx(), other.drawy());
            if (TubeItemBridge.this.pulse) {
                Draw.color((Color)Color.white, (Color)Color.black, (float)Mathf.absin((float)Time.time, (float)6.0f, (float)0.07f));
            }
            Draw.alpha((float)Renderer.bridgeOpacity);
            TubeItemBridge.this.drawBridge(TubeItemBridge.this.bridgeRegion, TubeItemBridge.this.endRegion, pos1, pos2);
            Draw.color();
            int arrows = Mathf.round((float)(pos1.dst(pos2) / TubeItemBridge.this.arrowSpacing));
            float angle = pos1.angleTo((Position)pos2);
            Tmp.v2.trns(angle - 45.0f, 1.0f, 1.0f);
            for (float a = 0.0f; a < (float)(arrows - 2); a += 1.0f) {
                Draw.alpha((float)(Mathf.absin((float)(a - this.time / TubeItemBridge.this.arrowTimeScl), (float)TubeItemBridge.this.arrowPeriod, (float)1.0f) * this.warmup * Renderer.bridgeOpacity));
                float arrowX = this.x - Tmp.v1.x + Tmp.v2.x * (3.2f + a * TubeItemBridge.this.arrowSpacing + TubeItemBridge.this.arrowOffset);
                float arrowY = this.y - Tmp.v1.y + Tmp.v2.y * (3.2f + a * TubeItemBridge.this.arrowSpacing + TubeItemBridge.this.arrowOffset);
                Draw.rect((TextureRegion)TubeItemBridge.this.arrowRegion, (float)arrowX, (float)arrowY, (float)angle);
            }
            Draw.reset();
        }

        public void drawSelect() {
            if (TubeItemBridge.this.linkValid(this.tile, Vars.world.tile(this.link))) {
                this.drawInput(Vars.world.tile(this.link));
            }
            for (int pos : this.incoming.items) {
                this.drawInput(Vars.world.tile(pos));
            }
            Draw.reset();
        }

        protected void drawInput(Tile other) {
            if (TubeItemBridge.this.linkValid(this.tile, other, false)) {
                boolean linked = other.pos() == this.link;
                float angle = this.tile.angleTo((Position)other);
                Tmp.v2.trns(angle, 2.0f);
                float tx = this.tile.drawx();
                float ty = this.tile.drawy();
                float ox = other.drawx();
                float oy = other.drawy();
                float alpha = Math.abs((float)(linked ? 100 : 0) - Time.time * 2.0f % 100.0f) / 100.0f;
                float x = Mathf.lerp((float)ox, (float)tx, (float)alpha);
                float y = Mathf.lerp((float)oy, (float)ty, (float)alpha);
                Tile otherLink = linked ? other : this.tile;
                float rel = (linked ? this.tile : other).angleTo((Position)otherLink);
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)2.5f);
                Lines.square((float)ox, (float)oy, (float)2.0f, (float)45.0f);
                Lines.stroke((float)2.5f);
                Lines.line((float)(tx + Tmp.v2.x), (float)(ty + Tmp.v2.y), (float)(ox - Tmp.v2.x), (float)(oy - Tmp.v2.y));
                Draw.color((Color)(linked ? Pal.place : Pal.accent));
                Lines.stroke((float)1.0f);
                Lines.line((float)(tx + Tmp.v2.x), (float)(ty + Tmp.v2.y), (float)(ox - Tmp.v2.x), (float)(oy - Tmp.v2.y));
                Lines.square((float)ox, (float)oy, (float)2.0f, (float)45.0f);
                Draw.mixcol((Color)Draw.getColor(), (float)1.0f);
                Draw.color();
                Draw.rect((TextureRegion)TubeItemBridge.this.arrowRegion, (float)x, (float)y, (float)rel);
                Draw.mixcol();
            }
        }

        public void drawConfigure() {
            Drawf.select((float)this.x, (float)this.y, (float)((float)(this.tile.block().size * 8) / 2.0f + 2.0f), (Color)Pal.accent);
            Drawf.dashCircle((float)this.x, (float)this.y, (float)((float)TubeItemBridge.this.range * 8.0f), (Color)Pal.accent);
            Draw.color();
            if (!this.canReLink() && !this.canLinked() && this.realConnections() >= TubeItemBridge.this.maxConnections - 1) {
                return;
            }
            OrderedMap orderedMap = new OrderedMap();
            for (int x = -TubeItemBridge.this.range; x <= TubeItemBridge.this.range; ++x) {
                for (int y = -TubeItemBridge.this.range; y <= TubeItemBridge.this.range; ++y) {
                    Tile other2 = this.tile.nearby(x, y);
                    if (!TubeItemBridge.this.linkValid(this.tile, other2) || this.tile == other2 || orderedMap.containsKey((Object)other2.build)) continue;
                    orderedMap.put((Object)other2.build, (Object)false);
                }
            }
            Building linkBuilding = Vars.world.build(this.link);
            if (linkBuilding != null) {
                this.configure(linkBuilding.pos());
                orderedMap.remove((Object)linkBuilding);
                orderedMap.put((Object)linkBuilding, (Object)true);
            } else {
                this.configure(-1);
            }
            if (orderedMap.containsKey((Object)this)) {
                orderedMap.remove((Object)this);
            }
            orderedMap.each((other, linked) -> Drawf.select((float)other.x, (float)other.y, (float)((float)(other.block().size * 8) / 2.0f + 2.0f + (linked != false ? 0.0f : Mathf.absin((float)Time.time, (float)4.0f, (float)1.0f))), (Color)(linked != false ? Pal.place : Pal.breakInvalid)));
        }

        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read);
        }
    }
}

