/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.Graphics;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.type.Item;
import mindustry.world.blocks.distribution.OverflowGate;

public class TubeGate
extends OverflowGate {
    public TextureRegion topUnder;
    public Effect switchEffect = Fx.doorclose;
    public Sound switchSound = Sounds.door;

    public TubeGate(String name) {
        super(name);
        this.copyConfig = true;
        this.saveConfig = true;
        this.config(Boolean.class, (build, invert) -> {
            build.invert = invert;
        });
    }

    public void load() {
        super.load();
        this.topUnder = Core.atlas.find(this.name + "-top-underflow");
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        Boolean boll;
        Object object = plan.config;
        if (object instanceof Boolean && (boll = (Boolean)object).booleanValue()) {
            Draw.rect((TextureRegion)this.topUnder, (float)plan.drawx(), (float)plan.drawy(), (float)0.0f);
        }
    }

    public class TubeGateBuild
    extends OverflowGate.OverflowGateBuild {
        boolean invert;

        public TubeGateBuild() {
            super((OverflowGate)TubeGate.this);
            this.invert = false;
        }

        public void tapped() {
            TubeGate.this.switchEffect.at((Position)this, (float)TubeGate.this.size);
            TubeGate.this.switchSound.at((Position)this);
            this.configure(!this.invert);
        }

        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        public void draw() {
            super.draw();
            if (this.invert) {
                Draw.rect((TextureRegion)TubeGate.this.topUnder, (float)this.x, (float)this.y, (float)0.0f);
            }
        }

        public Object config() {
            return this.invert;
        }

        @Nullable
        public Building getTileTarget(Item item, Building src, boolean flip) {
            boolean inv;
            byte from = this.relativeToEdge(src.tile);
            if (from == -1) {
                return null;
            }
            Building to = this.nearby((from + 2) % 4);
            boolean fromInst = src.block.instantTransfer;
            boolean canForward = to != null && to.team == this.team && (!fromInst || !to.block.instantTransfer) && to.acceptItem((Building)this, item);
            boolean bl = inv = this.invert == this.enabled;
            if (!canForward || inv) {
                boolean bc;
                Building a = this.nearby(Mathf.mod((int)(from - 1), (int)4));
                Building b = this.nearby(Mathf.mod((int)(from + 1), (int)4));
                boolean ac = a != null && (!fromInst || !a.block.instantTransfer) && a.team == this.team && a.acceptItem((Building)this, item);
                boolean bl2 = bc = b != null && (!fromInst || !b.block.instantTransfer) && b.team == this.team && b.acceptItem((Building)this, item);
                if (!ac && !bc) {
                    return inv && canForward ? to : null;
                }
                if (ac && !bc) {
                    to = a;
                } else if (bc && !ac) {
                    to = b;
                } else {
                    Building building = to = (this.rotation & 1 << from) == 0 ? a : b;
                    if (flip) {
                        this.rotation ^= 1 << from;
                    }
                }
            }
            return to;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.invert = read.bool();
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.invert);
        }
    }
}

