/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import omaloon.utils.OlUtils;
import omaloon.world.blocks.distribution.TubeSorter;

public class TubeDistributor
extends Router {
    public DrawBlock drawer = new DrawDefault();
    public TextureRegion rotorRegion;
    public TextureRegion lockedRegion1;
    public TextureRegion lockedRegion2;

    public TubeDistributor(String name) {
        super(name);
        this.rotate = true;
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
        this.rotorRegion = Core.atlas.find(this.name + "-rotator");
        this.lockedRegion1 = Core.atlas.find(this.name + "-locked-side1");
        this.lockedRegion2 = Core.atlas.find(this.name + "-locked-side2");
        this.uiIcon = Core.atlas.find(this.name + "-icon");
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.rect((TextureRegion)Core.atlas.find(this.name + "-bottom"), (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.rotorRegion, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)(plan.rotation > 1 ? this.lockedRegion2 : this.lockedRegion1), (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-icon")};
    }

    public class TubeDistributorBuild
    extends Router.RouterBuild {
        public Item lastItem;
        public Tile lastInput;
        public int lastTargetAngle;
        public int lastSourceAngle;
        public float time;
        public float rot;
        public float angle;
        public float lastRot;
        public int lastRotation;

        public TubeDistributorBuild() {
            super((Router)TubeDistributor.this);
            this.lastRotation = this.rotation;
        }

        public void updateTile() {
            if (this.lastItem == null && this.items.any()) {
                this.lastItem = this.items.first();
            }
            if (this.lastItem != null) {
                Building target = this.getTileTarget(this.lastItem, this.lastInput, false);
                if (this.blockValidInDirection(this.targetAngle())) {
                    if (target != null || this.time < 1.0f) {
                        this.time += 1.0f / TubeDistributor.this.speed * this.delta();
                        if (this.time > 1.0f) {
                            this.time = 1.0f;
                        }
                    }
                } else if (this.time < 0.4f) {
                    this.time += 0.4f / TubeDistributor.this.speed * this.delta();
                    if (this.time > 0.4f) {
                        this.time = 0.4f;
                    }
                }
                if (target != null && this.time >= 1.0f) {
                    this.getTileTarget(this.lastItem, this.lastInput, true);
                    target.handleItem((Building)this, this.lastItem);
                    this.items.remove(this.lastItem, 1);
                    this.lastItem = null;
                    this.time = 0.0f;
                }
                if (this.lastInput != null && this.lastItem != null) {
                    int sa = this.sourceAngle();
                    int ta = this.targetAngle();
                    this.angle = this.computeAngle(sa, ta);
                }
                if (this.items.total() > 0 && !Vars.state.isPaused() && !(this.time >= 1.0f) && this.blockValidInDirection(this.targetAngle()) || !this.blockValidInDirection(this.targetAngle()) && !(this.time >= 0.4f)) {
                    this.lastRot = this.rot;
                    this.rot += TubeDistributor.this.speed * this.angle * this.delta();
                }
            }
        }

        private float computeAngle(int sa, int ta) {
            return sa == 0 ? (float)(ta == 2 ? 1 : (ta == 0 || ta == 3 ? -1 : 1)) : (sa == 2 ? (float)(ta == 0 || ta == 1 ? -1 : 1) : (sa == 1 ? (float)(ta == 0 || ta == 3 ? -1 : 1) : (float)(ta == 0 || ta == 1 ? 1 : -1)));
        }

        public boolean blockValidInDirection(int direction) {
            Tile targetTile = this.tile.nearby(direction);
            return targetTile != null && (targetTile.block().hasItems || targetTile.block() instanceof Junction || targetTile.block() instanceof TubeSorter || targetTile.block() instanceof OverflowGate);
        }

        public boolean acceptItem(Building source, Item item) {
            return this.team == source.team && this.lastItem == null && this.items.total() == 0 && this.front() != source;
        }

        public void handleItem(Building source, Item item) {
            this.items.add(item, 1);
            this.lastItem = item;
            this.time = 0.0f;
            this.lastInput = source.tile();
        }

        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (result != 0 && item == this.lastItem) {
                this.lastItem = null;
            }
            return result;
        }

        public int sourceAngle() {
            for (int sourceAngle = 0; sourceAngle < 4; ++sourceAngle) {
                if (this.nearby(sourceAngle) != this.lastInput.build) continue;
                this.lastSourceAngle = sourceAngle;
                return sourceAngle;
            }
            return this.lastSourceAngle;
        }

        public int targetAngle() {
            if (this.lastItem == null) {
                return this.lastTargetAngle;
            }
            Building target = this.getTileTarget(this.lastItem, this.lastInput, false);
            if (target != null) {
                for (int targetAngle = 0; targetAngle < 4; ++targetAngle) {
                    if (this.nearby(targetAngle) != target) continue;
                    this.lastTargetAngle = targetAngle;
                    return targetAngle;
                }
            }
            return this.lastTargetAngle;
        }

        public void drawItem() {
            if (this.lastInput != null && this.lastInput.build != null && this.lastItem != null) {
                float ox;
                float oy;
                boolean isf = OlUtils.reverse(this.sourceAngle()) == this.targetAngle() || this.sourceAngle() == this.targetAngle();
                boolean alignment = this.targetAngle() == 0 || this.targetAngle() == 2;
                float s = TubeDistributor.this.size * 4;
                float s2 = s * 2.0f;
                float linearMove = (float)Math.sin(Math.PI * (double)this.time) / 2.4f * s;
                if (alignment) {
                    if (isf) {
                        if (this.sourceAngle() == this.targetAngle()) {
                            float f = oy = this.time >= 0.5f ? linearMove : -linearMove;
                            ox = this.time >= 0.5f ? (this.time * s2 - s) * (float)(this.targetAngle() == 0 ? 1 : -1) : (this.time * s2 - s) * (float)(this.targetAngle() == 0 ? -1 : 1);
                        } else {
                            oy = linearMove;
                            ox = (this.time * s2 - s) * (float)(this.targetAngle() == 0 ? 1 : -1);
                        }
                    } else {
                        oy = this.sourceAngle() == 1 ? this.time * -s + s : this.time * s - s;
                        ox = this.time * s * (float)(this.targetAngle() == 0 ? 1 : -1);
                    }
                } else if (isf) {
                    if (this.sourceAngle() == this.targetAngle()) {
                        float f = ox = this.time >= 0.5f ? linearMove : -linearMove;
                        oy = this.time >= 0.5f ? (this.time * s2 - s) * (float)(this.targetAngle() == 1 ? 1 : -1) : (this.time * s2 - s) * (float)(this.targetAngle() == 1 ? -1 : 1);
                    } else {
                        ox = (float)Math.sin(Math.PI * (double)this.time) / 2.4f * s;
                        oy = (this.time * s2 - s) * (float)(this.targetAngle() == 1 ? 1 : -1);
                    }
                } else {
                    ox = this.sourceAngle() == 0 ? this.time * -s + s : this.time * s - s;
                    oy = this.time * s * (float)(this.targetAngle() == 1 ? 1 : -1);
                }
                Draw.rect((TextureRegion)this.lastItem.fullIcon, (float)(this.x + ox), (float)(this.y + oy), (float)5.0f, (float)5.0f);
            }
        }

        public void draw() {
            TubeDistributor.this.drawer.draw((Building)this);
            Draw.z((float)29.8f);
            this.drawItem();
            Draw.z((float)29.85f);
            Drawf.spinSprite((TextureRegion)TubeDistributor.this.rotorRegion, (float)this.x, (float)this.y, (float)(this.rot % 360.0f));
            Draw.rect((TextureRegion)TubeDistributor.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)(this.rotation > 1 ? TubeDistributor.this.lockedRegion2 : TubeDistributor.this.lockedRegion1), (float)this.x, (float)this.y, (float)this.rotdeg());
        }

        public Building getTileTarget(Item item, Tile from, boolean set) {
            int counter = this.lastRotation;
            for (int i = 0; i < this.proximity.size; ++i) {
                Building other = (Building)this.proximity.get((i + counter) % this.proximity.size);
                if (set) {
                    this.lastRotation = (byte)((this.lastRotation + 1) % this.proximity.size);
                }
                if (other.tile == from && from.block() == Blocks.overflowGate || !other.acceptItem((Building)this, item)) continue;
                return other;
            }
            return null;
        }
    }
}

