/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.defense;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Statusc;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import omaloon.content.OlFx;
import omaloon.content.OlSounds;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class BlastTower
extends Block {
    public PressureConfig pressureConfig = new PressureConfig();
    public boolean useConsumerMultiplier = true;
    public float shake = 3.0f;
    public float range = 110.0f;
    public float reload = 90.0f;
    public float chargeTime = 90.0f;
    public float damage = 60.0f;
    public StatusEffect status = StatusEffects.unmoving;
    public float statusDuration = 60.0f;
    public boolean targetAir = false;
    public boolean targetGround = true;
    public Color hitColor = Pal.accent;
    public Effect hitEffect = Fx.hitBulletColor;
    public Color waveColor = Color.white;
    public Effect waveEffect = Fx.dynamicWave;
    public Sound shootSound = OlSounds.hammer;
    public TextureRegion hammerRegion;

    public BlastTower(String name) {
        super(name);
        this.update = true;
        this.solid = true;
    }

    public void load() {
        super.load();
        this.hammerRegion = Core.atlas.find(this.name + "-hammer");
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        this.stats.add(Stat.damage, this.damage, StatUnit.none);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
        this.pressureConfig.addStats(this.stats);
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars(this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.rect((TextureRegion)this.hammerRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.hammerRegion};
    }

    public class BlastTowerBuild
    extends Building
    implements HasPressure {
        public PressureModule pressure = new PressureModule();
        public float smoothProgress = 0.0f;
        public float charge;
        public float lastShootTime;
        public Seq<Teamc> targets;

        public BlastTowerBuild() {
            this.lastShootTime = -BlastTower.this.reload;
            this.targets = new Seq();
        }

        public float efficiencyMultiplier() {
            float val = 1.0f;
            if (!BlastTower.this.useConsumerMultiplier) {
                return val;
            }
            for (Consume consumer : BlastTower.this.consumers) {
                val *= consumer.efficiencyMultiplier((Building)this);
            }
            return val;
        }

        public void updateTile() {
            this.updatePressure();
            this.dumpPressure();
            super.updateTile();
            this.targets.clear();
            Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)BlastTower.this.range, u -> {
                if (u.checkTarget(BlastTower.this.targetAir, BlastTower.this.targetGround)) {
                    this.targets.add(u);
                }
            });
            Vars.indexer.allBuildings(this.x, this.y, BlastTower.this.range, b -> {
                if (b.team != this.team) {
                    this.targets.add(b);
                }
            });
            float effMultiplier = this.efficiencyMultiplier();
            if (this.targets.size > 0 && this.canConsume()) {
                this.smoothProgress = Mathf.approach((float)this.smoothProgress, (float)1.0f, (float)(Time.delta / BlastTower.this.chargeTime * effMultiplier));
                if (this.efficiency > 0.0f) {
                    float f;
                    this.charge += Time.delta * effMultiplier;
                    if (f >= BlastTower.this.reload && this.smoothProgress >= 0.99f) {
                        this.shoot();
                        this.charge = 0.0f;
                    }
                }
            } else {
                this.smoothProgress = Mathf.approach((float)this.smoothProgress, (float)0.0f, (float)(Time.delta / BlastTower.this.chargeTime * effMultiplier));
            }
        }

        public void shoot() {
            if (!this.canConsume()) {
                return;
            }
            this.consume();
            this.lastShootTime = Time.time;
            Effect.shake((float)BlastTower.this.shake, (float)BlastTower.this.shake, (Position)this);
            BlastTower.this.shootSound.at((Position)this);
            BlastTower.this.waveEffect.layer(29.5f).at(this.x, this.y, BlastTower.this.range, BlastTower.this.waveColor);
            this.tile.getLinkedTiles(t -> OlFx.hammerHit.layer(29.5f).at(t.worldx(), t.worldy(), this.angleTo(t.worldx(), t.worldy()) + Mathf.range((float)360.0f), Tmp.c1.set(t.floor().mapColor).mul(1.5f + Mathf.range((float)0.15f))));
            float damageMultiplier = this.efficiencyMultiplier();
            for (Teamc target : this.targets) {
                BlastTower.this.hitEffect.at(target.x(), target.y(), BlastTower.this.hitColor);
                if (target instanceof Healthc) {
                    ((Healthc)target).damage(BlastTower.this.damage * damageMultiplier);
                }
                if (!(target instanceof Statusc)) continue;
                ((Statusc)target).apply(BlastTower.this.status, BlastTower.this.statusDuration);
            }
            this.smoothProgress = 0.0f;
        }

        public void draw() {
            Draw.rect((TextureRegion)BlastTower.this.region, (float)this.x, (float)this.y);
            float fract = Mathf.clamp((float)this.smoothProgress, (float)0.25f, (float)0.3f);
            Draw.color((Color)Pal.shadow, (float)Pal.shadow.a);
            Draw.rect((TextureRegion)BlastTower.this.hammerRegion, (float)(this.x - (fract - 0.25f) * 40.0f), (float)(this.y - (fract - 0.25f) * 40.0f), (float)((float)BlastTower.this.hammerRegion.width * fract), (float)((float)BlastTower.this.hammerRegion.width * fract));
            Draw.color();
            Draw.z((float)31.0f);
            Draw.rect((TextureRegion)BlastTower.this.hammerRegion, (float)this.x, (float)this.y, (float)((float)BlastTower.this.hammerRegion.width * fract), (float)((float)BlastTower.this.hammerRegion.height * fract));
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)BlastTower.this.range, (Color)Pal.accent);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.lastShootTime);
            write.f(this.smoothProgress);
            write.f(this.charge);
            this.pressure.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.lastShootTime = read.f();
            this.smoothProgress = read.f();
            this.charge = read.f();
            this.pressure.read(read);
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return BlastTower.this.pressureConfig;
        }
    }
}

