/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.fragments;

import arc.Core;
import arc.Events;
import arc.KeyBinds;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.geom.Geometry;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.StaticWall;
import omaloon.OmaloonMod;
import omaloon.type.customshape.CustomShape;
import omaloon.ui.OlBinding;
import omaloon.world.blocks.environment.CustomShapeProp;
import omaloon.world.blocks.environment.CustomShapePropProcess;

public class ShapedEnvPlacerFragment
extends Table {
    private Table indicator;
    private boolean selecting = false;
    private final Color col2 = Color.valueOf((String)"75edff");
    private Block currentBlock;
    private int currentShape = 1;
    private final Vec2 lastMousePosition = new Vec2();
    private final int[] group1 = new int[]{1, 5, 3, 7};
    private final int[] group2 = new int[]{2, 6, 4, 8};

    public ShapedEnvPlacerFragment() {
        this.setFillParent(true);
        this.visible(() -> Vars.ui.hudfrag.shown && OmaloonMod.editorListener.isEditor());
        this.touchable(() -> this.selecting && this.visible ? Touchable.enabled : Touchable.disabled);
        this.update(() -> {
            if (this.selecting) {
                Core.scene.setKeyboardFocus((Element)this);
                Core.scene.setScrollFocus((Element)this);
            }
        });
        this.bottom();
        this.table(Styles.black5, t1 -> {
            this.indicator = t1;
            t1.margin(10.0f);
            t1.table(t2 -> {
                t2.image((Drawable)Icon.treeSmall).size(15.0f).center().padRight(15.0f).color(this.col2);
                ((Label)t2.label(() -> "@fragment.omaloon-shaped-env-placer").grow().center().get()).setAlignment(1);
                t2.image((Drawable)Icon.treeSmall).size(15.0f).center().padLeft(15.0f).color(this.col2);
            }).growX();
            t1.row();
            t1.pane(Styles.smallPane, selector -> Vars.content.blocks().each(block -> block instanceof CustomShapeProp, block -> {
                Button b = (Button)selector.button(button -> button.add((Element)new Image(block.uiIcon).setScaling(Scaling.fit)).size(32.0f), new Button.ButtonStyle(){
                    {
                        this.up = Tex.windowEmpty;
                        this.down = Tex.windowEmpty;
                        this.checked = Tex.buttonSelect;
                    }
                }, () -> {
                    this.currentBlock = block;
                    this.currentShape = 1;
                }).size(50.0f).tooltip(block.localizedName).get();
                b.update(() -> b.setChecked(this.currentBlock == block));
            })).size(300.0f, 50.0f).padTop(5.0f);
            t1.row();
            t1.button(b -> b.add((CharSequence)"@place"), new Button.ButtonStyle(){
                {
                    this.up = Tex.windowEmpty;
                    this.down = Tex.windowEmpty;
                    this.over = Tex.buttonSelect;
                }
            }, () -> {
                if (this.selecting && this.visible) {
                    this.place();
                }
            }).size(120.0f, 40.0f).pad(5.0f);
            t1.setTransform(true);
        }).fill().bottom();
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.selecting = false;
            this.hideUI();
        });
        Events.run((Object)EventType.Trigger.draw, ShapedEnvPlacerFragment::drawPreview);
    }

    public void build(Group parent) {
        this.indicator.actions(new Action[]{Actions.alpha((float)0.0f)});
        parent.addChildAt(0, (Element)this);
        if (!Vars.mobile) {
            Core.scene.addListener((EventListener)new InputListener(){

                public boolean keyDown(InputEvent event, KeyCode keycode) {
                    if (Core.input.keyTap((KeyBinds.KeyBind)OlBinding.shaped_env_placer) && ShapedEnvPlacerFragment.this.visible) {
                        ShapedEnvPlacerFragment.this.toggle();
                        return true;
                    }
                    if (ShapedEnvPlacerFragment.this.selecting && ShapedEnvPlacerFragment.this.visible && ShapedEnvPlacerFragment.this.currentBlock != null && ((CustomShapeProp)((ShapedEnvPlacerFragment)ShapedEnvPlacerFragment.this).currentBlock).canMirror) {
                        if (Core.input.keyTap((KeyBinds.KeyBind)Binding.schematic_flip_x)) {
                            ShapedEnvPlacerFragment.this.mirrorHorizontally();
                            return true;
                        }
                        if (Core.input.keyTap((KeyBinds.KeyBind)Binding.schematic_flip_y)) {
                            ShapedEnvPlacerFragment.this.mirrorVertically();
                            return true;
                        }
                    }
                    return false;
                }

                public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                    if (ShapedEnvPlacerFragment.this.selecting && ShapedEnvPlacerFragment.this.visible) {
                        ShapedEnvPlacerFragment.this.changeShape((int)Math.signum(-amountY));
                        return true;
                    }
                    return false;
                }
            });
        }
        Core.scene.root.addListener((EventListener)new ElementGestureListener(){

            public void tap(InputEvent event, float x, float y, int count, KeyCode button) {
                if (ShapedEnvPlacerFragment.this.selecting && ShapedEnvPlacerFragment.this.visible && ShapedEnvPlacerFragment.this.isOverIndicator(x, y)) {
                    ShapedEnvPlacerFragment.this.updateMousePosition(x, y);
                }
            }
        });
    }

    private boolean isOverIndicator(float x, float y) {
        if (this.indicator == null) {
            return true;
        }
        return !(x >= this.indicator.x && x <= this.indicator.x + this.indicator.getWidth() && y >= this.indicator.y && y <= this.indicator.y + this.indicator.getHeight());
    }

    private static void drawPreview() {
        Block block;
        if (!(OmaloonMod.shapedEnvPlacerFragment.selecting && OmaloonMod.shapedEnvPlacerFragment.visible && (block = OmaloonMod.shapedEnvPlacerFragment.currentBlock) instanceof CustomShapeProp)) {
            return;
        }
        CustomShapeProp block2 = (CustomShapeProp)block;
        int tileX = World.toTile((float)OmaloonMod.shapedEnvPlacerFragment.lastMousePosition.x);
        int tileY = World.toTile((float)OmaloonMod.shapedEnvPlacerFragment.lastMousePosition.y);
        int[][] overlaps = new int[Vars.world.width()][Vars.world.height()];
        for (int i = 0; i < ((CustomShape)block2.shapes.get((int)(OmaloonMod.shapedEnvPlacerFragment.currentShape - 1))).blocks.initialWordsAmount; ++i) {
            int dy;
            int dx;
            Tile tile;
            if ((((CustomShape)block2.shapes.get((int)(OmaloonMod.shapedEnvPlacerFragment.currentShape - 1))).blocks.get(i) & 2) != 2 || (tile = Vars.world.tile(tileX + (dx = ((CustomShape)block2.shapes.get(OmaloonMod.shapedEnvPlacerFragment.currentShape - 1)).unpackX(i)), tileY + (dy = ((CustomShape)block2.shapes.get(OmaloonMod.shapedEnvPlacerFragment.currentShape - 1)).unpackY(i)))) == null) continue;
            Draw.z((float)120.0f);
            Lines.stroke((float)2.0f, (Color)(tile.block() instanceof StaticWall || tile.block() instanceof CustomShapeProp ? Pal.remove : Pal.accent));
            Draw.alpha((float)0.7f);
            Fill.square((float)tile.worldx(), (float)tile.worldy(), (float)4.0f);
            if (tile.block() instanceof StaticWall || tile.block() instanceof CustomShapeProp) continue;
            for (int j = 0; j < 4; ++j) {
                int neighborX = tileX + dx + Geometry.d4x[j];
                int neighborY = tileY + dy + Geometry.d4y[j];
                Tile neighborTile = Vars.world.tile(neighborX, neighborY);
                if (neighborTile == null || !(neighborTile.block() instanceof CustomShapeProp) || overlaps[neighborX][neighborY] >= 2) continue;
                Draw.z((float)120.0f);
                Lines.stroke((float)2.0f, (Color)Pal.remove);
                Draw.alpha((float)0.35f);
                Fill.square((float)neighborTile.worldx(), (float)neighborTile.worldy(), (float)4.0f);
                int[] nArray = overlaps[neighborX];
                int n = neighborY;
                nArray[n] = nArray[n] + 1;
            }
        }
        Draw.reset();
    }

    private boolean canPlace() {
        Block block = this.currentBlock;
        if (!(block instanceof CustomShapeProp)) {
            return false;
        }
        CustomShapeProp block2 = (CustomShapeProp)block;
        int tileX = World.toTile((float)this.lastMousePosition.x);
        int tileY = World.toTile((float)this.lastMousePosition.y);
        for (int i = 0; i < ((CustomShape)block2.shapes.get((int)(this.currentShape - 1))).blocks.initialWordsAmount; ++i) {
            int dy;
            if ((((CustomShape)block2.shapes.get((int)(this.currentShape - 1))).blocks.get(i) & 2) != 2) continue;
            int dx = ((CustomShape)block2.shapes.get(this.currentShape - 1)).unpackX(i);
            Tile tile = Vars.world.tile(tileX + dx, tileY + (dy = ((CustomShape)block2.shapes.get(this.currentShape - 1)).unpackY(i)));
            if (tile != null && (tile.block() instanceof StaticWall || tile.block() instanceof CustomShapeProp)) {
                return false;
            }
            for (int j = 0; j < 4; ++j) {
                int neighborX = tileX + dx + Geometry.d4x[j];
                int neighborY = tileY + dy + Geometry.d4y[j];
                Tile neighborTile = Vars.world.tile(neighborX, neighborY);
                if (neighborTile == null || !(neighborTile.block() instanceof CustomShapeProp)) continue;
                return false;
            }
        }
        return true;
    }

    private void place() {
        if (!this.canPlace()) {
            return;
        }
        Block block = this.currentBlock;
        if (!(block instanceof CustomShapeProp)) {
            return;
        }
        CustomShapeProp block2 = (CustomShapeProp)block;
        int tileX = World.toTile((float)this.lastMousePosition.x);
        int tileY = World.toTile((float)this.lastMousePosition.y);
        for (int i = 0; i < ((CustomShape)block2.shapes.get((int)(this.currentShape - 1))).blocks.initialWordsAmount; ++i) {
            int dy;
            int dx;
            Tile tile;
            if ((((CustomShape)block2.shapes.get((int)(this.currentShape - 1))).blocks.get(i) & 2) != 2 || (tile = Vars.world.tile(tileX + (dx = ((CustomShape)block2.shapes.get(this.currentShape - 1)).unpackX(i)), tileY + (dy = ((CustomShape)block2.shapes.get(this.currentShape - 1)).unpackY(i)))) == null) continue;
            Call.setTile((Tile)tile, (Block)this.currentBlock, (Team)tile.team(), (int)0);
        }
        CustomShapePropProcess.instance.init();
    }

    public void toggle() {
        if (!this.visible || this.indicator.hasActions()) {
            return;
        }
        boolean bl = this.selecting = !this.selecting;
        if (this.selecting) {
            this.showUI();
            this.lastMousePosition.set(Core.input.mouseWorld());
        } else {
            this.hideUI();
            Core.scene.setKeyboardFocus(null);
            Core.scene.setScrollFocus(null);
        }
    }

    private void showUI() {
        this.indicator.actions(new Action[]{Actions.moveBy((float)0.0f, (float)(-this.indicator.getHeight())), Actions.parallel((Action)Actions.alpha((float)1.0f, (float)0.3f, (Interp)Interp.pow3Out), (Action)Actions.moveBy((float)0.0f, (float)this.indicator.getHeight(), (float)0.3f, (Interp)Interp.pow3Out))});
    }

    private void hideUI() {
        this.indicator.actions(new Action[]{Actions.parallel((Action)Actions.moveBy((float)0.0f, (float)(-this.indicator.getHeight()), (float)0.3f, (Interp)Interp.pow3In), (Action)Actions.alpha((float)0.0f, (float)0.3f, (Interp)Interp.pow3In)), Actions.moveBy((float)0.0f, (float)this.indicator.getHeight())});
    }

    private void updateMousePosition(float x, float y) {
        this.lastMousePosition.set(Core.input.mouseWorld(x, y));
    }

    private void changeShape(int delta) {
        if (this.currentBlock instanceof CustomShapeProp) {
            int[] currentGroup = this.currentShape % 2 == 1 ? this.group1 : this.group2;
            int currentIndex = this.findIndex(currentGroup, this.currentShape);
            if (currentIndex != -1) {
                currentIndex = (currentIndex + delta + 4) % 4;
                this.currentShape = currentGroup[currentIndex];
            }
            this.updateCurrentShape();
        }
    }

    private void mirrorVertically() {
        int[][] nArrayArray;
        if (this.currentShape <= 4) {
            int[][] nArrayArray2 = new int[2][];
            nArrayArray2[0] = new int[]{1, 4};
            nArrayArray = nArrayArray2;
            nArrayArray2[1] = new int[]{2, 3};
        } else {
            int[][] nArrayArray3 = new int[2][];
            nArrayArray3[0] = new int[]{5, 6};
            nArrayArray = nArrayArray3;
            nArrayArray3[1] = new int[]{8, 7};
        }
        int[][] pairs = nArrayArray;
        this.applyMirror(pairs);
    }

    private void mirrorHorizontally() {
        int[][] nArrayArray;
        if (this.currentShape <= 4) {
            int[][] nArrayArray2 = new int[2][];
            nArrayArray2[0] = new int[]{1, 2};
            nArrayArray = nArrayArray2;
            nArrayArray2[1] = new int[]{3, 4};
        } else {
            int[][] nArrayArray3 = new int[2][];
            nArrayArray3[0] = new int[]{5, 8};
            nArrayArray = nArrayArray3;
            nArrayArray3[1] = new int[]{7, 6};
        }
        int[][] pairs = nArrayArray;
        this.applyMirror(pairs);
    }

    private void applyMirror(int[][] pairs) {
        for (int[] pair : pairs) {
            if (this.currentShape == pair[0]) {
                this.currentShape = pair[1];
                return;
            }
            if (this.currentShape != pair[1]) continue;
            this.currentShape = pair[0];
            return;
        }
    }

    private int findIndex(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    private void updateCurrentShape() {
        Block block = this.currentBlock;
        if (block instanceof CustomShapeProp) {
            CustomShapeProp block2 = (CustomShapeProp)block;
            int totalShapes = block2.shapes.size;
            this.currentShape = Math.min(Math.max(this.currentShape, 1), totalShapes);
        }
    }
}

