/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.dialogs;

import arc.Core;
import arc.KeyBinds;
import arc.graphics.Color;
import arc.input.InputDevice;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.Strings;
import arc.util.Time;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import omaloon.ui.OlBinding;

public class OlInputDialog
extends BaseDialog {
    ObjectMap<String, Table> categories = new ObjectMap();
    Table rebindTable;
    Dialog rebindDialog;
    boolean rebindAxis;
    boolean rebindMin;
    KeyBinds.KeyBind rebindKey;
    KeyCode minKey;

    public OlInputDialog() {
        super("@keybind.title");
        this.addCloseButton();
        this.setFillParent(true);
        this.fill(Styles.black5, t -> {
            this.rebindTable = t;
        });
        this.rebindTable.actions(new Action[]{Actions.fadeOut((float)0.0f)});
        this.rebindDialog = new Dialog("a", new Dialog.DialogStyle(){
            {
                this.titleFont = Fonts.def;
            }
        });
        this.shown(this::build);
    }

    private void build() {
        this.cont.clear();
        this.categories.clear();
        this.cont.pane(table -> {
            for (KeyBinds.Section section : Core.keybinds.getSections()) {
                OlBinding[] binds;
                for (OlBinding keybind : binds = OlBinding.values()) {
                    Table t = (Table)this.categories.get((Object)keybind.category(), () -> {
                        table.row();
                        return (Table)((Table)table.table(init -> {
                            init.label(() -> Core.bundle.get("binding.category-" + keybind.category())).color(Pal.accent).row();
                            init.image().color(Pal.accent).growX().row();
                        }).get()).table().minWidth(400.0f).padTop(10.0f).growX().get();
                    });
                    if (keybind.defaultValue(section.device.type()) instanceof KeyBinds.Axis) {
                        t.add((CharSequence)Core.bundle.get("keybind." + keybind.name() + ".name", Strings.capitalize((String)keybind.name())), Color.white).left().padRight(40.0f).padLeft(8.0f);
                        t.labelWrap(() -> {
                            KeyBinds.Axis axis = Core.keybinds.get(section, (KeyBinds.KeyBind)keybind);
                            return axis.key != null ? axis.key.toString() : axis.min + " [red]/[] " + axis.max;
                        }).color(Pal.accent).left().minWidth(90.0f).fillX().padRight(20.0f);
                        t.button("@settings.rebind", Styles.defaultt, () -> {
                            if (!this.rebindTable.hasActions()) {
                                this.rebindAxis = true;
                                this.rebindMin = true;
                                this.openDialog(section, keybind, true);
                            }
                        }).width(130.0f);
                    } else {
                        t.add((CharSequence)Core.bundle.get("keybind." + keybind.name() + ".name", Strings.capitalize((String)keybind.name())), Color.white).left().padRight(40.0f).padLeft(8.0f);
                        t.label(() -> Core.keybinds.get((KeyBinds.Section)section, (KeyBinds.KeyBind)keybind).key.toString()).color(Pal.accent).left().minWidth(90.0f).padRight(20.0f);
                        t.button("@settings.rebind", Styles.defaultt, () -> {
                            if (!this.rebindTable.hasActions()) {
                                this.rebindAxis = false;
                                this.rebindMin = false;
                                this.openDialog(section, keybind, true);
                            }
                        }).width(130.0f);
                    }
                    t.button("@settings.resetKey", Styles.defaultt, () -> Core.keybinds.resetToDefault(section, (KeyBinds.KeyBind)keybind)).width(130.0f).pad(2.0f).padLeft(4.0f);
                    t.row();
                }
            }
        }).height(800.0f);
    }

    private void openDialog(final KeyBinds.Section section, final KeyBinds.KeyBind name, boolean act) {
        this.rebindTable.clear();
        this.rebindTable.add((CharSequence)(this.rebindAxis ? Core.bundle.get("keybind.press.axis") : Core.bundle.get("keybind.press")));
        this.rebindKey = name;
        this.rebindDialog.show();
        this.rebindDialog.clear();
        if (section.device.type() == InputDevice.DeviceType.keyboard) {
            this.rebindDialog.addListener((EventListener)new InputListener(){

                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                    if (Core.app.isAndroid() || OlInputDialog.this.rebindTable.hasActions()) {
                        return false;
                    }
                    OlInputDialog.this.rebind(section, name, button);
                    return false;
                }

                public boolean keyDown(InputEvent event, KeyCode keycode) {
                    if (keycode == KeyCode.escape || OlInputDialog.this.rebindTable.hasActions()) {
                        return false;
                    }
                    OlInputDialog.this.rebind(section, name, keycode);
                    return false;
                }

                public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                    if (!OlInputDialog.this.rebindAxis || OlInputDialog.this.rebindTable.hasActions()) {
                        return false;
                    }
                    OlInputDialog.this.rebind(section, name, KeyCode.scroll);
                    return false;
                }
            });
        }
        if (act) {
            this.rebindTable.actions(new Action[]{Actions.moveBy((float)this.rebindTable.getWidth(), (float)0.0f), Actions.fadeIn((float)0.0f), Actions.moveBy((float)(-this.rebindTable.getWidth()), (float)0.0f, (float)0.5f, (Interp)Interp.sine)});
        }
        Time.runTask((float)30.0f, () -> this.getScene().setScrollFocus((Element)this.rebindDialog));
    }

    private void rebind(KeyBinds.Section section, KeyBinds.KeyBind bind, KeyCode newKey) {
        this.rebindDialog.hide();
        if (this.rebindKey == null) {
            return;
        }
        boolean isAxis = bind.defaultValue(section.device.type()) instanceof KeyBinds.Axis;
        if (isAxis) {
            if (newKey.axis || !this.rebindMin) {
                ((OrderedMap)section.binds.get((Object)section.device.type(), OrderedMap::new)).put((Object)this.rebindKey, (Object)(newKey.axis ? new KeyBinds.Axis(newKey) : new KeyBinds.Axis(this.minKey, newKey)));
            }
        } else {
            ((OrderedMap)section.binds.get((Object)section.device.type(), OrderedMap::new)).put((Object)this.rebindKey, (Object)new KeyBinds.Axis(newKey));
        }
        if (this.rebindAxis && isAxis && this.rebindMin && !newKey.axis) {
            this.minKey = newKey;
            this.openDialog(section, this.rebindKey, false);
        } else {
            this.rebindKey = null;
            this.rebindAxis = false;
            this.rebindTable.actions(new Action[]{Actions.moveBy((float)this.rebindTable.getWidth(), (float)0.0f, (float)0.5f, (Interp)Interp.sine), Actions.fadeOut((float)0.0f), Actions.moveBy((float)(-this.rebindTable.getWidth()), (float)0.0f)});
        }
    }
}

