/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui;

import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.world.Block;
import omaloon.ui.MultiItemData;

public class MultiItemSelection {
    private static TextField search;
    private static int rowCount;

    public static void buildTable(Table table, MultiItemData data) {
        MultiItemSelection.buildTable(table, (Seq<Item>)Vars.content.items(), data);
    }

    public static void buildTable(Table table, Seq<Item> items, MultiItemData data) {
        MultiItemSelection.buildTable(table, items, data::isToggled, data::toggle);
    }

    public static <T extends UnlockableContent> void buildTable(Table table, Seq<T> items, Boolf<T> holder, Cons<T> toggle) {
        MultiItemSelection.buildTable(null, table, items, holder, toggle, 5, 4);
    }

    public static <T extends UnlockableContent> void buildTable(@Nullable Block block, Table table, Seq<T> items, Boolf<T> holder, Cons<T> toggle, int rows, int columns) {
        Table cont = new Table().top();
        cont.defaults().size(40.0f);
        if (search != null) {
            search.clearText();
        }
        Runnable rebuild = () -> {
            cont.clearChildren();
            String text = search != null ? search.getText() : "";
            int i = 0;
            rowCount = 0;
            Seq list = items.select(u -> text.isEmpty() || u.localizedName.toLowerCase().contains(text.toLowerCase()));
            for (UnlockableContent item : list) {
                Item checkVisible;
                if (!item.unlockedNow() || item instanceof Item && Vars.state.rules.hiddenBuildItems.contains((Object)(checkVisible = (Item)item)) || item.isHidden()) continue;
                ImageButton button = (ImageButton)cont.button(Tex.whiteui, Styles.clearNoneTogglei, Mathf.clamp((float)item.selectionSize, (float)0.0f, (float)40.0f), () -> {}).tooltip(item.localizedName).get();
                button.changed(() -> toggle.get((Object)item));
                button.getStyle().imageUp = new TextureRegionDrawable(item.uiIcon);
                button.update(() -> button.setChecked(holder.get((Object)item)));
                if (i++ % columns != columns - 1) continue;
                cont.row();
                ++rowCount;
            }
        };
        rebuild.run();
        Table main = new Table().background(Styles.black6);
        if ((float)rowCount > (float)rows * 1.5f) {
            main.table(s -> {
                s.image((Drawable)Icon.zoom).padLeft(4.0f);
                search = (TextField)s.field(null, text -> rebuild.run()).padBottom(4.0f).left().growX().get();
                search.setMessageText("@players.search");
            }).fillX().row();
        }
        ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
        pane.setScrollingDisabled(true, false);
        if (block != null) {
            pane.setScrollYForce(block.selectScroll);
            pane.update(() -> {
                block.selectScroll = pane.getScrollY();
            });
        }
        pane.setOverscroll(false, false);
        main.add((Element)pane).maxHeight((float)(40 * rows));
        table.top().add((Element)main);
    }
}

