/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type.weather;

import arc.Core;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.WeatherState;
import mindustry.type.weather.ParticleWeather;

public class SpawnerWeather
extends ParticleWeather {
    public int maxSpawn = 6;
    public boolean inBounceCam = true;

    public SpawnerWeather(String name) {
        super(name);
    }

    public void update(WeatherState state) {
        super.update(state);
        if (this.inBounceCam) {
            this.spawnByBounceCam(state);
        } else {
            this.spawn(state);
        }
    }

    public void spawnByBounceCam(WeatherState state) {
        Tmp.r1.setCentered(Core.camera.position.x, Core.camera.position.y, (float)Core.graphics.getWidth() / Vars.renderer.minScale(), (float)Core.graphics.getHeight() / Vars.renderer.minScale());
        Tmp.r1.grow(this.sizeMax * 1.5f);
        Core.camera.bounds(Tmp.r2);
        rand.setSeed((long)Time.time);
        float speed = this.force * state.intensity * Time.delta;
        float windx = state.windVector.x * speed;
        float windy = state.windVector.y * speed;
        int total = (int)Mathf.clamp((float)(Tmp.r1.area() / this.density * state.intensity), (float)0.0f, (float)this.maxSpawn);
        for (int i = 0; i < total; ++i) {
            float scl = rand.random(0.5f, 1.0f);
            float scl2 = rand.random(0.5f, 1.0f);
            float size = rand.random(this.sizeMin, this.sizeMax);
            float x = rand.random(0.0f, (float)Vars.world.unitWidth()) + Time.time * windx * scl2;
            float y = rand.random(0.0f, (float)Vars.world.unitHeight()) + Time.time * windy * scl;
            x += Mathf.sin((float)y, (float)rand.random(this.sinSclMin, this.sinSclMax), (float)rand.random(this.sinMagMin, this.sinMagMax));
            x -= Tmp.r1.x;
            y -= Tmp.r1.y;
            x = Mathf.mod((float)x, (float)Tmp.r1.width);
            y = Mathf.mod((float)y, (float)Tmp.r1.height);
            if (!Tmp.r3.setCentered(x += Tmp.r1.x, y += Tmp.r1.y, size).overlaps(Tmp.r2) || !this.canSpawn(state)) continue;
            float x1 = Mathf.random((int)1, (int)(Vars.world.tiles.width - 1)) * 8;
            float y1 = Mathf.random((int)1, (int)(Vars.world.tiles.height - 1)) * 8;
            this.spawnAt(state, x1, y1);
        }
    }

    public void spawn(WeatherState state) {
        Tmp.r2.set(0.0f, 0.0f, (float)Vars.world.unitWidth(), (float)Vars.world.unitHeight());
        rand.setSeed((long)Time.time);
        int total = (int)Mathf.clamp((float)(Tmp.r2.area() / this.density * state.intensity), (float)0.0f, (float)this.maxSpawn);
        for (int i = 0; i < total; ++i) {
            if (!this.canSpawn(state)) continue;
            float x1 = Mathf.random((int)1, (int)(Vars.world.tiles.width - 1)) * 8;
            float y1 = Mathf.random((int)1, (int)(Vars.world.tiles.height - 1)) * 8;
            this.spawnAt(state, x1, y1);
        }
    }

    public void spawnAt(WeatherState state, float x, float y) {
    }

    public boolean canSpawn(WeatherState state) {
        return true;
    }
}

