/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type.weather;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import java.util.Arrays;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.WeatherState;
import mindustry.type.Liquid;
import omaloon.content.OlLiquids;
import omaloon.type.weather.SpawnerWeather;

public class HailStormWeather
extends SpawnerWeather {
    public float yspeed = 5.0f;
    public float xspeed = 1.5f;
    public float density = 900.0f;
    public float stroke = 0.75f;
    public float sizeMin = 8.0f;
    public float sizeMax = 40.0f;
    public float splashTimeScale = 22.0f;
    public Liquid liquid = OlLiquids.glacium;
    public TextureRegion[] splashes = new TextureRegion[12];
    public Color color = Color.valueOf((String)"5e929d");
    public boolean drawRain = true;
    public BulletStack[] bullets;
    public float bulletChange = 0.2f;
    public Team bulletTeam = Team.derelict;

    public HailStormWeather(String name) {
        super(name);
    }

    public void load() {
        super.load();
        for (int i = 0; i < this.splashes.length; ++i) {
            this.splashes[i] = Core.atlas.find("splash-" + i);
        }
    }

    @Override
    public void spawnAt(WeatherState state, float x, float y) {
        BulletType b = this.getBullet();
        if (!Vars.net.client()) {
            b.createNet(this.bulletTeam, x, y, this.useWindVector ? state.windVector.angle() : 0.0f, b.damage, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean canSpawn(WeatherState state) {
        return Mathf.randomBoolean((float)(this.bulletChange * state.intensity));
    }

    public BulletType getBullet() {
        for (int i = 0; i < this.bullets.length; ++i) {
            BulletStack item = this.bullets[i];
            if (!(Mathf.random() < item.change)) continue;
            return item.bullet;
        }
        return this.bullets[this.bullets.length - 1].bullet;
    }

    public void setBullets(Object ... items) {
        BulletStack[] stack = new BulletStack[items.length / 2];
        for (int i = 0; i < items.length; i += 2) {
            stack[i / 2] = new BulletStack((BulletType)items[i], ((Float)items[i + 1]).floatValue());
        }
        Arrays.sort(stack, new Comparator<BulletStack>(){

            @Override
            public int compare(BulletStack o1, BulletStack o2) {
                if (o1.change == o2.change) {
                    return 0;
                }
                return o1.change > o2.change ? 1 : -1;
            }
        });
        this.bullets = stack;
    }

    public void drawOver(WeatherState state) {
        super.drawOver(state);
        if (this.drawRain) {
            HailStormWeather.drawRain((float)this.sizeMin, (float)this.sizeMax, (float)this.xspeed, (float)this.yspeed, (float)this.density, (float)state.intensity, (float)this.stroke, (Color)this.color);
        }
    }

    public void drawUnder(WeatherState state) {
        if (this.drawRain) {
            HailStormWeather.drawSplashes((TextureRegion[])this.splashes, (float)this.sizeMax, (float)this.density, (float)state.intensity, (float)state.opacity, (float)this.splashTimeScale, (float)this.stroke, (Color)this.color, (Liquid)this.liquid);
        }
    }

    public static class BulletStack {
        public BulletType bullet;
        public float change;

        public BulletStack(BulletType bullet, float change) {
            this.bullet = bullet;
            this.change = change;
        }
    }
}

