/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.Seq;
import mindustry.gen.Unit;
import mindustry.graphics.MultiPacker;
import omaloon.gen.Ornitopterc;
import omaloon.type.Blade;
import omaloon.type.GlassmoreUnitType;
import omaloon.world.draw.Outliner;

public class OrnitopterUnitType
extends GlassmoreUnitType {
    public final Seq<Blade> blades = new Seq();
    public float bladeDeathMoveSlowdown = 0.01f;
    public float fallDriftScl = 60.0f;
    public float fallSmokeX = 0.0f;
    public float fallSmokeY = 0.0f;
    public float fallSmokeChance = 0.1f;

    public OrnitopterUnitType(String name) {
        super(name);
        this.engineSize = 0.0f;
        this.outlineColor = Color.valueOf((String)"454552");
        this.envDisabled = 2;
    }

    public void drawBlade(Unit unit) {
        float z = unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : this.groundLayer + Mathf.clamp((float)(this.hitSize / 4000.0f), (float)0.0f, (float)0.01f);
        this.applyColor(unit);
        if (unit instanceof Ornitopterc) {
            Ornitopterc copter = (Ornitopterc)unit;
            for (int sign : Mathf.signs) {
                long seedOffset = 0L;
                for (Blade.BladeMount mount : copter.blades()) {
                    Blade blade = mount.blade;
                    float rx = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)(blade.x * (float)sign), (float)blade.y);
                    float ry = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)(blade.x * (float)sign), (float)blade.y);
                    float bladeScl = Draw.scl * blade.bladeSizeScl;
                    float shadeScl = Draw.scl * blade.shadeSizeScl;
                    if (blade.bladeRegion.found()) {
                        Draw.z((float)(z + blade.layerOffset));
                        Draw.alpha((float)(blade.blurRegion.found() ? 1.0f - copter.bladeMoveSpeedScl() / 0.8f : 1.0f));
                        Draw.rect((TextureRegion)blade.bladeOutlineRegion, (float)rx, (float)ry, (float)((float)blade.bladeOutlineRegion.width * bladeScl * (float)sign), (float)((float)blade.bladeOutlineRegion.height * bladeScl), (float)(unit.rotation - 90.0f + (float)sign * Mathf.randomSeed((long)(copter.drawSeed() + seedOffset++), (float)blade.bladeMaxMoveAngle, (float)(-blade.bladeMinMoveAngle))));
                        Draw.mixcol((Color)Color.white, (float)unit.hitTime);
                        Draw.rect((TextureRegion)blade.bladeRegion, (float)rx, (float)ry, (float)((float)blade.bladeRegion.width * bladeScl * (float)sign), (float)((float)blade.bladeRegion.height * bladeScl), (float)(unit.rotation - 90.0f + (float)sign * Mathf.randomSeed((long)(copter.drawSeed() + seedOffset++), (float)blade.bladeMaxMoveAngle, (float)(-blade.bladeMinMoveAngle))));
                        Draw.reset();
                    }
                    if (blade.blurRegion.found()) {
                        Draw.z((float)(z + blade.layerOffset));
                        Draw.alpha((float)(copter.bladeMoveSpeedScl() * blade.blurAlpha * (copter.dead() ? copter.bladeMoveSpeedScl() * 0.5f : 1.0f)));
                        Draw.rect((TextureRegion)blade.blurRegion, (float)rx, (float)ry, (float)((float)blade.blurRegion.width * bladeScl * (float)sign), (float)((float)blade.blurRegion.height * bladeScl), (float)(unit.rotation - 90.0f + (float)sign * Mathf.randomSeed((long)(copter.drawSeed() + seedOffset++), (float)blade.bladeMaxMoveAngle, (float)(-blade.bladeMinMoveAngle))));
                        Draw.reset();
                    }
                    if (!blade.shadeRegion.found()) continue;
                    Draw.z((float)(z + blade.layerOffset + 0.001f));
                    Draw.alpha((float)(copter.bladeMoveSpeedScl() * blade.blurAlpha * (copter.dead() ? copter.bladeMoveSpeedScl() * 0.5f : 1.0f)));
                    Draw.rect((TextureRegion)blade.shadeRegion, (float)rx, (float)ry, (float)((float)blade.shadeRegion.width * shadeScl * (float)sign), (float)((float)blade.shadeRegion.height * shadeScl), (float)(unit.rotation - 90.0f + (float)sign * Mathf.randomSeed((long)(copter.drawSeed() + seedOffset++), (float)blade.bladeMaxMoveAngle, (float)(-blade.bladeMinMoveAngle))));
                    Draw.mixcol((Color)Color.white, (float)unit.hitTime);
                    Draw.reset();
                }
            }
        }
    }

    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        for (Blade blade : this.blades) {
            Outliner.outlineRegion(packer, blade.bladeRegion, this.outlineColor, blade.spriteName + "-outline", this.outlineRadius);
            Outliner.outlineRegion(packer, blade.shadeRegion, this.outlineColor, blade.spriteName + "-top-outline", this.outlineRadius);
        }
    }

    @Override
    public void draw(Unit unit) {
        super.draw(unit);
        this.drawBlade(unit);
    }

    public void load() {
        super.load();
        this.blades.each(Blade::load);
    }
}

