/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.Weapon;
import omaloon.entities.units.MillipedeDefaultUnit;
import omaloon.entities.units.MillipedeSegmentUnit;
import omaloon.gen.Millipedec;
import omaloon.type.GlassmoreUnitType;
import omaloon.type.MillipedeDecal;

public class MillipedeUnitType
extends GlassmoreUnitType {
    public final Seq<Weapon> segWeapSeq = new Seq();
    public TextureRegion segmentRegion;
    public TextureRegion tailRegion;
    public TextureRegion segmentCellRegion;
    public TextureRegion tailCellRegion;
    public TextureRegion segmentOutline;
    public TextureRegion tailOutline;
    public TextureRegion payloadCellRegion;
    public Seq<Weapon> bottomWeapons = new Seq();
    public MillipedeDecal millipedeDecal;
    public int segmentLength = 9;
    public int maxSegments = -1;
    public int segmentCast = 4;
    public float segmentOffset = 23.0f;
    public float headOffset = 0.0f;
    public float angleLimit = 30.0f;
    public float regenTime = -1.0f;
    public float healthDistribution = 0.1f;
    public float segmentDamageScl = 6.0f;
    public float anglePhysicsSmooth = 0.0f;
    public float jointStrength = 1.0f;
    public boolean counterDrag = false;
    public boolean preventDrifting = false;
    public boolean splittable = false;
    public boolean chainable = false;
    public Sound splitSound = Sounds.door;
    public Sound chainSound = Sounds.door;
    private static final Rect viewport = new Rect();
    private static final Rect viewport2 = new Rect();
    private static final int chunks = 4;
    public float segmentLayerOffset = 0.0f;
    protected boolean immuneAll = false;
    public int headLegCount = 2;
    public int segmentLegCount = 2;
    public int tailLegCount = 2;
    protected static Vec2 legOffsetB = new Vec2();
    public Seq<Weapon>[] segmentWeapons;
    public boolean tailHasWeapon = false;
    public boolean headHasWeapon = false;

    public MillipedeUnitType(String name) {
        super(name);
    }

    public Unit create(Team team) {
        return super.create(team);
    }

    public void load() {
        super.load();
        if (this.millipedeDecal != null) {
            this.millipedeDecal.load();
        }
        this.segmentRegion = Core.atlas.find(this.name + "-segment");
        this.tailRegion = Core.atlas.find(this.name + "-tail");
        this.segmentCellRegion = Core.atlas.find(this.name + "-segment-cell", this.cellRegion);
        this.tailCellRegion = Core.atlas.find(this.name + "-tail-cell", this.cellRegion);
        this.segmentOutline = Core.atlas.find(this.name + "-segment-outline");
        this.tailOutline = Core.atlas.find(this.name + "-tail-outline");
        for (Seq<Weapon> segmentWeapon : this.segmentWeapons) {
            segmentWeapon.each(Weapon::load);
        }
    }

    public void init() {
        super.init();
        if (this.segmentWeapons == null) {
            this.sortSegWeapons(this.segWeapSeq);
            this.segmentWeapons = new Seq[]{this.segWeapSeq};
        } else {
            for (Seq<Weapon> seq : this.segmentWeapons) {
                this.sortSegWeapons(seq);
            }
        }
        Seq addBottoms = new Seq();
        for (Weapon w : this.weapons) {
            if (!this.bottomWeapons.contains((Object)w) || w.otherSide == -1) continue;
            addBottoms.add((Object)((Weapon)this.weapons.get(w.otherSide)));
        }
        this.bottomWeapons.addAll(addBottoms.distinct());
        if (this.immuneAll) {
            this.immunities.addAll(Vars.content.getBy(ContentType.status));
        }
    }

    public void sortSegWeapons(Seq<Weapon> weaponSeq) {
        Seq mapped = new Seq();
        int len = weaponSeq.size;
        for (int i = 0; i < len; ++i) {
            Weapon w = (Weapon)weaponSeq.get(i);
            if (w.recoilTime < 0.0f) {
                w.recoilTime = w.reload;
            }
            mapped.add((Object)w);
            if (!w.mirror) continue;
            Weapon copy = w.copy();
            copy.x *= -1.0f;
            copy.shootX *= -1.0f;
            copy.flipSprite = !copy.flipSprite;
            mapped.add((Object)copy);
            w.reload *= 2.0f;
            copy.reload *= 2.0f;
            w.recoilTime *= 2.0f;
            copy.recoilTime *= 2.0f;
            w.otherSide = mapped.size - 1;
            copy.otherSide = mapped.size - 2;
        }
        weaponSeq.set(mapped);
    }

    public <T extends Unit> void drawWorm(T unit) {
        Mechc mech;
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)unit : null;
        float z = (unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : this.groundLayer + Mathf.clamp((float)(this.hitSize / 4000.0f), (float)0.0f, (float)0.01f)) - ((Millipedec)unit).layer() * 1.0E-5f;
        if (unit.isFlying() || this.shadowElevation > 0.0f) {
            TextureRegion tmpShadow = this.shadowRegion;
            if (!((Millipedec)unit).isHead() || ((Millipedec)unit).isTail()) {
                this.shadowRegion = ((Millipedec)unit).isTail() ? this.tailRegion : this.segmentRegion;
            }
            Draw.z((float)Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
            this.shadowRegion = tmpShadow;
        }
        Draw.z((float)(z - 0.02f));
        if (mech != null) {
            this.drawMech(mech);
            legOffsetB.trns(mech.baseRotation(), 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.63661975f, (float)1.0f) * this.mechSideSway), (float)0.0f, (float)unit.elevation));
            legOffsetB.add(Tmp.v1.trns(mech.baseRotation() + 90.0f, 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.31830987f, (float)1.0f) * this.mechFrontSway), (float)0.0f, (float)unit.elevation)));
            unit.trns(MillipedeUnitType.legOffsetB.x, MillipedeUnitType.legOffsetB.y);
        }
        this.drawLegs((Unit)((Legsc)unit));
        Draw.z((float)Math.min(z - 0.01f, 59.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Payloadc)unit));
        }
        this.drawSoftShadow(unit);
        Draw.z((float)(z - 0.02f));
        TextureRegion tmp = this.region;
        TextureRegion tmpCell = this.cellRegion;
        TextureRegion tmpOutline = this.outlineRegion;
        if (!((Millipedec)unit).isHead()) {
            this.region = ((Millipedec)unit).isTail() ? this.tailRegion : this.segmentRegion;
            this.cellRegion = ((Millipedec)unit).isTail() ? this.tailCellRegion : this.segmentCellRegion;
            this.outlineRegion = ((Millipedec)unit).isTail() ? this.tailOutline : this.segmentOutline;
        }
        this.drawOutline(unit);
        this.drawWeaponOutlines(unit);
        if (((Millipedec)unit).isTail()) {
            Draw.draw((float)(z + 0.01f), () -> {
                Tmp.v1.trns(unit.rotation + 180.0f, this.segmentOffset).add((Position)unit);
                Drawf.construct((float)Tmp.v1.x, (float)Tmp.v1.y, (TextureRegion)this.tailRegion, (float)(unit.rotation - 90.0f), (float)(((Millipedec)unit).regenTime() / this.regenTime), (float)(((Millipedec)unit).regenTime() / this.regenTime), (float)Time.time);
                Drawf.construct((float)unit.x, (float)unit.y, (TextureRegion)this.segmentRegion, (float)(unit.rotation - 90.0f), (float)(((Millipedec)unit).regenTime() / this.regenTime), (float)(((Millipedec)unit).regenTime() / this.regenTime), (float)Time.time);
            });
        }
        Draw.z((float)(z - 0.02f));
        this.drawBody(unit);
        if (this.drawCell) {
            this.drawCell(unit);
        }
        if (this.millipedeDecal != null) {
            this.millipedeDecal.draw(unit, ((Millipedec)unit).parent());
        }
        this.cellRegion = tmpCell;
        this.region = tmp;
        this.outlineRegion = tmpOutline;
        this.drawWeapons(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (mech != null) {
            unit.trns(-MillipedeUnitType.legOffsetB.x, -MillipedeUnitType.legOffsetB.y);
        }
        if (unit.abilities.length > 0) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
            Draw.reset();
        }
    }

    @Override
    public void draw(Unit unit) {
        Millipedec m;
        if (unit instanceof Millipedec && !(m = (Millipedec)unit).isHead()) {
            this.drawWorm((Unit)m);
        } else {
            super.draw(unit);
        }
    }

    public void drawOutline(Unit unit) {
        super.drawOutline(unit);
    }

    public void drawBody(Unit unit) {
        float z = Draw.z();
        if (unit instanceof MillipedeDefaultUnit) {
            MillipedeDefaultUnit millipedeUnit = (MillipedeDefaultUnit)unit;
            Core.camera.bounds(viewport);
            int index = -4;
            for (int i = 0; i < millipedeUnit.segmentUnits.length; ++i) {
                if (i >= index + 4) {
                    index = i;
                    MillipedeSegmentUnit seg = millipedeUnit.segmentUnits[index];
                    MillipedeSegmentUnit segN = millipedeUnit.segmentUnits[Math.min(index + 4, millipedeUnit.segmentUnits.length - 1)];
                    float grow = millipedeUnit.regenAvailable() && index + 4 >= millipedeUnit.segmentUnits.length - 1 ? seg.clipSize() : 0.0f;
                    Tmp.r3.setCentered(((Unit)segN).x, ((Unit)segN).y, segN.clipSize());
                    viewport2.setCentered(((Unit)seg).x, ((Unit)seg).y, seg.clipSize()).merge(Tmp.r3).grow(grow + seg.clipSize() / 2.0f);
                }
                if (!viewport.overlaps(viewport2)) continue;
                Draw.z((float)(z - ((float)i + 1.0f) / 10000.0f));
                if (millipedeUnit.regenAvailable() && i == millipedeUnit.segmentUnits.length - 1) {
                    int finalI = i;
                    Draw.draw((float)(z - ((float)i + 2.0f) / 10000.0f), () -> {
                        Tmp.v1.trns(millipedeUnit.segmentUnits[finalI].rotation + 180.0f, this.segmentOffset).add((Position)millipedeUnit.segmentUnits[finalI]);
                        Drawf.construct((float)Tmp.v1.x, (float)Tmp.v1.y, (TextureRegion)this.tailRegion, (float)(millipedeUnit.segmentUnits[finalI].rotation - 90.0f), (float)(millipedeUnit.repairTime / this.regenTime), (float)1.0f, (float)millipedeUnit.repairTime);
                    });
                }
                millipedeUnit.segmentUnits[i].drawBody();
                this.drawWeapons((Unit)millipedeUnit.segmentUnits[i]);
            }
        } else {
            this.applyColor(unit);
            Draw.rect((TextureRegion)this.region, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
            Draw.reset();
        }
        Draw.z((float)z);
    }

    public void drawWeapons(Unit unit) {
        float z = Draw.z();
        this.applyColor(unit);
        for (WeaponMount mount : unit.mounts) {
            Weapon weapon = mount.weapon;
            if (this.bottomWeapons.contains((Object)weapon)) {
                Draw.z((float)(z - 1.0E-4f));
            }
            weapon.draw(unit, mount);
            Draw.z((float)z);
        }
        Draw.reset();
    }

    public boolean hasWeapons() {
        for (Seq<Weapon> segmentWeapon : this.segmentWeapons) {
            if (segmentWeapon.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

