/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import mindustry.gen.Unit;

public class MillipedeDecal {
    private static final Vec2 v1 = new Vec2();
    public float baseX;
    public float baseY;
    public float endX;
    public float endY;
    public float baseOffset;
    public int segments = 1;
    public Color lineColor = Color.white;
    public float lineWidth = 2.0f;
    String name;
    public TextureRegion baseRegion;
    public TextureRegion endRegion;
    public TextureRegion[] segmentRegions;

    public MillipedeDecal(String name) {
        this.name = name;
    }

    public void load() {
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.endRegion = Core.atlas.find(this.name + "-end");
        this.segmentRegions = new TextureRegion[this.segments];
        for (int i = 0; i < this.segmentRegions.length; ++i) {
            this.segmentRegions[i] = Core.atlas.find(this.name + "-" + i);
        }
    }

    public void draw(Unit base, Unit other) {
        if (other == null) {
            return;
        }
        for (int s : Mathf.signs) {
            v1.trns(base.rotation - 90.0f, this.baseX * (float)s, this.baseY).add((Position)base);
            float bx = MillipedeDecal.v1.x;
            float by = MillipedeDecal.v1.y;
            v1.trns(other.rotation - 90.0f, this.endX * (float)s, this.endY).add((Position)other);
            float ex = MillipedeDecal.v1.x;
            float ey = MillipedeDecal.v1.y;
            float angle = Angles.angle((float)bx, (float)by, (float)ex, (float)ey);
            Draw.mixcol();
            Draw.color((Color)this.lineColor);
            Fill.circle((float)bx, (float)by, (float)(this.lineWidth / 2.0f));
            Fill.circle((float)ex, (float)ey, (float)(this.lineWidth / 2.0f));
            Lines.stroke((float)this.lineWidth);
            Lines.line((float)bx, (float)by, (float)ex, (float)ey, (boolean)false);
            base.type.applyColor(base);
            v1.trns(angle + 180.0f, (float)this.endRegion.width * Draw.scl * 0.5f - this.baseOffset).add(ex, ey);
            ex = MillipedeDecal.v1.x;
            ey = MillipedeDecal.v1.y;
            v1.trns(angle, (float)this.baseRegion.width * Draw.scl * 0.5f - this.baseOffset).add(bx, by);
            bx = MillipedeDecal.v1.x;
            by = MillipedeDecal.v1.y;
            for (int i = this.segmentRegions.length - 1; i >= 0; --i) {
                TextureRegion r = this.segmentRegions[i];
                float p = ((float)i + 1.0f) / ((float)this.segments + 1.0f);
                v1.set(bx, by).lerp(ex, ey, p);
                Draw.rect((TextureRegion)r, (float)MillipedeDecal.v1.x, (float)MillipedeDecal.v1.y, (float)angle);
            }
            Draw.rect((TextureRegion)this.endRegion, (float)ex, (float)ey, (float)(angle + 180.0f));
            Draw.rect((TextureRegion)this.baseRegion, (float)bx, (float)by, (float)angle);
        }
        Draw.reset();
    }
}

