/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.abilities.Ability;
import mindustry.entities.effect.WrapEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Crawlc;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Tankc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.world.blocks.environment.Floor;
import omaloon.content.OlItems;
import omaloon.entities.abilities.HailShieldAbility;
import omaloon.gen.FloatMechc;

public class GlassmoreUnitType
extends UnitType {
    private static final Vec2 legOffset = new Vec2();

    public GlassmoreUnitType(String name) {
        super(name);
        this.outlineColor = Color.valueOf((String)"2f2f36");
        this.envDisabled = 2;
        this.ammoType = new ItemAmmoType(OlItems.cobalt);
        this.researchCostMultiplier = 8.0f;
        this.abilities.add((Object)new HailShieldAbility(){
            {
                this.regen = 0.01f;
                this.regenBroken = 0.05f;
                this.layerOffset = 1.0f;
                this.breakEffect = new WrapEffect(Fx.unitShieldBreak, Pal.heal, 1.0f);
            }
        });
    }

    public void draw(Unit unit) {
        float z;
        Mechc mech;
        if (unit.inFogTo(Vars.player.team())) {
            return;
        }
        boolean isPayload = !unit.isAdded();
        FloatMechc floatMech = unit instanceof FloatMechc ? (FloatMechc)unit : null;
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)unit : null;
        float f = isPayload ? Draw.z() : (unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : (z = this.groundLayer + Mathf.clamp((float)(this.hitSize / 4000.0f), (float)0.0f, (float)0.01f)));
        if (unit.controller().isBeingControlled(Vars.player.unit())) {
            this.drawControl(unit);
        }
        if (!isPayload && (unit.isFlying() || this.shadowElevation > 0.0f)) {
            Draw.z((float)Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
        }
        Draw.z((float)(z - 0.02f));
        if (floatMech != null) {
            this.drawMech(floatMech);
            legOffset.trns(floatMech.baseRotation(), 0.0f, Mathf.lerp((float)(Mathf.sin((float)floatMech.walkExtend(true), (float)0.63661975f, (float)1.0f) * this.mechSideSway), (float)0.0f, (float)unit.elevation));
            legOffset.add(Tmp.v1.trns(floatMech.baseRotation() + 90.0f, 0.0f, Mathf.lerp((float)(Mathf.sin((float)floatMech.walkExtend(true), (float)0.31830987f, (float)1.0f) * this.mechFrontSway), (float)0.0f, (float)unit.elevation)));
            unit.trns(GlassmoreUnitType.legOffset.x, GlassmoreUnitType.legOffset.y);
        }
        if (mech != null) {
            this.drawMech(mech);
            legOffset.trns(mech.baseRotation(), 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.63661975f, (float)1.0f) * this.mechSideSway), (float)0.0f, (float)unit.elevation));
            legOffset.add(Tmp.v1.trns(mech.baseRotation() + 90.0f, 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.31830987f, (float)1.0f) * this.mechFrontSway), (float)0.0f, (float)unit.elevation)));
            unit.trns(GlassmoreUnitType.legOffset.x, GlassmoreUnitType.legOffset.y);
        }
        if (unit instanceof Tankc) {
            this.drawTank((Unit)((Tankc)unit));
        }
        if (unit instanceof Legsc && !isPayload) {
            this.drawLegs((Unit)((Legsc)unit));
        }
        Draw.z((float)Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Payloadc)unit));
        }
        this.drawSoftShadow(unit);
        Draw.z((float)z);
        if (unit instanceof Crawlc) {
            Crawlc c = (Crawlc)unit;
            this.drawCrawl(c);
        }
        if (this.drawBody) {
            this.drawOutline(unit);
        }
        this.drawWeaponOutlines(unit);
        if (this.engineLayer > 0.0f) {
            Draw.z((float)this.engineLayer);
        }
        if (!(this.trailLength <= 0 || this.naval || !unit.isFlying() && this.useEngineElevation)) {
            this.drawTrail(unit);
        }
        if (this.engines.size > 0) {
            this.drawEngines(unit);
        }
        Draw.z((float)z);
        if (this.drawBody) {
            this.drawBody(unit);
        }
        if (this.drawCell) {
            this.drawCell(unit);
        }
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        this.drawLight(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                WeaponMount first;
                DrawPart part = (DrawPart)this.parts.get(i);
                WeaponMount weaponMount = first = unit.mounts.length > part.weaponIndex ? unit.mounts[part.weaponIndex] : null;
                if (first != null) {
                    DrawPart.params.set(first.warmup, first.reload / ((Weapon)this.weapons.first()).reload, first.smoothReload, first.heat, first.recoil, first.charge, unit.x, unit.y, unit.rotation);
                } else {
                    DrawPart.params.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, unit.x, unit.y, unit.rotation);
                }
                if (unit instanceof Scaled) {
                    Scaled s = (Scaled)unit;
                    DrawPart.params.life = s.fin();
                }
                part.draw(DrawPart.params);
            }
        }
        if (!isPayload) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
        }
        if (floatMech != null) {
            unit.trns(-GlassmoreUnitType.legOffset.x, -GlassmoreUnitType.legOffset.y);
        }
        if (mech != null) {
            unit.trns(-GlassmoreUnitType.legOffset.x, -GlassmoreUnitType.legOffset.y);
        }
        Draw.reset();
    }

    public void drawMech(FloatMechc floatMech) {
        Floor floor;
        Unit unit = (Unit)floatMech;
        Draw.reset();
        float e = unit.elevation;
        float sin = Mathf.lerp((float)Mathf.sin((float)floatMech.walkExtend(true), (float)0.63661975f, (float)1.0f), (float)0.0f, (float)e);
        float extension = Mathf.lerp((float)floatMech.walkExtend(false), (float)0.0f, (float)e);
        float boostTrns = e * 2.0f;
        Floor floor2 = floor = unit.isFlying() ? Blocks.air.asFloor() : unit.floorOn();
        if (floor.isLiquid) {
            Draw.color((Color)Color.white, (Color)floor.mapColor, (float)0.5f);
        }
        for (int i : Mathf.signs) {
            Draw.mixcol((Color)Tmp.c1.set(this.mechLegColor).lerp(Color.white, Mathf.clamp((float)unit.hitTime)), (float)Math.max(Math.max(0.0f, (float)i * extension / this.mechStride), unit.hitTime));
            Draw.rect((TextureRegion)this.legRegion, (float)(unit.x + Angles.trnsx((float)floatMech.baseRotation(), (float)(extension * (float)i - boostTrns), (float)(-boostTrns * (float)i))), (float)(unit.y + Angles.trnsy((float)floatMech.baseRotation(), (float)(extension * (float)i - boostTrns), (float)(-boostTrns * (float)i))), (float)((float)this.legRegion.width * this.legRegion.scl() * (float)i), (float)((float)this.legRegion.height * this.legRegion.scl() * (1.0f - Math.max(-sin * (float)i, 0.0f) * 0.5f)), (float)(floatMech.baseRotation() - 90.0f + 35.0f * (float)i * e));
        }
        Draw.mixcol((Color)Color.white, (float)unit.hitTime);
        if (unit.lastDrownFloor != null) {
            Draw.color((Color)Color.white, (Color)Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.83f), (float)(unit.drownTime * 0.9f));
        } else {
            Draw.color((Color)Color.white);
        }
        Draw.rect((TextureRegion)this.baseRegion, (Position)unit, (float)(floatMech.baseRotation() - 90.0f));
        Draw.mixcol();
    }
}

