/*
 * Decompiled with CFR 0.152.
 */
package omaloon.maps;

import arc.graphics.Color;
import arc.math.geom.Vec3;
import arc.util.Nullable;
import arc.util.noise.Simplex;

public abstract class ColorPass {
    @Nullable
    public abstract Color color(Vec3 var1, float var2);

    public static class FlatColorPass
    extends ColorPass {
        public float min = 0.0f;
        public float max = 1.0f;
        public Color out = Color.white;

        @Override
        public Color color(Vec3 pos, float height) {
            if (this.min <= height && height <= this.max) {
                return this.out;
            }
            return null;
        }
    }

    public static class NoiseColorPass
    extends ColorPass {
        public Vec3 offset = new Vec3();
        public int seed;
        public double octaves = 1.0;
        public double persistence = 1.0;
        public double scale = 1.0;
        public float magnitude = 1.0f;
        public float min = 0.0f;
        public float max = 1.0f;
        public Color out = Color.white;

        @Override
        public Color color(Vec3 pos, float height) {
            float noise = Simplex.noise3d((int)this.seed, (double)this.octaves, (double)this.persistence, (double)this.scale, (double)(pos.x + this.offset.x), (double)(pos.y + this.offset.y), (double)(pos.z + this.offset.z)) * this.magnitude;
            if (this.min <= noise && noise <= this.max) {
                return this.out;
            }
            return null;
        }
    }

    public static class SphereColorPass
    extends ColorPass {
        public Vec3 pos;
        public float radius;
        public Color out;

        public SphereColorPass(Vec3 pos, float radius, Color out) {
            this.pos = pos;
            this.radius = radius;
            this.out = out;
        }

        @Override
        public Color color(Vec3 pos, float height) {
            if (pos.dst(this.pos) < this.radius) {
                return this.out;
            }
            return null;
        }
    }
}

