/*
 * Decompiled with CFR 0.152.
 */
package omaloon.graphics.shaders;

import arc.Core;
import arc.graphics.Texture;
import arc.graphics.g3d.Camera3D;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.util.Tmp;
import omaloon.graphics.OlShaders;
import omaloon.type.BetterPlanet;

public class DepthAtmosphereShader
extends Shader {
    private static final Mat3D mat = new Mat3D();
    public Camera3D camera;
    public BetterPlanet planet;

    public DepthAtmosphereShader() {
        super(OlShaders.file("depth-atmosphere.vert"), OlShaders.file("depth-atmosphere.frag"));
    }

    public void apply() {
        this.setUniformMatrix4("u_proj", this.camera.combined.val);
        this.setUniformMatrix4("u_trans", this.planet.getTransform((Mat3D)DepthAtmosphereShader.mat).val);
        this.setUniformf("u_camPos", this.camera.position);
        this.setUniformf("u_relCamPos", Tmp.v31.set(this.camera.position).sub(this.planet.position));
        this.setUniformf("u_camRange", this.camera.near, this.camera.far - this.camera.near);
        this.setUniformf("u_center", this.planet.position);
        this.setUniformf("u_light", this.planet.getLightNormal());
        this.setUniformf("u_color", this.planet.atmosphereColor.r, this.planet.atmosphereColor.g, this.planet.atmosphereColor.b);
        this.setUniformf("u_innerRadius", this.planet.radius + this.planet.atmosphereRadIn);
        this.setUniformf("u_outerRadius", this.planet.radius + this.planet.atmosphereRadOut);
        ((Texture)this.planet.depthBuffer.getTexture()).bind(0);
        this.setUniformi("u_topology", 0);
        this.setUniformf("u_viewport", Core.graphics.getWidth(), Core.graphics.getHeight());
    }
}

