/*
 * Decompiled with CFR 0.152.
 */
package omaloon.gen;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Boundedc;
import mindustry.gen.Builderc;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Flyingc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Itemsc;
import mindustry.gen.Minerc;
import mindustry.gen.Payloadc;
import mindustry.gen.Physicsc;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Shieldc;
import mindustry.gen.Sounds;
import mindustry.gen.Statusc;
import mindustry.gen.Syncc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.gen.Velc;
import mindustry.gen.Weaponsc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;
import omaloon.gen.EntityRegistry;
import omaloon.gen.Ornitopterc;
import omaloon.type.Blade;
import omaloon.type.OrnitopterUnitType;

public class OrnitopterFlyingUnit
extends Unit
implements Boundedc,
Builderc,
Drawc,
Entityc,
Flyingc,
Healthc,
Hitboxc,
Itemsc,
Minerc,
Physicsc,
Posc,
Rotc,
Shieldc,
Statusc,
Syncc,
Teamc,
Unitc,
Velc,
Weaponsc,
Ornitopterc {
    public static final float hitDuration = 9.0f;
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    public static final float warpDst = 30.0f;
    private transient boolean added;
    private transient Bits applied;
    public float bladeMoveSpeedScl;
    public Blade.BladeMount[] blades;
    private transient float buildCounter;
    private UnitController controller;
    public long drawSeed;
    private float driftAngle;
    private boolean hasDriftAngle;
    protected transient boolean isRotate;
    private transient BuildPlan lastActive;
    private transient int lastSize;
    private transient float resupplyTime;
    private transient float rotation_LAST_;
    private transient float rotation_TARGET_;
    private Seq<StatusEntry> statuses;
    private transient boolean wasFlying;
    private transient boolean wasHealed;
    private transient boolean wasPlayer;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected OrnitopterFlyingUnit() {
        this.applied = new Bits(Vars.content.getBy((ContentType)ContentType.status).size);
        this.bladeMoveSpeedScl = 1.0f;
        this.drawSeed = 0L;
        this.hasDriftAngle = false;
        this.resupplyTime = Mathf.random((float)10.0f);
        this.statuses = new Seq();
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public Color statusColor() {
        if (this.statuses.size == 0) {
            return Tmp.c1.set(Color.white);
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float total = 0.0f;
        for (StatusEntry entry : this.statuses) {
            float intensity = entry.time < 10.0f ? entry.time / 10.0f : 1.0f;
            r += entry.effect.color.r * intensity;
            g += entry.effect.color.g * intensity;
            b += entry.effect.color.b * intensity;
            total += intensity;
        }
        float count = (float)this.statuses.size + total;
        return Tmp.c1.set(r / count, g / count, b / count, 1.0f);
    }

    public TextureRegion icon() {
        return this.type.fullIcon;
    }

    public Bits statusBits() {
        return this.applied;
    }

    public boolean acceptsItem(Item item) {
        return !this.hasItem() || item == this.stack.item && this.stack.amount + 1 <= this.itemCapacity();
    }

    public boolean activelyBuilding() {
        if (this.isBuilding()) {
            BuildPlan plan = this.buildPlan();
            if (!Vars.state.isEditor() && plan != null && !this.within((Position)plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
                return false;
            }
        }
        return this.isBuilding() && this.updateBuilding;
    }

    public boolean canBuild() {
        return this.type.buildSpeed > 0.0f && this.buildSpeedMultiplier > 0.0f;
    }

    public boolean canDrown() {
        return this.isGrounded() && !this.hovering && this.type.canDrown;
    }

    public boolean canLand() {
        return !this.onSolid() && Units.count((float)this.x, (float)this.y, (float)this.physicSize(), f -> f != this && f.isGrounded()) == 0;
    }

    public boolean canMine() {
        return this.type.mineSpeed > 0.0f && this.type.mineTier >= 0;
    }

    public boolean canMine(Item item) {
        if (item == null) {
            return false;
        }
        return this.type.mineTier >= item.hardness;
    }

    public boolean canPass(int tileX, int tileY) {
        EntityCollisions.SolidPred s = this.solidity();
        return s == null || !s.solid(tileX, tileY);
    }

    public boolean canPassOn() {
        return this.canPass(this.tileX(), this.tileY());
    }

    public boolean canShoot() {
        return !this.disarmed && (!this.type.canBoost || !this.isFlying());
    }

    public boolean cheating() {
        return this.team.rules().cheat;
    }

    public boolean checkTarget(boolean targetAir, boolean targetGround) {
        return this.isGrounded() && targetGround || this.isFlying() && targetAir;
    }

    public boolean collides(Hitboxc other) {
        return this.hittable();
    }

    public boolean damaged() {
        return this.health < this.maxHealth - 0.001f;
    }

    public boolean displayable() {
        return this.type.hoverable;
    }

    public boolean emitWalkSound() {
        return true;
    }

    public boolean hasEffect(StatusEffect effect) {
        return this.applied.get((int)effect.id);
    }

    public boolean hasItem() {
        return this.stack.amount > 0;
    }

    public boolean hasWeapons() {
        return this.type.hasWeapons();
    }

    public boolean hittable() {
        return this.type.hittable((Unit)this);
    }

    public boolean inFogTo(Team viewer) {
        if (this.team == viewer || !Vars.state.rules.fog) {
            return false;
        }
        if (this.hitSize <= 16.0f) {
            return !Vars.fogControl.isVisible(viewer, this.x, this.y);
        }
        float trns = this.hitSize / 2.0f;
        for (Point2 p : Geometry.d8) {
            if (!Vars.fogControl.isVisible(viewer, this.x + (float)p.x * trns, this.y + (float)p.y * trns)) continue;
            return false;
        }
        return true;
    }

    public boolean inRange(Position other) {
        return this.within(other, this.type.range);
    }

    public boolean isAI() {
        return this.controller instanceof AIController;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isBoss() {
        return this.hasEffect(StatusEffects.boss);
    }

    public boolean isBuilding() {
        return this.plans.size != 0;
    }

    public boolean isCommandable() {
        return this.controller instanceof CommandAI;
    }

    public boolean isEnemy() {
        return this.type.isEnemy;
    }

    public boolean isFlying() {
        return this.elevation >= 0.09f;
    }

    public boolean isGrounded() {
        return this.elevation < 0.001f;
    }

    public boolean isImmune(StatusEffect effect) {
        return this.type.immunities.contains((Object)effect);
    }

    public boolean isLocal() {
        Unitc u;
        OrnitopterFlyingUnit ornitopterFlyingUnit;
        return this == Vars.player || (ornitopterFlyingUnit = this) instanceof Unitc && (u = (Unitc)ornitopterFlyingUnit).controller() == Vars.player;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isPathImpassable(int tileX, int tileY) {
        return !this.type.flying && Vars.world.tiles.in(tileX, tileY) && this.type.pathCost.getCost(this.team.id, Vars.pathfinder.get(tileX, tileY)) == -1;
    }

    public boolean isPlayer() {
        return this.controller instanceof Player;
    }

    public boolean isRemote() {
        Unitc u;
        OrnitopterFlyingUnit ornitopterFlyingUnit = this;
        return ornitopterFlyingUnit instanceof Unitc && (u = (Unitc)ornitopterFlyingUnit).isPlayer() && !this.isLocal();
    }

    public boolean isRotate() {
        return this.isRotate;
    }

    public boolean isSyncHidden(Player player) {
        return !this.isShooting() && this.inFogTo(player.team());
    }

    public boolean isValid() {
        return !this.dead && this.isAdded();
    }

    public boolean mining() {
        return this.mineTile != null && !this.activelyBuilding();
    }

    public boolean moving() {
        return !this.vel.isZero(0.01f);
    }

    public boolean offloadImmediately() {
        return this.isPlayer();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return true;
    }

    public boolean shouldSkip(BuildPlan plan, Building core) {
        if (Vars.state.rules.infiniteResources || this.team.rules().infiniteResources || plan.breaking || core == null || plan.isRotation(this.team) || this.isBuilding() && !this.within((Position)this.plans.last(), this.type.buildRange)) {
            return false;
        }
        return plan.stuck && !core.items.has(plan.block.requirements) || Structs.contains((Object[])plan.block.requirements, i -> !core.items.has(i.item, Math.min(i.amount, 15)) && Mathf.round((float)((float)i.amount * Vars.state.rules.buildCostMultiplier)) > 0) && !plan.initialized;
    }

    public boolean targetable(Team targeter) {
        return this.type.targetable((Unit)this, targeter);
    }

    public boolean validMine(Tile tile) {
        return this.validMine(tile, true);
    }

    public boolean validMine(Tile tile, boolean checkDst) {
        if (tile == null) {
            return false;
        }
        if (checkDst && !this.within(tile.worldx(), tile.worldy(), this.type.mineRange)) {
            return false;
        }
        return this.getMineResult(tile) != null;
    }

    public double sense(Content content) {
        if (content == this.stack().item) {
            return this.stack().amount;
        }
        return Double.NaN;
    }

    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case totalItems: {
                d = this.stack().amount;
                break;
            }
            case itemCapacity: {
                d = this.type.itemCapacity;
                break;
            }
            case rotation: {
                d = this.rotation;
                break;
            }
            case health: {
                d = this.health;
                break;
            }
            case shield: {
                d = this.shield;
                break;
            }
            case maxHealth: {
                d = this.maxHealth;
                break;
            }
            case ammo: {
                if (!Vars.state.rules.unitAmmo) {
                    d = this.type.ammoCapacity;
                    break;
                }
                d = this.ammo;
                break;
            }
            case ammoCapacity: {
                d = this.type.ammoCapacity;
                break;
            }
            case x: {
                d = World.conv((float)this.x);
                break;
            }
            case y: {
                d = World.conv((float)this.y);
                break;
            }
            case dead: {
                if (this.dead || !this.isAdded()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case team: {
                d = this.team.id;
                break;
            }
            case shooting: {
                if (this.isShooting()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case boosting: {
                if (this.type.canBoost && this.isFlying()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case range: {
                d = this.range() / 8.0f;
                break;
            }
            case shootX: {
                d = World.conv((float)this.aimX());
                break;
            }
            case shootY: {
                d = World.conv((float)this.aimY());
                break;
            }
            case mining: {
                if (this.mining()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case mineX: {
                if (this.mining()) {
                    d = this.mineTile.x;
                    break;
                }
                d = -1.0;
                break;
            }
            case mineY: {
                if (this.mining()) {
                    d = this.mineTile.y;
                    break;
                }
                d = -1.0;
                break;
            }
            case flag: {
                d = this.flag;
                break;
            }
            case speed: {
                d = this.type.speed * 60.0f / 8.0f;
                break;
            }
            case controlled: {
                CommandAI command;
                UnitController unitController;
                d = !this.isValid() ? 0 : (this.controller instanceof LogicAI ? 1 : (this.controller instanceof Player ? 2 : ((unitController = this.controller) instanceof CommandAI && (command = (CommandAI)unitController).hasCommand() ? 3 : 0)));
                break;
            }
            case payloadCount: {
                OrnitopterFlyingUnit ornitopterFlyingUnit = this;
                if (ornitopterFlyingUnit instanceof Payloadc) {
                    Payloadc pay = (Payloadc)ornitopterFlyingUnit;
                    d = pay.payloads().size;
                    break;
                }
                d = 0.0;
                break;
            }
            case size: {
                d = this.hitSize / 8.0f;
                break;
            }
            case color: {
                d = Color.toDoubleBits((float)this.team.color.r, (float)this.team.color.g, (float)this.team.color.b, (float)1.0f);
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    public float ammof() {
        return this.ammo / (float)this.type.ammoCapacity;
    }

    @Override
    public float bladeMoveSpeedScl() {
        return this.bladeMoveSpeedScl;
    }

    public float bounds() {
        return this.hitSize * 2.0f;
    }

    public float clipSize() {
        if (this.isBuilding()) {
            return Vars.state.rules.infiniteResources ? Float.MAX_VALUE : Math.max(this.type.clipSize, (float)this.type.region.width) + this.type.buildRange + 32.0f;
        }
        if (this.mining()) {
            return this.type.clipSize + this.type.mineRange;
        }
        return this.type.clipSize;
    }

    public float deltaAngle() {
        return Mathf.angle((float)this.deltaX, (float)this.deltaY);
    }

    public float deltaLen() {
        return Mathf.len((float)this.deltaX, (float)this.deltaY);
    }

    @Override
    public float driftAngle() {
        return this.driftAngle;
    }

    public float floorSpeedMultiplier() {
        Floor on = this.isFlying() || this.hovering ? Blocks.air.asFloor() : this.floorOn();
        return on.speedMultiplier * this.speedMultiplier;
    }

    public float getDuration(StatusEffect effect) {
        StatusEntry entry = (StatusEntry)this.statuses.find(e -> e.effect == effect);
        return entry == null ? 0.0f : entry.time;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float healthf() {
        return this.health / this.maxHealth;
    }

    public float hitSize() {
        return this.hitSize;
    }

    public float mass() {
        return this.hitSize * this.hitSize * (float)Math.PI;
    }

    public float physicSize() {
        return this.hitSize * 0.7f;
    }

    public float prefRotation() {
        if (this.activelyBuilding() && this.type.rotateToBuilding) {
            return this.angleTo((Position)this.buildPlan());
        }
        if (this.mineTile != null) {
            return this.angleTo((Position)this.mineTile);
        }
        if (this.moving() && this.type.omniMovement) {
            return this.vel().angle();
        }
        return this.rotation;
    }

    public float range() {
        return this.type.maxRange;
    }

    public float speed() {
        float strafePenalty = this.isGrounded() || !this.isPlayer() ? 1.0f : Mathf.lerp((float)1.0f, (float)this.type.strafePenalty, (float)(Angles.angleDist((float)this.vel().angle(), (float)this.rotation) / 180.0f));
        float boost = Mathf.lerp((float)1.0f, (float)(this.type.canBoost ? this.type.boostMultiplier : 1.0f), (float)this.elevation);
        return this.type.speed * strafePenalty * boost * this.floorSpeedMultiplier();
    }

    public int cap() {
        return Units.getCap((Team)this.team);
    }

    public int classId() {
        return EntityRegistry.getID(OrnitopterFlyingUnit.class);
    }

    public int count() {
        return this.team.data().countType(this.type);
    }

    public int itemCapacity() {
        return this.type.itemCapacity;
    }

    public int maxAccepted(Item item) {
        return this.stack.item != item && this.stack.amount > 0 ? 0 : this.itemCapacity() - this.stack.amount;
    }

    public int pathType() {
        return 0;
    }

    public int tileX() {
        return World.toTile((float)this.x);
    }

    public int tileY() {
        return World.toTile((float)this.y);
    }

    public Object senseObject(LAccess sensor) {
        Object object;
        switch (sensor) {
            case type: {
                object = this.type;
                break;
            }
            case name: {
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    object = p.name;
                    break;
                }
                object = null;
                break;
            }
            case firstItem: {
                if (this.stack().amount == 0) {
                    object = null;
                    break;
                }
                object = this.item();
                break;
            }
            case controller: {
                if (!this.isValid()) {
                    object = null;
                    break;
                }
                UnitController unitController = this.controller;
                if (unitController instanceof LogicAI) {
                    LogicAI log = (LogicAI)unitController;
                    object = log.controller;
                    break;
                }
                object = this;
                break;
            }
            case payloadType: {
                Object object2 = this;
                if (object2 instanceof Payloadc) {
                    Payloadc pay = (Payloadc)object2;
                    if (pay.payloads().isEmpty()) {
                        object = null;
                        break;
                    }
                    object2 = pay.payloads().peek();
                    if (object2 instanceof UnitPayload) {
                        UnitPayload p1 = (UnitPayload)object2;
                        object = p1.unit.type;
                        break;
                    }
                    object2 = pay.payloads().peek();
                    if (object2 instanceof BuildPayload) {
                        BuildPayload p2 = (BuildPayload)object2;
                        object = p2.block();
                        break;
                    }
                    object = null;
                    break;
                }
                object = null;
                break;
            }
            default: {
                object = noSensed;
            }
        }
        return object;
    }

    public String getControllerName() {
        if (this.isPlayer()) {
            return this.getPlayer().name;
        }
        UnitController unitController = this.controller;
        if (unitController instanceof LogicAI) {
            LogicAI ai = (LogicAI)unitController;
            if (ai.controller != null) {
                return ai.controller.lastAccessed;
            }
        }
        return null;
    }

    public String toString() {
        return "Unit#" + this.id() + ":" + this.type;
    }

    @Override
    public long drawSeed() {
        return this.drawSeed;
    }

    public CommandAI command() {
        UnitController unitController = this.controller;
        if (unitController instanceof CommandAI) {
            CommandAI ai = (CommandAI)unitController;
            return ai;
        }
        throw new IllegalArgumentException("Unit cannot be commanded - check isCommandable() first.");
    }

    public EntityCollisions.SolidPred solidity() {
        return null;
    }

    public BuildPlan buildPlan() {
        return this.plans.size == 0 ? null : (BuildPlan)this.plans.first();
    }

    public UnitController controller() {
        return this.controller;
    }

    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.controller : null;
    }

    public Item getMineResult(Tile tile) {
        Item result;
        if (tile == null) {
            return null;
        }
        if (this.type.mineFloor && tile.block() == Blocks.air) {
            result = tile.drop();
        } else if (this.type.mineWalls) {
            result = tile.wallDrop();
        } else {
            return null;
        }
        return this.canMine(result) ? result : null;
    }

    public Item item() {
        return this.stack.item;
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public Floor drownFloor() {
        return this.canDrown() ? this.floorOn() : null;
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Override
    public Blade.BladeMount[] blades() {
        return this.blades;
    }

    public void add() {
        if (this.added) {
            return;
        }
        Groups.unit.add((Entityc)this);
        Groups.draw.add((Entityc)this);
        Groups.sync.add((Entityc)this);
        Groups.all.add((Entityc)this);
        this.team.data().updateCount(this.type, 1);
        if (this.type.useUnitCap && this.count() > this.cap() && !this.spawnedByCore && !this.dead && !Vars.state.rules.editor) {
            Call.unitCapDeath((Unit)this);
            this.team.data().updateCount(this.type, -1);
        }
        this.updateLastPosition();
        this.added = true;
    }

    public void addBuild(BuildPlan place) {
        this.addBuild(place, true);
    }

    public void addBuild(BuildPlan place, boolean tail) {
        Building building;
        Tile tile;
        if (!this.canBuild()) {
            return;
        }
        BuildPlan replace = null;
        for (BuildPlan plan : this.plans) {
            if (plan.x != place.x || plan.y != place.y) continue;
            replace = plan;
            break;
        }
        if (replace != null) {
            this.plans.remove(replace);
        }
        if ((tile = Vars.world.tile(place.x, place.y)) != null && (building = tile.build) instanceof ConstructBlock.ConstructBuild) {
            ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)building;
            place.progress = cons.progress;
        }
        if (tail) {
            this.plans.addLast((Object)place);
        } else {
            this.plans.addFirst((Object)place);
        }
    }

    public void addItem(Item item) {
        this.addItem(item, 1);
    }

    public void addItem(Item item, int amount) {
        this.stack.amount = this.stack.item == item ? this.stack.amount + amount : amount;
        this.stack.item = item;
        this.stack.amount = Mathf.clamp((int)this.stack.amount, (int)0, (int)this.itemCapacity());
    }

    public void afterRead() {
        AIController ai;
        this.afterSync();
        UnitController unitController = this.controller;
        if (!(unitController instanceof AIController) || !(ai = (AIController)unitController).keepState()) {
            this.controller(this.type.createController((Unit)this));
        }
        this.setBlades(this.type);
        if (this.plans == null) {
            this.plans = new Queue(1);
        }
        this.updateLastPosition();
    }

    public void afterSync() {
        this.setType(this.type);
        this.controller.unit((Unit)this);
    }

    public void aim(Position pos) {
        this.aim(pos.getX(), pos.getY());
    }

    public void aim(float x, float y) {
        Tmp.v1.set(x, y).sub(this.x, this.y);
        if (Tmp.v1.len() < this.type.aimDst) {
            Tmp.v1.setLength(this.type.aimDst);
        }
        x = Tmp.v1.x + this.x;
        y = Tmp.v1.y + this.y;
        for (WeaponMount mount : this.mounts) {
            if (!mount.weapon.controllable) continue;
            mount.aimX = x;
            mount.aimY = y;
        }
        this.aimX = x;
        this.aimY = y;
    }

    public void aimLook(Position pos) {
        this.aim(pos);
        this.lookAt(pos);
    }

    public void aimLook(float x, float y) {
        this.aim(x, y);
        this.lookAt(x, y);
    }

    public void apply(StatusEffect effect) {
        this.apply(effect, 1.0f);
    }

    public void apply(StatusEffect effect, float duration) {
        if (effect == StatusEffects.none || effect == null || this.isImmune(effect)) {
            return;
        }
        if (Vars.state.isCampaign()) {
            effect.unlock();
        }
        if (this.statuses.size > 0) {
            for (int i = 0; i < this.statuses.size; ++i) {
                StatusEntry entry = (StatusEntry)this.statuses.get(i);
                if (entry.effect == effect) {
                    entry.time = Math.max(entry.time, duration);
                    effect.applied((Unit)this, entry.time, true);
                    return;
                }
                if (!entry.effect.applyTransition((Unit)this, effect, entry, duration)) continue;
                return;
            }
        }
        if (!effect.reactive) {
            StatusEntry entry = (StatusEntry)Pools.obtain(StatusEntry.class, StatusEntry::new);
            entry.set(effect, duration);
            this.statuses.add((Object)entry);
            effect.applied((Unit)this, duration, false);
        }
    }

    public void approach(Vec2 vector) {
        this.vel.approachDelta(vector, this.type.accel * this.speed());
    }

    @Override
    public void bladeMoveSpeedScl(float bladeMoveSpeedScl) {
        this.bladeMoveSpeedScl = bladeMoveSpeedScl;
    }

    @Override
    public void blades(Blade.BladeMount[] blades) {
        this.blades = blades;
    }

    public void clampHealth() {
        this.health = Math.min(this.health, this.maxHealth);
    }

    public void clearBuilding() {
        this.plans.clear();
    }

    public void clearItem() {
        this.stack.amount = 0;
    }

    public void clearStatuses() {
        this.statuses.clear();
    }

    public void collision(Hitboxc other, float x, float y) {
        if (other instanceof Bullet) {
            Bullet bullet = (Bullet)other;
            this.controller.hit(bullet);
        }
    }

    public void controlWeapons(boolean rotate, boolean shoot) {
        for (WeaponMount mount : this.mounts) {
            if (!mount.weapon.controllable) continue;
            mount.rotate = rotate;
            mount.shoot = shoot;
        }
        this.isRotate = rotate;
        this.isShooting = shoot;
    }

    public void controlWeapons(boolean rotateShoot) {
        this.controlWeapons(rotateShoot, rotateShoot);
    }

    public void controller(UnitController next) {
        this.controller = next;
        if (this.controller.unit() != this) {
            this.controller.unit((Unit)this);
        }
    }

    public void damage(float amount) {
        this.rawDamage(Damage.applyArmor((float)amount, (float)this.armor) / this.healthMultiplier / Vars.state.rules.unitHealth(this.team));
    }

    public void damage(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.damage(amount);
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    public void damageContinuous(float amount) {
        this.damage(amount * Time.delta, this.hitTime <= -1.0f);
    }

    public void damageContinuousPierce(float amount) {
        this.damagePierce(amount * Time.delta, this.hitTime <= -11.0f);
    }

    public void damagePierce(float amount) {
        this.damagePierce(amount, true);
    }

    public void damagePierce(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.rawDamage(amount / this.healthMultiplier / Vars.state.rules.unitHealth(this.team));
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    public void destroy() {
        if (!this.isAdded() || !this.type.killable) {
            return;
        }
        float explosiveness = 2.0f + this.item().explosiveness * (float)this.stack().amount * 1.53f;
        float flammability = this.item().flammability * (float)this.stack().amount / 1.9f;
        float power = this.item().charge * Mathf.pow((float)this.stack().amount, (float)1.11f) * 160.0f;
        if (!this.spawnedByCore) {
            Damage.dynamicExplosion((float)this.x, (float)this.y, (float)flammability, (float)explosiveness, (float)power, (float)((this.bounds() + this.type.legLength / 1.7f) / 2.0f), (Vars.state.rules.damageExplosions && Vars.state.rules.unitCrashDamage(this.team) > 0.0f ? 1 : 0) != 0, (this.item().flammability > 1.0f ? 1 : 0) != 0, (Team)this.team, (Effect)this.type.deathExplosionEffect);
        } else {
            this.type.deathExplosionEffect.at(this.x, this.y, this.bounds() / 2.0f / 8.0f);
        }
        float shake = this.hitSize / 3.0f;
        if (this.type.createScorch) {
            Effect.scorch((float)this.x, (float)this.y, (int)((int)(this.hitSize / 5.0f)));
        }
        Effect.shake((float)shake, (float)shake, (Position)this);
        this.type.deathSound.at((Position)this);
        Events.fire((Object)new EventType.UnitDestroyEvent((Unit)this));
        if (explosiveness > 7.0f && (this.isLocal() || this.wasPlayer)) {
            Events.fire((Enum)EventType.Trigger.suicideBomb);
        }
        for (WeaponMount weaponMount : this.mounts) {
            if (!weaponMount.weapon.shootOnDeath || weaponMount.weapon.bullet.killShooter && weaponMount.totalShots > 0) continue;
            weaponMount.reload = 0.0f;
            weaponMount.shoot = true;
            weaponMount.weapon.update((Unit)this, weaponMount);
        }
        if (this.type.flying && !this.spawnedByCore && this.type.createWreck && Vars.state.rules.unitCrashDamage(this.team) > 0.0f) {
            Damage.damage((Team)this.team, (float)this.x, (float)this.y, (float)(Mathf.pow((float)this.hitSize, (float)0.94f) * 1.25f), (float)(Mathf.pow((float)this.hitSize, (float)0.75f) * this.type.crashDamageMultiplier * 5.0f * Vars.state.rules.unitCrashDamage(this.team)), (boolean)true, (boolean)false, (boolean)true);
        }
        if (!Vars.headless && this.type.createScorch) {
            for (int i = 0; i < this.type.wreckRegions.length; ++i) {
                if (!this.type.wreckRegions[i].found()) continue;
                float range = this.type.hitSize / 4.0f;
                Tmp.v1.rnd(range);
                Effect.decal((TextureRegion)this.type.wreckRegions[i], (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)(this.rotation - 90.0f));
            }
        }
        for (WeaponMount weaponMount : this.abilities) {
            weaponMount.death((Unit)this);
        }
        this.type.killed((Unit)this);
        this.remove();
    }

    public void display(Table table) {
        this.type.display((Unit)this, table);
    }

    public void draw() {
        this.type.draw((Unit)this);
        for (StatusEntry e : this.statuses) {
            e.effect.draw((Unit)this, e.time);
        }
        this.drawBuilding();
        if (this.mining()) {
            float focusLen = this.hitSize / 2.0f + Mathf.absin((float)Time.time, (float)1.1f, (float)0.5f);
            float swingScl = 12.0f;
            float swingMag = 1.0f;
            float flashScl = 0.3f;
            float px = this.x + Angles.trnsx((float)this.rotation, (float)focusLen);
            float py = this.y + Angles.trnsy((float)this.rotation, (float)focusLen);
            float ex = this.mineTile.worldx() + Mathf.sin((float)(Time.time + 48.0f), (float)swingScl, (float)swingMag);
            float ey = this.mineTile.worldy() + Mathf.sin((float)(Time.time + 48.0f), (float)(swingScl + 2.0f), (float)swingMag);
            Draw.z((float)115.1f);
            Draw.color((Color)Color.lightGray, (Color)Color.white, (float)(1.0f - flashScl + Mathf.absin((float)Time.time, (float)0.5f, (float)flashScl)));
            Drawf.laser((TextureRegion)Core.atlas.find("minelaser"), (TextureRegion)Core.atlas.find("minelaser-end"), (float)px, (float)py, (float)ex, (float)ey, (float)0.75f);
            if (this.isLocal()) {
                Lines.stroke((float)1.0f, (Color)Pal.accent);
                Lines.poly((float)this.mineTile.worldx(), (float)this.mineTile.worldy(), (int)4, (float)(4.0f * Mathf.sqrt2), (float)Time.time);
            }
            Draw.color();
        }
    }

    public void drawBuildPlans() {
        Boolf skip = plan -> plan.progress > 0.01f || this.buildPlan() == plan && plan.initialized && (this.within(plan.x * 8, plan.y * 8, this.type.buildRange) || Vars.state.isEditor());
        for (int i = 0; i < 2; ++i) {
            for (BuildPlan plan2 : this.plans) {
                if (skip.get((Object)plan2)) continue;
                if (i == 0) {
                    this.drawPlan(plan2, 1.0f);
                    continue;
                }
                this.drawPlanTop(plan2, 1.0f);
            }
        }
        Draw.reset();
    }

    public void drawBuilding() {
        boolean active = this.activelyBuilding();
        if (!active && this.lastActive == null) {
            return;
        }
        Draw.z((float)115.0f);
        BuildPlan plan = active ? this.buildPlan() : this.lastActive;
        Tile tile = plan.tile();
        CoreBlock.CoreBuild core = this.team.core();
        if (tile == null || !this.within((Position)plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
            return;
        }
        if (core != null && active && !this.isLocal() && !(tile.block() instanceof ConstructBlock)) {
            Draw.z((float)84.0f);
            this.drawPlan(plan, 0.5f);
            this.drawPlanTop(plan, 0.5f);
            Draw.z((float)115.0f);
        }
        if (this.type.drawBuildBeam) {
            float focusLen = this.type.buildBeamOffset + Mathf.absin((float)Time.time, (float)3.0f, (float)0.6f);
            float px = this.x + Angles.trnsx((float)this.rotation, (float)focusLen);
            float py = this.y + Angles.trnsy((float)this.rotation, (float)focusLen);
            this.drawBuildingBeam(px, py);
        }
    }

    public void drawBuildingBeam(float px, float py) {
        boolean active = this.activelyBuilding();
        if (!active && this.lastActive == null) {
            return;
        }
        Draw.z((float)115.0f);
        BuildPlan plan = active ? this.buildPlan() : this.lastActive;
        Tile tile = Vars.world.tile(plan.x, plan.y);
        if (tile == null || !this.within((Position)plan, Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange)) {
            return;
        }
        int size = plan.breaking ? (active ? tile.block().size : this.lastSize) : plan.block.size;
        float tx = plan.drawx();
        float ty = plan.drawy();
        Lines.stroke((float)1.0f, (Color)(plan.breaking ? Pal.remove : Pal.accent));
        Draw.z((float)122.0f);
        Draw.alpha((float)this.buildAlpha);
        if (!active && !(tile.build instanceof ConstructBlock.ConstructBuild)) {
            Fill.square((float)plan.drawx(), (float)plan.drawy(), (float)((float)(size * 8) / 2.0f));
        }
        Drawf.buildBeam((float)px, (float)py, (float)tx, (float)ty, (float)((float)(8 * size) / 2.0f));
        Fill.square((float)px, (float)py, (float)(1.8f + Mathf.absin((float)Time.time, (float)2.2f, (float)1.1f)), (float)(this.rotation + 45.0f));
        Draw.reset();
        Draw.z((float)115.0f);
    }

    public void drawPlan(BuildPlan plan, float alpha) {
        plan.animScale = 1.0f;
        if (plan.breaking) {
            Vars.control.input.drawBreaking(plan);
        } else {
            plan.block.drawPlan(plan, Vars.control.input.allPlans(), Build.validPlace((Block)plan.block, (Team)this.team, (int)plan.x, (int)plan.y, (int)plan.rotation) || Vars.control.input.planMatches(plan), alpha);
        }
    }

    public void drawPlanTop(BuildPlan plan, float alpha) {
        if (!plan.breaking) {
            Draw.reset();
            Draw.mixcol((Color)Color.white, (float)(0.24f + Mathf.absin((float)Time.globalTime, (float)6.0f, (float)0.28f)));
            Draw.alpha((float)alpha);
            plan.block.drawPlanConfigTop(plan, (Eachable)this.plans);
        }
    }

    @Override
    public void drawSeed(long drawSeed) {
        this.drawSeed = drawSeed;
    }

    public void getCollisions(Cons<QuadTree> consumer) {
    }

    public void handleSyncHidden() {
        this.remove();
        Vars.netClient.clearRemovedEntity(this.id);
    }

    public void heal() {
        this.dead = false;
        this.health = this.maxHealth;
    }

    public void heal(float amount) {
        if (this.health < this.maxHealth && amount > 0.0f) {
            this.wasHealed = true;
        }
        this.health += amount;
        this.clampHealth();
    }

    public void healFract(float amount) {
        this.heal(amount * this.maxHealth);
    }

    public void hitbox(Rect rect) {
        rect.setCentered(this.x, this.y, this.hitSize, this.hitSize);
    }

    public void hitboxTile(Rect rect) {
        float size = Math.min(this.hitSize * 0.66f, 7.9f);
        rect.setCentered(this.x, this.y, size, size);
    }

    public void impulse(Vec2 v) {
        this.impulse(v.x, v.y);
    }

    public void impulse(float x, float y) {
        float mass = this.mass();
        this.vel.add(x / mass, y / mass);
    }

    public void impulseNet(Vec2 v) {
        this.impulse(v.x, v.y);
        if (this.isRemote()) {
            float mass = this.mass();
            this.move(v.x / mass, v.y / mass);
        }
    }

    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis((long)this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.rotation = Mathf.slerp((float)this.rotation_LAST_, (float)this.rotation_TARGET_, (float)alpha);
            this.x = Mathf.lerp((float)this.x_LAST_, (float)this.x_TARGET_, (float)alpha);
            this.y = Mathf.lerp((float)this.y_LAST_, (float)this.y_TARGET_, (float)alpha);
        } else if (this.lastUpdated != 0L) {
            this.rotation = this.rotation_TARGET_;
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    public void kill() {
        if (this.dead || Vars.net.client() || !this.type.killable) {
            return;
        }
        Call.unitDeath((int)this.id);
    }

    public void killed() {
        this.wasPlayer = this.isLocal();
        this.health = Math.min(this.health, 0.0f);
        this.dead = true;
        if (!this.type.flying || !this.type.createWreck) {
            this.destroy();
        }
    }

    public void landed() {
        if (this.type.mechLandShake > 0.0f) {
            Effect.shake((float)this.type.mechLandShake, (float)this.type.mechLandShake, (Position)this);
        }
        this.type.landed((Unit)this);
    }

    public void lookAt(Position pos) {
        this.lookAt(this.angleTo(pos));
    }

    public void lookAt(float angle) {
        this.rotation = Angles.moveToward((float)this.rotation, (float)angle, (float)(this.type.rotateSpeed * Time.delta * this.speedMultiplier()));
    }

    public void lookAt(float x, float y) {
        this.lookAt(this.angleTo(x, y));
    }

    public void move(Vec2 v) {
        this.move(v.x, v.y);
    }

    public void move(float cx, float cy) {
        EntityCollisions.SolidPred check = this.solidity();
        if (check != null) {
            Vars.collisions.move((Hitboxc)this, cx, cy, check);
        } else {
            this.x += cx;
            this.y += cy;
        }
    }

    public void moveAt(Vec2 vector) {
        this.moveAt(vector, this.type.accel);
    }

    public void moveAt(Vec2 vector, float acceleration) {
        Vec2 t = tmp1.set(vector);
        tmp2.set(t).sub(this.vel).limit(acceleration * vector.len() * Time.delta);
        this.vel.add(tmp2);
    }

    public void movePref(Vec2 movement) {
        if (this.type.omniMovement) {
            this.moveAt(movement);
        } else {
            this.rotateMove(movement);
        }
    }

    public void rawDamage(float amount) {
        boolean hadShields;
        boolean bl = hadShields = this.shield > 1.0E-4f;
        if (hadShields) {
            this.shieldAlpha = 1.0f;
        }
        float shieldDamage = Math.min(Math.max(this.shield, 0.0f), amount);
        this.shield -= shieldDamage;
        this.hitTime = 1.0f;
        if ((amount -= shieldDamage) > 0.0f && this.type.killable) {
            this.health -= amount;
            if (this.health <= 0.0f && !this.dead) {
                this.kill();
            }
            if (hadShields && this.shield <= 1.0E-4f) {
                Fx.unitShieldBreak.at(this.x, this.y, 0.0f, this.team.color, (Object)this);
            }
        }
    }

    public void read(Reads read) {
        short REV = read.s();
        switch (REV) {
            case 0: {
                this.abilities = TypeIO.readAbilities((Reads)read, (Ability[])this.abilities);
                this.ammo = read.f();
                this.bladeMoveSpeedScl = read.f();
                int blades_LENGTH = read.i();
                this.blades = new Blade.BladeMount[blades_LENGTH];
                for (int INDEX = 0; INDEX < blades_LENGTH; ++INDEX) {
                }
                this.controller = TypeIO.readController((Reads)read, (UnitController)this.controller);
                this.drawSeed = read.l();
                this.driftAngle = read.f();
                this.elevation = read.f();
                this.flag = read.d();
                this.hasDriftAngle = read.bool();
                this.health = read.f();
                this.isShooting = read.bool();
                this.mineTile = TypeIO.readTile((Reads)read);
                this.mounts = TypeIO.readMounts((Reads)read, (WeaponMount[])this.mounts);
                this.plans = TypeIO.readPlansQueue((Reads)read);
                this.rotation = read.f();
                this.shield = read.f();
                this.spawnedByCore = read.bool();
                this.stack = TypeIO.readItems((Reads)read, (ItemStack)this.stack);
                int statuses_LENGTH = read.i();
                this.statuses.clear();
                for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
                    StatusEntry statuses_ITEM = TypeIO.readStatus((Reads)read);
                    if (statuses_ITEM == null) continue;
                    this.statuses.add((Object)statuses_ITEM);
                }
                this.team = TypeIO.readTeam((Reads)read);
                this.type = (UnitType)Vars.content.getByID(ContentType.unit, (int)read.s());
                this.updateBuilding = read.bool();
                this.vel = TypeIO.readVec2((Reads)read, (Vec2)this.vel);
                this.x = read.f();
                this.y = read.f();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown revision '" + REV + "' for entities type 'OrnitopterFlyingUnit'");
            }
        }
        this.afterRead();
    }

    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.abilities = TypeIO.readAbilities((Reads)read, (Ability[])this.abilities);
        this.ammo = read.f();
        this.bladeMoveSpeedScl = read.f();
        int blades_LENGTH = read.i();
        this.blades = new Blade.BladeMount[blades_LENGTH];
        for (int INDEX = 0; INDEX < blades_LENGTH; ++INDEX) {
        }
        this.controller = TypeIO.readController((Reads)read, (UnitController)this.controller);
        this.drawSeed = read.l();
        this.driftAngle = read.f();
        if (!islocal) {
            this.elevation = read.f();
        } else {
            read.f();
        }
        this.flag = read.d();
        this.hasDriftAngle = read.bool();
        this.health = read.f();
        this.isShooting = read.bool();
        if (!islocal) {
            this.mineTile = TypeIO.readTile((Reads)read);
        } else {
            TypeIO.readTile((Reads)read);
        }
        if (!islocal) {
            this.mounts = TypeIO.readMounts((Reads)read, (WeaponMount[])this.mounts);
        } else {
            TypeIO.readMounts((Reads)read);
        }
        if (!islocal) {
            this.plans = TypeIO.readPlansQueue((Reads)read);
        } else {
            TypeIO.readPlansQueue((Reads)read);
        }
        if (!islocal) {
            this.rotation_LAST_ = this.rotation;
            this.rotation_TARGET_ = read.f();
        } else {
            read.f();
            this.rotation_LAST_ = this.rotation;
            this.rotation_TARGET_ = this.rotation;
        }
        this.shield = read.f();
        this.spawnedByCore = read.bool();
        this.stack = TypeIO.readItems((Reads)read, (ItemStack)this.stack);
        int statuses_LENGTH = read.i();
        this.statuses.clear();
        for (int INDEX = 0; INDEX < statuses_LENGTH; ++INDEX) {
            StatusEntry statuses_ITEM = TypeIO.readStatus((Reads)read);
            if (statuses_ITEM == null) continue;
            this.statuses.add((Object)statuses_ITEM);
        }
        this.team = TypeIO.readTeam((Reads)read);
        this.type = (UnitType)Vars.content.getByID(ContentType.unit, (int)read.s());
        if (!islocal) {
            this.updateBuilding = read.bool();
        } else {
            read.bool();
        }
        if (!islocal) {
            this.vel = TypeIO.readVec2((Reads)read, (Vec2)this.vel);
        } else {
            TypeIO.readVec2((Reads)read);
        }
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation;
        this.rotation_TARGET_ = buffer.get();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.unit.remove((Entityc)this);
        Groups.draw.remove((Entityc)this);
        Groups.sync.remove((Entityc)this);
        Groups.all.remove((Entityc)this);
        this.team.data().updateCount(this.type, -1);
        this.controller.removed((Unit)this);
        if (this.trail != null && this.trail.size() > 0) {
            Fx.trailFade.at(this.x, this.y, this.trail.width(), this.type.trailColor == null ? this.team.color : this.type.trailColor, (Object)this.trail.copy());
        }
        for (WeaponMount mount : this.mounts) {
            if (mount.weapon.continuous && mount.bullet != null && mount.bullet.owner == this) {
                mount.bullet.time = mount.bullet.lifetime - 10.0f;
                mount.bullet = null;
            }
            if (mount.sound == null) continue;
            mount.sound.stop();
        }
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
        this.added = false;
    }

    public void removeBuild(int x, int y, boolean breaking) {
        int idx = this.plans.indexOf(req -> req.breaking == breaking && req.x == x && req.y == y);
        if (idx != -1) {
            this.plans.removeIndex(idx);
        }
    }

    public void resetController() {
        this.controller(this.type.createController((Unit)this));
    }

    public void rotateMove(Vec2 vec) {
        this.moveAt(Tmp.v2.trns(this.rotation, vec.len()));
        if (!vec.isZero()) {
            this.rotation = Angles.moveToward((float)this.rotation, (float)vec.angle(), (float)(this.type.rotateSpeed * Time.delta));
        }
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(UnitType def, UnitController controller) {
        if (this.type != def) {
            this.setType(def);
        }
        this.controller(controller);
    }

    @Override
    public void setBlades(UnitType type) {
        if (type instanceof OrnitopterUnitType) {
            OrnitopterUnitType ornitopter = (OrnitopterUnitType)type;
            this.blades = new Blade.BladeMount[ornitopter.blades.size];
            for (int i = 0; i < this.blades.length; ++i) {
                Blade bladeType = (Blade)ornitopter.blades.get(i);
                this.blades[i] = new Blade.BladeMount(bladeType);
            }
        }
    }

    public void setProp(UnlockableContent content, double value) {
        if (content instanceof Item) {
            Item item;
            this.stack.item = item = (Item)content;
            this.stack.amount = Mathf.clamp((int)((int)value), (int)0, (int)this.type.itemCapacity);
        }
    }

    public void setProp(LAccess prop, double value) {
        switch (prop) {
            case health: {
                this.health = (float)Mathf.clamp((double)value, (double)0.0, (double)this.maxHealth);
                if (!(this.health <= 0.0f) || this.dead) break;
                this.kill();
                break;
            }
            case x: {
                this.x = World.unconv((float)((float)value));
                break;
            }
            case y: {
                this.y = World.unconv((float)((float)value));
                break;
            }
            case rotation: {
                this.rotation = (float)value;
                break;
            }
            case team: {
                if (Vars.net.client()) break;
                Team team = Team.get((int)((int)value));
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    p.team(team);
                }
                this.team = team;
                break;
            }
            case flag: {
                this.flag = value;
            }
        }
    }

    public void setProp(LAccess prop, Object value) {
        switch (prop) {
            case team: {
                if (!(value instanceof Team)) break;
                Team t = (Team)value;
                if (Vars.net.client()) break;
                UnitController unitController = this.controller;
                if (unitController instanceof Player) {
                    Player p = (Player)unitController;
                    p.team(t);
                }
                this.team = t;
                break;
            }
            case payloadType: {
                OrnitopterFlyingUnit p = this;
                if (!(p instanceof Payloadc)) break;
                Payloadc pay = (Payloadc)p;
                if (Vars.net.client()) break;
                if (value instanceof Block) {
                    Block b = (Block)value;
                    Building build = b.newBuilding().create(b, this.team());
                    if (!pay.canPickup(build)) break;
                    pay.addPayload((Payload)new BuildPayload(build));
                    break;
                }
                if (value instanceof UnitType) {
                    UnitType ut = (UnitType)value;
                    Unit unit = ut.create(this.team());
                    if (!pay.canPickup(unit)) break;
                    pay.addPayload((Payload)new UnitPayload(unit));
                    break;
                }
                if (value != null || pay.payloads().size <= 0) break;
                pay.payloads().pop();
            }
        }
    }

    public void setType(UnitType type) {
        this.type = type;
        this.maxHealth = type.health;
        this.drag = type.drag;
        this.armor = type.armor;
        this.hitSize = type.hitSize;
        this.hovering = type.hovering;
        if (this.controller == null) {
            this.controller(type.createController((Unit)this));
        }
        if (this.mounts().length != type.weapons.size) {
            this.setupWeapons(type);
        }
        if (this.abilities.length != type.abilities.size) {
            this.abilities = new Ability[type.abilities.size];
            for (int i = 0; i < type.abilities.size; ++i) {
                this.abilities[i] = ((Ability)type.abilities.get(i)).copy();
            }
        }
        this.setBlades(type);
    }

    public void setWeaponRotation(float rotation) {
        for (WeaponMount mount : this.mounts) {
            mount.rotation = rotation;
        }
    }

    public void setupWeapons(UnitType def) {
        this.mounts = new WeaponMount[def.weapons.size];
        for (int i = 0; i < this.mounts.length; ++i) {
            this.mounts[i] = (WeaponMount)((Weapon)def.weapons.get((int)i)).mountType.get((Object)((Weapon)def.weapons.get(i)));
        }
    }

    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation;
        this.rotation_TARGET_ = this.rotation;
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.rotation_LAST_ = this.rotation_TARGET_;
        this.rotation = this.rotation_TARGET_;
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void unapply(StatusEffect effect) {
        this.statuses.remove(e -> {
            if (e.effect == effect) {
                Pools.free((Object)e);
                return true;
            }
            return false;
        });
    }

    public void unloaded() {
    }

    public void update() {
        if (!Vars.net.client() || this.isLocal()) {
            float px = this.x;
            float py = this.y;
            this.move(this.vel.x * Time.delta, this.vel.y * Time.delta);
            if (Mathf.equal((float)px, (float)this.x)) {
                this.vel.x = 0.0f;
            }
            if (Mathf.equal((float)py, (float)this.y)) {
                this.vel.y = 0.0f;
            }
            this.vel.scl(Math.max(1.0f - this.drag * Time.delta, 0.0f));
        }
        this.type.update((Unit)this);
        if (this.wasHealed && this.healTime <= -1.0f) {
            this.healTime = 1.0f;
        }
        this.healTime -= Time.delta / 20.0f;
        this.wasHealed = false;
        if (this.team.isOnlyAI() && Vars.state.isCampaign() && Vars.state.getSector().isCaptured()) {
            this.kill();
        }
        if (!Vars.headless && this.type.loopSound != Sounds.none) {
            Vars.control.sound.loop(this.type.loopSound, (Position)this, this.type.loopSoundVolume);
        }
        if (!this.type.supportsEnv(Vars.state.rules.env) && !this.dead) {
            Call.unitEnvDeath((Unit)this);
            this.team.data().updateCount(this.type, -1);
        }
        if (Vars.state.rules.unitAmmo && this.ammo < (float)this.type.ammoCapacity - 1.0E-4f) {
            this.resupplyTime += Time.delta;
            if (this.resupplyTime > 10.0f) {
                this.type.ammoType.resupply((Unit)this);
                this.resupplyTime = 0.0f;
            }
        }
        for (Ability a : this.abilities) {
            a.update((Unit)this);
        }
        if (this.trail != null) {
            this.trail.length = this.type.trailLength;
            float scale = this.type.useEngineElevation ? this.elevation : 1.0f;
            float offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * scale;
            float cx = this.x + Angles.trnsx((float)(this.rotation + 180.0f), (float)offset);
            float cy = this.y + Angles.trnsy((float)(this.rotation + 180.0f), (float)offset);
            this.trail.update(cx, cy);
        }
        this.drag = this.type.drag * (this.isGrounded() ? this.floorOn().dragMultiplier : 1.0f) * this.dragMultiplier * Vars.state.rules.dragMultiplier;
        if (this.team != Vars.state.rules.waveTeam && Vars.state.hasSpawns() && (!Vars.net.client() || this.isLocal()) && this.hittable()) {
            float relativeSize = Vars.state.rules.dropZoneRadius + this.hitSize / 2.0f + 1.0f;
            for (Tile spawn : Vars.spawner.getSpawns()) {
                if (!this.within(spawn.worldx(), spawn.worldy(), relativeSize)) continue;
                this.velAddNet(Tmp.v1.set((Position)this).sub(spawn.worldx(), spawn.worldy()).setLength(1.1f - this.dst((Position)spawn) / relativeSize).scl(0.45f * Time.delta));
            }
        }
        if (this.dead || this.health <= 0.0f) {
            this.drag = 0.01f;
            if (Mathf.chanceDelta((double)0.1)) {
                Tmp.v1.rnd(Mathf.range((float)this.hitSize));
                this.type.fallEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
            }
            if (Mathf.chanceDelta((double)0.2)) {
                float offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * this.elevation;
                float range = Mathf.range((float)this.type.engineSize);
                this.type.fallEngineEffect.at(this.x + Angles.trnsx((float)(this.rotation + 180.0f), (float)offset) + Mathf.range((float)range), this.y + Angles.trnsy((float)(this.rotation + 180.0f), (float)offset) + Mathf.range((float)range), Mathf.random());
            }
            this.elevation -= this.type.fallSpeed * Time.delta;
            if (this.isGrounded() || this.health <= -this.maxHealth) {
                Call.unitDestroy((int)this.id);
            }
        }
        Tile tile = this.tileOn();
        Floor floor = this.floorOn();
        if (tile != null && this.isGrounded() && !this.type.hovering) {
            if (tile.build != null) {
                tile.build.unitOn((Unit)this);
            }
            if (floor.damageTaken > 0.0f) {
                this.damageContinuous(floor.damageTaken);
            }
        }
        if (tile != null && !this.canPassOn()) {
            if (this.type.canBoost) {
                this.elevation = 1.0f;
            } else if (!Vars.net.client()) {
                this.kill();
            }
        }
        if (!Vars.net.client() && !this.dead) {
            this.controller.updateUnit();
        }
        if (!this.controller.isValidController()) {
            this.resetController();
        }
        if (this.spawnedByCore && !this.isPlayer() && !this.dead) {
            Call.unitDespawn((Unit)this);
        }
        Floor floor2 = this.floorOn();
        if (this.isFlying() != this.wasFlying) {
            if (this.wasFlying && this.tileOn() != null) {
                Fx.unitLand.at(this.x, this.y, this.floorOn().isLiquid ? 1.0f : 0.5f, this.tileOn().floor().mapColor);
            }
            this.wasFlying = this.isFlying();
        }
        if (!this.hovering && this.isGrounded()) {
            float f;
            this.splashTimer += Mathf.dst((float)this.deltaX(), (float)this.deltaY());
            if (f >= 7.0f + this.hitSize() / 8.0f) {
                floor2.walkEffect.at(this.x, this.y, this.hitSize() / 8.0f, floor2.mapColor);
                this.splashTimer = 0.0f;
                if (this.emitWalkSound()) {
                    floor2.walkSound.at(this.x, this.y, Mathf.random((float)floor2.walkSoundPitchMin, (float)floor2.walkSoundPitchMax), floor2.walkSoundVolume);
                }
            }
        }
        this.updateDrowning();
        ++this.drawSeed;
        OrnitopterUnitType type = (OrnitopterUnitType)this.type;
        float rX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)type.fallSmokeX, (float)type.fallSmokeY);
        float rY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)type.fallSmokeX, (float)type.fallSmokeY);
        if (this.dead || this.health() <= 0.0f) {
            if (Mathf.chanceDelta((double)type.fallSmokeChance)) {
                Fx.fallSmoke.at(rX, rY);
                Fx.burning.at(rX, rY);
            }
            if (!this.hasDriftAngle) {
                float speed = Math.max(Math.abs(this.vel().x), Math.abs(this.vel().y));
                float maxAngle = Math.min(180.0f, speed * type.fallDriftScl);
                this.driftAngle = (Angles.angle((float)this.x, (float)this.y, (float)(this.x + this.vel().x), (float)(this.y + this.vel().y)) + Mathf.range((float)maxAngle)) % 360.0f;
                this.hasDriftAngle = true;
            }
            float driftSpeed = Math.max(0.0f, this.vel().len() - this.type().drag) * type.accel;
            float driftX = driftSpeed * Mathf.cosDeg((float)this.driftAngle);
            float driftY = driftSpeed * Mathf.sinDeg((float)this.driftAngle);
            this.move(driftX, driftY);
            this.rotation = Mathf.lerpDelta((float)this.rotation, (float)this.driftAngle, (float)0.01f);
            this.bladeMoveSpeedScl = Mathf.lerpDelta((float)this.bladeMoveSpeedScl, (float)0.0f, (float)type.bladeDeathMoveSlowdown);
        } else {
            this.hasDriftAngle = false;
            this.bladeMoveSpeedScl = Mathf.lerpDelta((float)this.bladeMoveSpeedScl, (float)1.0f, (float)type.bladeDeathMoveSlowdown);
        }
        for (Blade.BladeMount blade : this.blades) {
            blade.bladeRotation += (blade.blade.bladeMaxMoveAngle * this.bladeMoveSpeedScl + blade.blade.bladeMinMoveAngle) * Time.delta;
        }
        type.fallSpeed = 0.01f;
        floor2 = this.floorOn();
        if (this.isGrounded() && !this.type.hovering) {
            this.apply(floor2.status, floor2.statusDuration);
        }
        this.applied.clear();
        this.dragMultiplier = 1.0f;
        this.buildSpeedMultiplier = 1.0f;
        this.reloadMultiplier = 1.0f;
        this.healthMultiplier = 1.0f;
        this.damageMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.disarmed = false;
        if (!this.statuses.isEmpty()) {
            int index = 0;
            while (index < this.statuses.size) {
                StatusEntry entry = (StatusEntry)this.statuses.get(index++);
                entry.time = Math.max(entry.time - Time.delta, 0.0f);
                if (entry.effect == null || entry.time <= 0.0f && !entry.effect.permanent) {
                    Pools.free((Object)entry);
                    this.statuses.remove(--index);
                    continue;
                }
                this.applied.set((int)entry.effect.id);
                this.speedMultiplier *= entry.effect.speedMultiplier;
                this.healthMultiplier *= entry.effect.healthMultiplier;
                this.damageMultiplier *= entry.effect.damageMultiplier;
                this.reloadMultiplier *= entry.effect.reloadMultiplier;
                this.buildSpeedMultiplier *= entry.effect.buildSpeedMultiplier;
                this.dragMultiplier *= entry.effect.dragMultiplier;
                this.disarmed |= entry.effect.disarm;
                entry.effect.update((Unit)this, entry.time);
            }
        }
        this.updateBuildLogic();
        if (this.mineTile != null) {
            int accepted;
            WeaponMount[] core = this.closestCore();
            Item item = this.getMineResult(this.mineTile);
            if (core != null && item != null && !this.acceptsItem(item) && this.within((Position)core, 220.0f) && !this.offloadImmediately() && (accepted = core.acceptStack(this.item(), this.stack().amount, (Teamc)this)) > 0) {
                Call.transferItemTo((Unit)this, (Item)this.item(), (int)accepted, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Building)core);
                this.clearItem();
            }
            if (!(Vars.net.client() && !this.isLocal() || this.validMine(this.mineTile))) {
                this.mineTile = null;
                this.mineTimer = 0.0f;
            } else if (this.mining() && item != null) {
                this.mineTimer += Time.delta * this.type.mineSpeed;
                if (Mathf.chance((double)(0.06 * (double)Time.delta))) {
                    Fx.pulverizeSmall.at(this.mineTile.worldx() + Mathf.range((float)4.0f), this.mineTile.worldy() + Mathf.range((float)4.0f), 0.0f, item.color);
                }
                float f = this.type.mineHardnessScaling ? (float)item.hardness * 15.0f : 15.0f;
                if (this.mineTimer >= 50.0f + f) {
                    this.mineTimer = 0.0f;
                    if (Vars.state.rules.sector != null && this.team() == Vars.state.rules.defaultTeam) {
                        Vars.state.rules.sector.info.handleProduction(item, 1);
                    }
                    if (core != null && this.within((Position)core, 220.0f) && core.acceptStack(item, 1, (Teamc)this) == 1 && this.offloadImmediately()) {
                        if (this.item() == item && !Vars.net.client()) {
                            this.addItem(item);
                        }
                        Call.transferItemTo((Unit)this, (Item)item, (int)1, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Building)core);
                    } else if (this.acceptsItem(item)) {
                        InputHandler.transferItemToUnit((Item)item, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Itemsc)this);
                    } else {
                        this.mineTile = null;
                        this.mineTimer = 0.0f;
                    }
                }
                if (!Vars.headless) {
                    Vars.control.sound.loop(this.type.mineSound, (Position)this, this.type.mineSoundVolume);
                }
            }
        }
        this.stack.amount = Mathf.clamp((int)this.stack.amount, (int)0, (int)this.itemCapacity());
        this.itemTime = Mathf.lerpDelta((float)this.itemTime, (float)Mathf.num((boolean)this.hasItem()), (float)0.05f);
        for (WeaponMount mount : this.mounts) {
            mount.weapon.update((Unit)this, mount);
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
        this.hitTime -= Time.delta / 9.0f;
        if (this.type.bounded) {
            float bot = 0.0f;
            float left = 0.0f;
            float top = Vars.world.unitHeight();
            float right = Vars.world.unitWidth();
            if (Vars.state.rules.limitMapArea && !this.team.isAI()) {
                bot = Vars.state.rules.limitY * 8;
                left = Vars.state.rules.limitX * 8;
                top = (float)(Vars.state.rules.limitHeight * 8) + bot;
                right = (float)(Vars.state.rules.limitWidth * 8) + left;
            }
            if (!Vars.net.client() || this.isLocal()) {
                float dx = 0.0f;
                float dy = 0.0f;
                if (this.x < left) {
                    dx += -(this.x - left) / 30.0f;
                }
                if (this.y < bot) {
                    dy += -(this.y - bot) / 30.0f;
                }
                if (this.x > right) {
                    dx -= (this.x - right) / 30.0f;
                }
                if (this.y > top) {
                    dy -= (this.y - top) / 30.0f;
                }
                this.velAddNet(dx * Time.delta, dy * Time.delta);
            }
            if (this.isGrounded()) {
                this.x = Mathf.clamp((float)this.x, (float)left, (float)(right - 8.0f));
                this.y = Mathf.clamp((float)this.y, (float)bot, (float)(top - 8.0f));
            }
            if (this.x < -250.0f + left || this.y < -250.0f + bot || this.x >= right + 250.0f || this.y >= top + 250.0f) {
                this.kill();
            }
        }
        this.shieldAlpha -= Time.delta / 15.0f;
        if (this.shieldAlpha < 0.0f) {
            this.shieldAlpha = 0.0f;
        }
    }

    public void updateBoosting(boolean boost) {
        if (!this.type.canBoost || this.dead) {
            return;
        }
        this.elevation = Mathf.approachDelta((float)this.elevation, (float)(this.type.canBoost ? (float)Mathf.num((boost || this.onSolid() || this.isFlying() && !this.canLand() ? 1 : 0) != 0) : 0.0f), (float)this.type.riseSpeed);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateBuildLogic() {
        if (this.type.buildSpeed <= 0.0f) {
            return;
        }
        if (!Vars.headless) {
            if (this.lastActive != null && this.buildAlpha <= 0.01f) {
                this.lastActive = null;
            }
            this.buildAlpha = Mathf.lerpDelta((float)this.buildAlpha, (float)(this.activelyBuilding() ? 1.0f : 0.0f), (float)0.15f);
        }
        if (!this.updateBuilding || !this.canBuild()) {
            this.validatePlans();
            return;
        }
        float finalPlaceDst = Vars.state.rules.infiniteResources ? Float.MAX_VALUE : this.type.buildRange;
        boolean infinite = Vars.state.rules.infiniteResources || this.team().rules().infiniteResources;
        this.buildCounter += Time.delta;
        if (Float.isNaN(this.buildCounter) || Float.isInfinite(this.buildCounter)) {
            this.buildCounter = 0.0f;
        }
        this.buildCounter = Math.min(this.buildCounter, 10.0f);
        int maxPerFrame = 10;
        int count = 0;
        while (this.buildCounter >= 1.0f && count++ < maxPerFrame) {
            Building hasAll2;
            Tile tile;
            BuildPlan current;
            CoreBlock.CoreBuild core;
            block24: {
                block28: {
                    ConstructBlock.ConstructBuild cb;
                    block26: {
                        block27: {
                            block25: {
                                Building building;
                                this.buildCounter -= 1.0f;
                                this.validatePlans();
                                core = this.core();
                                if (this.buildPlan() == null) {
                                    return;
                                }
                                if (this.plans.size > 1) {
                                    BuildPlan plan;
                                    int size = this.plans.size;
                                    for (int total = 0; (!this.within((Position)(plan = this.buildPlan()).tile(), finalPlaceDst) || this.shouldSkip(plan, (Building)core)) && total < size; ++total) {
                                        this.plans.removeFirst();
                                        this.plans.addLast((Object)plan);
                                    }
                                }
                                current = this.buildPlan();
                                tile = current.tile();
                                this.lastActive = current;
                                this.buildAlpha = 1.0f;
                                if (current.breaking) {
                                    this.lastSize = tile.block().size;
                                }
                                if (!this.within((Position)tile, finalPlaceDst)) continue;
                                if (!Vars.headless) {
                                    Vars.control.sound.loop(Sounds.build, (Position)tile, 0.15f);
                                }
                                if (!((building = tile.build) instanceof ConstructBlock.ConstructBuild)) break block25;
                                cb = (ConstructBlock.ConstructBuild)building;
                                if (tile.team() == this.team) break block26;
                                break block27;
                            }
                            if (!current.initialized && !current.breaking && Build.validPlace((Block)current.block, (Team)this.team, (int)current.x, (int)current.y, (int)current.rotation)) {
                                boolean hasAll2;
                                boolean bl = hasAll2 = infinite || current.isRotation(this.team) || !Structs.contains((Object[])current.block.requirements, i -> core != null && !core.items.has(i.item, Math.min(Mathf.round((float)((float)i.amount * Vars.state.rules.buildCostMultiplier)), 1)));
                                if (hasAll2) {
                                    Call.beginPlace((Unit)this, (Block)current.block, (Team)this.team, (int)current.x, (int)current.y, (int)current.rotation);
                                    break block24;
                                } else {
                                    current.stuck = true;
                                }
                                break block24;
                            } else if (!current.initialized && current.breaking && Build.validBreak((Team)this.team, (int)current.x, (int)current.y)) {
                                Call.beginBreak((Unit)this, (Team)this.team, (int)current.x, (int)current.y);
                                break block24;
                            } else {
                                this.plans.removeFirst();
                                continue;
                            }
                        }
                        if (tile.team() != Team.derelict) break block28;
                    }
                    if (current.breaking || cb.current == current.block && cb.tile == current.tile()) break block24;
                }
                this.plans.removeFirst();
                continue;
            }
            if (tile.build instanceof ConstructBlock.ConstructBuild && !current.initialized) {
                Events.fire((Object)new EventType.BuildSelectEvent(tile, this.team, (Unit)this, current.breaking));
                current.initialized = true;
            }
            if (core == null && !infinite || !((hasAll2 = tile.build) instanceof ConstructBlock.ConstructBuild)) continue;
            ConstructBlock.ConstructBuild entity = (ConstructBlock.ConstructBuild)hasAll2;
            float bs = 1.0f / entity.buildCost * this.type.buildSpeed * this.buildSpeedMultiplier * Vars.state.rules.buildSpeed(this.team);
            if (current.breaking) {
                entity.deconstruct((Unit)this, core, bs);
            } else {
                entity.construct((Unit)this, (Building)core, bs, current.config);
            }
            current.stuck = Mathf.equal((float)current.progress, (float)entity.progress);
            current.progress = entity.progress;
        }
    }

    public void updateDrowning() {
        Floor floor = this.drownFloor();
        if (floor != null && floor.isLiquid && floor.drownTime > 0.0f) {
            this.lastDrownFloor = floor;
            this.drownTime += Time.delta / floor.drownTime / this.type.drownTimeMultiplier;
            if (Mathf.chanceDelta((double)0.05f)) {
                floor.drownUpdateEffect.at(this.x, this.y, this.hitSize, floor.mapColor);
            }
            if (this.drownTime >= 0.999f && !Vars.net.client()) {
                this.kill();
                Events.fire((Object)new EventType.UnitDrownEvent((Unit)this));
            }
        } else {
            this.drownTime -= Time.delta / 50.0f;
        }
        this.drownTime = Mathf.clamp((float)this.drownTime);
    }

    public void updateLastPosition() {
        this.deltaX = this.x - this.lastX;
        this.deltaY = this.y - this.lastY;
        this.lastX = this.x;
        this.lastY = this.y;
    }

    public void validatePlans() {
        if (this.plans.size > 0) {
            Iterator it = this.plans.iterator();
            while (it.hasNext()) {
                BuildPlan plan = (BuildPlan)it.next();
                Tile tile = Vars.world.tile(plan.x, plan.y);
                if (tile != null && (!plan.breaking || tile.block() != Blocks.air) && (plan.breaking || (tile.build == null || tile.build.rotation != plan.rotation) && plan.block.rotate || tile.block() != plan.block && (plan.block == null || (!plan.block.isOverlay() || plan.block != tile.overlay()) && (!plan.block.isFloor() || plan.block != tile.floor())))) continue;
                it.remove();
            }
        }
    }

    public void velAddNet(Vec2 v) {
        this.vel.add(v);
        if (this.isRemote()) {
            this.x += v.x;
            this.y += v.y;
        }
    }

    public void velAddNet(float vx, float vy) {
        this.vel.add(vx, vy);
        if (this.isRemote()) {
            this.x += vx;
            this.y += vy;
        }
    }

    public void wobble() {
        this.x += Mathf.sin((float)(Time.time + (float)(this.id() % 10 * 12)), (float)25.0f, (float)0.05f) * Time.delta * this.elevation;
        this.y += Mathf.cos((float)(Time.time + (float)(this.id() % 10 * 12)), (float)25.0f, (float)0.05f) * Time.delta * this.elevation;
    }

    public void write(Writes write) {
        int INDEX;
        write.s(0);
        TypeIO.writeAbilities((Writes)write, (Ability[])this.abilities);
        write.f(this.ammo);
        write.f(this.bladeMoveSpeedScl);
        write.i(this.blades.length);
        for (INDEX = 0; INDEX < this.blades.length; ++INDEX) {
        }
        TypeIO.writeController((Writes)write, (UnitController)this.controller);
        write.l(this.drawSeed);
        write.f(this.driftAngle);
        write.f(this.elevation);
        write.d(this.flag);
        write.bool(this.hasDriftAngle);
        write.f(this.health);
        write.bool(this.isShooting);
        TypeIO.writeTile((Writes)write, (Tile)this.mineTile);
        TypeIO.writeMounts((Writes)write, (WeaponMount[])this.mounts);
        write.i(this.plans.size);
        for (INDEX = 0; INDEX < this.plans.size; ++INDEX) {
            TypeIO.writePlan((Writes)write, (BuildPlan)((BuildPlan)this.plans.get(INDEX)));
        }
        write.f(this.rotation);
        write.f(this.shield);
        write.bool(this.spawnedByCore);
        TypeIO.writeItems((Writes)write, (ItemStack)this.stack);
        write.i(this.statuses.size);
        for (INDEX = 0; INDEX < this.statuses.size; ++INDEX) {
            TypeIO.writeStatus((Writes)write, (StatusEntry)((StatusEntry)this.statuses.get(INDEX)));
        }
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        write.s((int)this.type.id);
        write.bool(this.updateBuilding);
        TypeIO.writeVec2((Writes)write, (Vec2)this.vel);
        write.f(this.x);
        write.f(this.y);
    }

    public void writeSync(Writes write) {
        int INDEX;
        TypeIO.writeAbilities((Writes)write, (Ability[])this.abilities);
        write.f(this.ammo);
        write.f(this.bladeMoveSpeedScl);
        write.i(this.blades.length);
        for (INDEX = 0; INDEX < this.blades.length; ++INDEX) {
        }
        TypeIO.writeController((Writes)write, (UnitController)this.controller);
        write.l(this.drawSeed);
        write.f(this.driftAngle);
        write.f(this.elevation);
        write.d(this.flag);
        write.bool(this.hasDriftAngle);
        write.f(this.health);
        write.bool(this.isShooting);
        TypeIO.writeTile((Writes)write, (Tile)this.mineTile);
        TypeIO.writeMounts((Writes)write, (WeaponMount[])this.mounts);
        TypeIO.writePlansQueueNet((Writes)write, (Queue)this.plans);
        write.f(this.rotation);
        write.f(this.shield);
        write.bool(this.spawnedByCore);
        TypeIO.writeItems((Writes)write, (ItemStack)this.stack);
        write.i(this.statuses.size);
        for (INDEX = 0; INDEX < this.statuses.size; ++INDEX) {
            TypeIO.writeStatus((Writes)write, (StatusEntry)((StatusEntry)this.statuses.get(INDEX)));
        }
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        write.s((int)this.type.id);
        write.bool(this.updateBuilding);
        TypeIO.writeVec2((Writes)write, (Vec2)this.vel);
        write.f(this.x);
        write.f(this.y);
    }

    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.rotation);
        buffer.put(this.x);
        buffer.put(this.y);
    }

    public static OrnitopterFlyingUnit create() {
        return new OrnitopterFlyingUnit();
    }
}

