/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.part;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class ConstructPart
extends DrawPart {
    public String suffix;
    @Nullable
    public String name;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.reload;
    public float finishTresh = 0.95f;
    public float x;
    public float y;
    public float rot;
    public float layerOffset = 0.0f;
    public float outlineLayerOffset = 0.0f;
    public TextureRegion constructRegion;
    public TextureRegion outlineRegion;

    public ConstructPart(String suffix) {
        this.suffix = suffix;
    }

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        float dx = params.x + Angles.trnsx((float)(params.rotation - 90.0f), (float)this.x, (float)this.y);
        float dy = params.y + Angles.trnsy((float)(params.rotation - 90.0f), (float)this.x, (float)this.y);
        float dr = params.rotation + this.rot - 90.0f;
        float prog = this.progress.getClamp(params);
        Draw.z((float)(z + this.outlineLayerOffset));
        Draw.rect((TextureRegion)this.outlineRegion, (float)dx, (float)dy, (float)dr);
        Draw.z((float)(z + this.layerOffset));
        if (prog < this.finishTresh) {
            Draw.draw((float)Draw.z(), () -> Drawf.construct((float)dx, (float)dy, (TextureRegion)this.constructRegion, (float)dr, (float)prog, (float)1.0f, (float)Time.time));
        } else {
            Draw.rect((TextureRegion)this.constructRegion, (float)dx, (float)dy, (float)dr);
        }
        Draw.z((float)z);
    }

    public void load(String name) {
        if (this.name == null) {
            this.name = name + this.suffix;
        }
        this.constructRegion = Core.atlas.find(this.name);
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
    }
}

